/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RElementValue;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.debug.core.IRVariable;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;
import org.eclipse.statet.rj.ts.core.RToolService;

@NonNullByDefault
public class RElementVariableValue<TRElement extends CombinedRElement>
extends RElementValue<TRElement> {
    protected final RElementVariable variable;

    public RElementVariableValue(RElementVariable variable) {
        super((RDebugTarget)variable.getDebugTarget(), variable.getCurrentElement(), variable.getCurrentStamp());
        this.variable = variable;
    }

    @Override
    public IRVariable getAssignedVariable() {
        return this.variable;
    }

    protected abstract class RDataLoader<V extends RObject>
    implements LazyRStore.Updater<V> {
        private @Nullable FQRObjectRef ref;

        public void scheduleUpdate(LazyRStore<V> store, final @Nullable RDataAssignment assignment, final // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable LazyRStore.Fragment<V> fragment, int flags, ProgressMonitor m) {
            final AtomicReference set = new AtomicReference();
            Object data = null;
            try {
                RMainThread thread;
                RMainThread rMainThread = thread = RElementVariableValue.this.variable.getThread();
                rMainThread.getClass();
                data = thread.loadData(new RMainThread.AccessDataRunnable<V>(rMainThread){

                    @Override
                    protected int getRequiredStamp() {
                        return ((RDataLoader)RDataLoader.this).RElementVariableValue.this.stamp;
                    }

                    private @Nullable FQRObjectRef getRef(ProgressMonitor m) {
                        if (RDataLoader.this.ref == null) {
                            RDataLoader.this.ref = this.getThread().createElementRef(((RDataLoader)RDataLoader.this).RElementVariableValue.this.element, this.getRequiredStamp(), m);
                        }
                        return RDataLoader.this.ref;
                    }

                    @Override
                    protected V doRun(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
                        FQRObjectRef ref = this.getRef(m);
                        if (ref == null) {
                            return null;
                        }
                        if (assignment != null) {
                            RDataLoader.this.doSet(ref, assignment, r, m);
                            set.set(Statuses.OK_STATUS);
                        }
                        if (fragment != null) {
                            return RDataLoader.this.doLoad(ref, fragment, r, m);
                        }
                        return null;
                    }
                });
            }
            finally {
                if (assignment != null) {
                    store.updateAssignment(assignment, (Status)set.get());
                }
                if (fragment != null) {
                    store.updateFragment(fragment, data);
                }
            }
        }

        protected void doSet(FQRObjectRef ref, RDataAssignment assignment, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
            throw new UnsupportedOperationException();
        }

        protected abstract V doLoad(FQRObjectRef var1, LazyRStore.Fragment<V> var2, RToolService var3, ProgressMonitor var4) throws StatusException, UnexpectedRDataException;
    }
}

