/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.IMarkerPositionResolver;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.breakpoints.TracepointEventBreakpointStatus;
import org.eclipse.statet.internal.r.debug.core.breakpoints.TracepointEventExceptionBreakpointStatus;
import org.eclipse.statet.internal.r.debug.core.breakpoints.TracepointEventMethodBreakpointStatus;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Immutable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.r.console.core.RDbg;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.core.model.RLangSourceElement;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.debug.core.IRDebugTarget;
import org.eclipse.statet.r.debug.core.RDebugModel;
import org.eclipse.statet.r.debug.core.breakpoints.IRBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRExceptionBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.IRMethodBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpointValidator;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.statet.r.nico.IRModelSrcref;
import org.eclipse.statet.r.nico.IRSrcref;
import org.eclipse.statet.r.nico.RSrcref;
import org.eclipse.statet.rj.server.dbg.DbgEnablement;
import org.eclipse.statet.rj.server.dbg.ElementTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.ElementTracepoints;
import org.eclipse.statet.rj.server.dbg.FlagTracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.SrcfileData;
import org.eclipse.statet.rj.server.dbg.Srcref;
import org.eclipse.statet.rj.server.dbg.TracepointEvent;
import org.eclipse.statet.rj.server.dbg.TracepointInstallationRequest;
import org.eclipse.statet.rj.server.dbg.TracepointPosition;
import org.eclipse.statet.rj.server.dbg.TracepointState;
import org.eclipse.statet.rj.server.dbg.TracepointStatesUpdate;

@NonNullByDefault
public class RControllerBreakpointAdapter
implements AbstractRDbgController.IRControllerTracepointAdapter,
IBreakpointManagerListener,
IBreakpointsListener {
    private static final IRBreakpoint.ITargetData INSTALLED_DATA = new IRBreakpoint.ITargetData(){

        @Override
        public boolean isInstalled() {
            return true;
        }

        public <T> @Nullable T getAdapter(Class<T> adapter) {
            return null;
        }
    };
    private static final IRBreakpoint.ITargetData NOT_INSTALLED_DATA = new IRBreakpoint.ITargetData(){

        @Override
        public boolean isInstalled() {
            return false;
        }

        public <T> @Nullable T getAdapter(Class<T> adapter) {
            return null;
        }
    };
    private final IRDebugTarget debugTarget;
    private final AbstractRDbgController controller;
    private IBreakpointManager breakpointManager;
    private boolean initialized;
    private final List<IRLineBreakpoint> positionUpdatesBreakpoints = new ArrayList<IRLineBreakpoint>();
    private final List<UpdateData> positionUpdatesElements = new ArrayList<UpdateData>();
    private final AtomicInteger positionModCounter = new AtomicInteger();
    private final Object positionUpdatesLock = this.positionUpdatesBreakpoints;
    private final Object targetUpdateLock = new Object();
    private final Object flagUpdateLock = new Object();
    private boolean flagUpdateCheck;
    private @Nullable IRBreakpoint.ITargetData exceptionBreakpointData;
    private final List<IRBreakpoint> stateUpdatesBreakpoints;
    private final Object stateUpdatesLock = this.stateUpdatesBreakpoints = new ArrayList<IRBreakpoint>();
    private final Map<IResource, List<TracepointState>> stateUpdatesMap = new HashMap<IResource, List<TracepointState>>();
    private final List<IResource> currentRequests = new ArrayList<IResource>();
    private final SystemRunnable updateRunnable = new SystemRunnable(){
        private List<String> knownPackages = new ArrayList<String>();

        public String getTypeId() {
            return "r/dbg/breakpoint.update";
        }

        public String getLabel() {
            return "Update Breakpoints";
        }

        public boolean canRunIn(Tool tool) {
            return tool == RControllerBreakpointAdapter.this.controller.getTool();
        }

        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 288: 
                case 289: {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            List positions;
            block36: {
                IRBreakpoint breakpoint;
                boolean checkInstalled = RControllerBreakpointAdapter.this.controller.getHotTasksState() <= 1;
                SystemRunnable systemRunnable = RControllerBreakpointAdapter.this.updateRunnable;
                synchronized (systemRunnable) {
                    RControllerBreakpointAdapter.this.updateRunnableScheduled = false;
                }
                if (!RControllerBreakpointAdapter.this.initialized) {
                    m.setWorkRemaining(2);
                    ProgressMonitor mInit = m.newSubMonitor(1).setWorkRemaining(4);
                    Object object = RControllerBreakpointAdapter.this.flagUpdateLock;
                    synchronized (object) {
                        RControllerBreakpointAdapter.this.flagUpdateCheck = false;
                    }
                    IBreakpoint[] breakpoints = RControllerBreakpointAdapter.this.breakpointManager.getBreakpoints("org.eclipse.statet.r.debugModels.R");
                    mInit.addWorked(1);
                    try {
                        boolean exceptionAvailable = false;
                        Object object2 = RControllerBreakpointAdapter.this.stateUpdatesLock;
                        synchronized (object2) {
                            ProgressMonitor m0 = mInit.newSubMonitor(1);
                            int i = 0;
                            while (i < breakpoints.length) {
                                m0.setWorkRemaining(breakpoints.length - i);
                                if (breakpoints[i] instanceof IRBreakpoint) {
                                    breakpoint = (IRBreakpoint)breakpoints[i];
                                    RControllerBreakpointAdapter.this.scheduleStateUpdate((IRBreakpoint)breakpoints[i]);
                                    String breakpointType = breakpoint.getBreakpointType();
                                    if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint") {
                                        exceptionAvailable = true;
                                    }
                                    m0.addWorked(1);
                                }
                                ++i;
                            }
                        }
                        Object m0 = mInit.newSubMonitor(1);
                        FlagTracepointInstallationRequest request = RControllerBreakpointAdapter.this.createFlagRequest(exceptionAvailable ? Boolean.TRUE : null);
                        if (request != null) {
                            RControllerBreakpointAdapter.this.installFlagTracepoints(request, m0);
                        }
                        m0 = RControllerBreakpointAdapter.this.positionUpdatesLock;
                        synchronized (m0) {
                            int i = 0;
                            while (i < breakpoints.length) {
                                if (breakpoints[i] instanceof IRLineBreakpoint) {
                                    RControllerBreakpointAdapter.this.schedulePositionUpdate((IRLineBreakpoint)breakpoints[i]);
                                }
                                ++i;
                            }
                            mInit.addWorked(1);
                        }
                        m0 = mInit.newSubMonitor(1).setWorkRemaining(2);
                        List positions2 = RControllerBreakpointAdapter.this.getPendingElementPositions(m0.newSubMonitor(1));
                        RControllerBreakpointAdapter.this.installElementTracepoints(new ElementTracepointInstallationRequest(positions2, true), m0.setWorkRemaining(1));
                    }
                    finally {
                        RControllerBreakpointAdapter.this.initialized = true;
                        checkInstalled = false;
                        RControllerBreakpointAdapter.this.checkUpdates();
                    }
                }
                m.setWorkRemaining(6);
                ArrayList<String> newPackages = null;
                List environments = RControllerBreakpointAdapter.this.controller.getWorkspaceData().getRSearchEnvironments();
                if (environments != null) {
                    ArrayList<String> packages = new ArrayList<String>(environments.size() - 1);
                    for (RProcessREnvironment environment : environments) {
                        if (environment.getSpecialType() != 5) continue;
                        String pkgName = environment.getElementName().getSegmentName();
                        packages.add(pkgName);
                        if (this.knownPackages == null || this.knownPackages.contains(pkgName)) continue;
                        if (newPackages == null) {
                            newPackages = new ArrayList(4);
                        }
                        newPackages.add(pkgName);
                    }
                    if (this.knownPackages == null) {
                        newPackages = packages;
                    }
                    this.knownPackages = packages;
                }
                if (newPackages == null && !checkInstalled) break block36;
                IBreakpoint[] breakpoints = RControllerBreakpointAdapter.this.breakpointManager.getBreakpoints("org.eclipse.statet.r.debugModels.R");
                HashMap<String, RProject> rProjects = null;
                boolean exceptionAvailable = false;
                int i = 0;
                while (i < breakpoints.length) {
                    block37: {
                        String pkgName;
                        RProject rProject;
                        IRLineBreakpoint lineBreakpoint;
                        block41: {
                            IResource resource;
                            block40: {
                                IMarker marker;
                                block39: {
                                    IRBreakpoint.ITargetData targetData;
                                    String breakpointType;
                                    block38: {
                                        if (!(breakpoints[i] instanceof IRBreakpoint) || (marker = (breakpoint = (IRBreakpoint)breakpoints[i]).getMarker()) == null) break block37;
                                        breakpointType = breakpoint.getBreakpointType();
                                        if (breakpointType != "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint") break block38;
                                        exceptionAvailable = true;
                                        break block37;
                                    }
                                    if (breakpointType != "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" && breakpointType != "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") break block37;
                                    lineBreakpoint = (IRLineBreakpoint)breakpoint;
                                    if (!checkInstalled || (targetData = lineBreakpoint.getTargetData(RControllerBreakpointAdapter.this.debugTarget)) == null || !targetData.isInstalled()) break block39;
                                    RControllerBreakpointAdapter.this.schedulePositionUpdate(lineBreakpoint);
                                    break block37;
                                }
                                resource = marker.getResource();
                                if (!RControllerBreakpointAdapter.this.currentRequests.contains(resource)) break block40;
                                RControllerBreakpointAdapter.this.schedulePositionUpdate(lineBreakpoint);
                                break block37;
                            }
                            if (newPackages == null) break block37;
                            IProject project = resource.getProject();
                            if (rProjects == null) {
                                rProjects = new HashMap<String, RProject>();
                            }
                            if ((rProject = (RProject)rProjects.get(project.getName())) != null) break block41;
                            rProject = RProjects.getRProject((IProject)project);
                            if (rProject == null) break block37;
                            rProjects.put(project.getName(), rProject);
                        }
                        if (newPackages.contains(pkgName = rProject.getPkgName())) {
                            RControllerBreakpointAdapter.this.schedulePositionUpdate(lineBreakpoint);
                        }
                    }
                    ++i;
                }
                ProgressMonitor m0 = m.newSubMonitor(1);
                FlagTracepointInstallationRequest request = RControllerBreakpointAdapter.this.createFlagRequest((RControllerBreakpointAdapter.this.exceptionBreakpointData != null ? RControllerBreakpointAdapter.this.exceptionBreakpointData.isInstalled() : false) != exceptionAvailable ? Boolean.valueOf(exceptionAvailable) : null);
                if (request != null) {
                    RControllerBreakpointAdapter.this.installFlagTracepoints(request, m0);
                }
            }
            while (!(positions = RControllerBreakpointAdapter.this.getPendingElementPositions(m.newSubMonitor(2))).isEmpty()) {
                m.setWorkRemaining(2);
                RControllerBreakpointAdapter.this.installElementTracepoints(new ElementTracepointInstallationRequest(positions, false), m.newSubMonitor(1));
            }
        }
    };
    private boolean updateRunnableScheduled;

    public RControllerBreakpointAdapter(IRDebugTarget target, AbstractRDbgController controller) {
        this.debugTarget = target;
        this.controller = controller;
        this.breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.breakpointManager.addBreakpointListener((IBreakpointsListener)this);
        this.breakpointManagerEnablementChanged(this.breakpointManager.isEnabled());
    }

    public void init() {
        Queue queue = this.controller.getTool().getQueue();
        queue.addHot((ToolRunnable)this.updateRunnable);
        queue.addOnIdle(this.updateRunnable, 5500);
    }

    public boolean supportsBreakpoint(IRBreakpoint breakpoint) {
        String breakpointType;
        switch (breakpointType = breakpoint.getBreakpointType()) {
            case "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint": 
            case "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint": 
            case "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint": {
                return true;
            }
        }
        return false;
    }

    private @Nullable IRBreakpoint getRBreakpoint(TracepointEvent event) {
        if (event.getFilePath() == null) {
            return null;
        }
        try {
            IMarker marker;
            IWorkspaceRoot resource;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (event.getType() == 5) {
                resource = workspace.getRoot();
                IMarker[] markers = resource.findMarkers("org.eclipse.statet.r.resourceMarkers.RExceptionBreakpoint", false, 0);
                marker = markers.length > 0 ? markers[0] : null;
            } else {
                resource = workspace.getRoot().getFile((IPath)new Path(event.getFilePath()));
                marker = resource.getMarker(event.getId());
            }
            IBreakpoint b = this.breakpointManager.getBreakpoint(marker);
            return b instanceof IRBreakpoint ? (IRBreakpoint)b : null;
        }
        catch (CoreException e) {
            return null;
        }
    }

    public void handle(TracepointEvent event) {
        switch (event.getKind()) {
            case 16: 
            case 32: {
                if (event.getType() == 5) {
                    this.updateFlagInstallData(event);
                    break;
                }
                this.updateElementInstallData(event);
            }
        }
    }

    public boolean matchScriptBreakpoint(IRModelSrcref srcref, ProgressMonitor m) {
        try {
            if (srcref instanceof IAdaptable) {
                IMarker marker = (IMarker)((IAdaptable)srcref).getAdapter(IMarker.class);
                RSourceUnit su = srcref.getFile();
                if (marker != null && su instanceof RWorkspaceSourceUnit && marker.getResource() == su.getResource()) {
                    return this.doMatchScriptBreakpoint(srcref, (RWorkspaceSourceUnit)su, marker, m);
                }
            }
            return false;
        }
        catch (Exception e) {
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when looking for script breakpoints.", (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doMatchScriptBreakpoint(IRModelSrcref srcref, RWorkspaceSourceUnit rSourceUnit, IMarker marker, ProgressMonitor m) throws CoreException {
        List<IRLineBreakpoint> breakpoints = RDebugModel.getLineBreakpoints((IFile)rSourceUnit.getResource());
        if (breakpoints.isEmpty()) {
            return false;
        }
        IMarkerPositionResolver resolver = rSourceUnit.getMarkerPositionResolver();
        Object object = resolver != null && resolver.getDocument() instanceof ISynchronizable ? ((ISynchronizable)resolver.getDocument()).getLockObject() : new Object();
        synchronized (object) {
            int lineNumber;
            block8: {
                lineNumber = this.getLineNumber(marker, resolver);
                if (lineNumber >= 0) break block8;
                return false;
            }
            for (IRLineBreakpoint breakpoint : breakpoints) {
                try {
                    if (!this.isScriptBreakpoint(breakpoint) || (resolver != null ? resolver.getLine(breakpoint.getMarker()) : breakpoint.getLineNumber()) != lineNumber) continue;
                    return breakpoint.isEnabled();
                }
                catch (CoreException e) {
                    RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when checking breakpoints.", (Throwable)e));
                }
            }
            return false;
        }
    }

    private @Nullable FlagTracepointInstallationRequest createFlagRequest(@Nullable Boolean exception) {
        int count = 0;
        if (exception != null) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        byte[] types = new byte[count];
        int[] flags = new int[count];
        int i = 0;
        if (exception != null) {
            types[i] = 5;
            flags[i] = exception != false ? 1 : 0;
            ++i;
        }
        return new FlagTracepointInstallationRequest(types, flags);
    }

    private void installFlagTracepoints(FlagTracepointInstallationRequest request, ProgressMonitor m) {
        try {
            try {
                this.controller.exec((TracepointInstallationRequest)request, m);
            }
            catch (Exception e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when updating breakpoints in R.", (Throwable)e));
                this.checkUpdates();
            }
        }
        finally {
            this.checkUpdates();
        }
    }

    public @Nullable ElementTracepointInstallationRequest getElementTracepoints(SrcfileData srcfile, IRModelSrcref srcref, ProgressMonitor m) {
        try {
            RSourceUnit su = srcref.getFile();
            if (su instanceof RWorkspaceSourceUnit) {
                return this.doGetElementTracepoints(srcfile, srcref, (RWorkspaceSourceUnit)su, m);
            }
            return null;
        }
        catch (Exception e) {
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when looking for script list.", (Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private @Nullable ElementTracepointInstallationRequest doGetElementTracepoints(SrcfileData srcfile, IRModelSrcref srcref, RWorkspaceSourceUnit rSourceUnit, ProgressMonitor m) throws CoreException, BadLocationException {
        block31: {
            if (rSourceUnit.getResource().getType() != 1 || !rSourceUnit.getResource().exists()) {
                return null;
            }
            elements = srcref.getElements();
            if (elements.isEmpty()) {
                return null;
            }
            modCounter = this.positionModCounter.get();
            breakpoints = RDebugModel.getLineBreakpoints((IFile)rSourceUnit.getResource());
            if (breakpoints.isEmpty()) {
                return null;
            }
            eMonitor = EStatusUtils.convert((ProgressMonitor)m);
            rSourceUnit.connect(eMonitor);
            document = rSourceUnit.getDocument(eMonitor);
            var10_10 = document instanceof ISynchronizable != false ? ((ISynchronizable)document).getLockObject() : new Object();
            synchronized (var10_10) {
                modelInfo = (RSourceUnitModelInfo)rSourceUnit.getModelInfo("R", 2, eMonitor);
                if (((RLangSourceElement)elements.get(0)).getSourceParent() != modelInfo.getSourceElement()) {
                    orgElements = elements;
                    elements = modelInfo.getSourceElement().getSourceChildren((LtkModelElementFilter)new LtkModelElementFilter<RLangSourceElement>(){

                        public boolean include(RLangSourceElement element) {
                            return orgElements.contains(element);
                        }
                    });
                }
                if (!elements.isEmpty()) ** break block29
            }
            rSourceUnit.disconnect(eMonitor);
            return null;
            {
                resolver = rSourceUnit.getMarkerPositionResolver();
                lines = new int[elements.size() * 2];
                i = 0;
                j = 0;
                while (i < elements.size()) {
                    region = ((RLangSourceElement)elements.get(i)).getSourceRange();
                    lines[j] = document.getLineOfOffset(region.getStartOffset()) + 1;
                    lines[j + 1] = document.getLineOfOffset(region.getEndOffset()) + 1;
                    ++i;
                    j += 2;
                }
                map = null;
                cleanup = null;
                block15: for (Object breakpoint : breakpoints) {
                    try {
                        if (!this.isElementBreakpoint((IRLineBreakpoint)breakpoint)) continue;
                        marker = breakpoint.getMarker();
                        breakpointLineNumber = resolver != null ? resolver.getLine(breakpoint.getMarker()) : breakpoint.getLineNumber();
                        j = 0;
                        while (j < lines.length) {
                            if (lines[j] <= breakpointLineNumber && lines[j + 1] >= breakpointLineNumber) {
                                v0 = validator = resolver != null ? new RLineBreakpointValidator(rSourceUnit, breakpoint.getBreakpointType(), resolver.getPosition(marker).getOffset(), eMonitor) : new RLineBreakpointValidator(rSourceUnit, (IRLineBreakpoint)breakpoint, eMonitor);
                                if (validator.getType() != breakpoint.getBreakpointType() || (elementId = validator.computeElementId()) == null || !elements.contains(validator.getBaseElement())) continue block15;
                                if (map == null) {
                                    map = new HashMap<String, Element>(elements.size());
                                }
                                if ((breakpointData = (BreakpointTargetData)breakpoint.getTargetData(this.debugTarget)) != null && BreakpointTargetData.access$0(breakpointData) != null && !elementId.equals(ElementInstallData.access$0(BreakpointTargetData.access$0(breakpointData)))) {
                                    if (cleanup == null) {
                                        cleanup = new ArrayList<String>();
                                    }
                                    if (!cleanup.contains(ElementInstallData.access$0(BreakpointTargetData.access$0(breakpointData)))) {
                                        cleanup.add(ElementInstallData.access$0(BreakpointTargetData.access$0(breakpointData)));
                                    }
                                }
                                this.addBreakpoint(map, srcfile, rSourceUnit.getResource(), elementId, (IRLineBreakpoint)breakpoint, validator, modCounter);
                                continue block15;
                            }
                            j += 2;
                        }
                    }
                    catch (CoreException e) {
                        RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when checking breakpoint.", (Throwable)e));
                    }
                }
                if (cleanup != null) {
                    cleanup.removeAll(map.keySet());
                    if (!cleanup.isEmpty()) {
                        breakpoint = this.positionUpdatesLock;
                        synchronized (breakpoint) {
                            i = 0;
                            while (i < cleanup.size()) {
                                this.positionUpdatesElements.add(new UpdateData(rSourceUnit.getResource(), (String)cleanup.get(i)));
                                ++i;
                            }
                        }
                    }
                }
                if (map == null) ** break block30
                list = new ArrayList<Element>(map.size());
                this.addElements(list, (Map<String, Element>)map, false);
                if (list.isEmpty()) ** break block30
                var25_28 = new ElementTracepointInstallationRequest(list, false);
            }
            rSourceUnit.disconnect(eMonitor);
            return var25_28;
            {
                break block31;
                {
                    catch (Throwable v2) {
                        throw v2;
                    }
                }
            }
            {
                finally {
                    rSourceUnit.disconnect(eMonitor);
                }
            }
        }
        return null;
    }

    public @Nullable ElementTracepointInstallationRequest prepareFileElementTracepoints(SrcfileData srcfile, RSourceUnit su, ProgressMonitor m) {
        try {
            ElementTracepointInstallationRequest request;
            if (su instanceof RWorkspaceSourceUnit && (request = this.doPrepareFileElementTracepoints(srcfile, (RWorkspaceSourceUnit)su, m)) != null) {
                this.installElementTracepoints(request, m);
                for (ElementTracepoints positions : request.getRequests()) {
                    if (!(positions instanceof Element)) continue;
                    this.currentRequests.add(((Element)positions).getResource());
                }
                return request;
            }
            return null;
        }
        catch (Exception e) {
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when looking for line breakpoints.", (Throwable)e));
            return null;
        }
    }

    public void finishFileElementTracepoints(SrcfileData srcfile, RSourceUnit su, ElementTracepointInstallationRequest request, ProgressMonitor m) {
        for (ElementTracepoints positions : request.getRequests()) {
            if (!(positions instanceof Element)) continue;
            this.currentRequests.remove(((Element)positions).getResource());
        }
        ElementTracepointInstallationRequest installRequest = request;
        if (srcfile != null) {
            try {
                installRequest = this.doPrepareFileElementTracepoints(srcfile, (RWorkspaceSourceUnit)su, m);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (installRequest != null) {
            this.installElementTracepoints(request, m);
        }
    }

    private @Nullable ElementTracepointInstallationRequest doPrepareFileElementTracepoints(SrcfileData srcfile, RWorkspaceSourceUnit rSourceUnit, ProgressMonitor m) throws CoreException {
        if (rSourceUnit.getResource().getType() != 1 || !rSourceUnit.getResource().exists()) {
            return null;
        }
        int modeCounter = this.positionModCounter.get();
        List<IRLineBreakpoint> breakpoints = RDebugModel.getLineBreakpoints((IFile)rSourceUnit.getResource());
        if (breakpoints.isEmpty()) {
            return null;
        }
        IProgressMonitor eMonitor = EStatusUtils.convert((ProgressMonitor)m);
        HashMap<String, Element> map = null;
        for (IRLineBreakpoint breakpoint : breakpoints) {
            try {
                String elementId;
                String breakpointType = breakpoint.getBreakpointType();
                if (breakpointType != "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" && breakpointType != "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") continue;
                rSourceUnit.getDocument(eMonitor).get();
                RLineBreakpointValidator validator = new RLineBreakpointValidator(rSourceUnit, breakpoint, eMonitor);
                if (validator.getType() != breakpoint.getBreakpointType() || (elementId = validator.computeElementId()) == null) continue;
                if (map == null) {
                    map = new HashMap<String, Element>(breakpoints.size());
                }
                this.addBreakpoint(map, srcfile, rSourceUnit.getResource(), elementId, breakpoint, validator, modeCounter);
            }
            catch (CoreException e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when checking breakpoint.", (Throwable)e));
            }
        }
        if (map != null) {
            ArrayList<Element> list = new ArrayList<Element>(map.size());
            this.addElements(list, (Map<String, Element>)map, false);
            if (!list.isEmpty()) {
                return new ElementTracepointInstallationRequest(list, false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installElementTracepoints(ElementTracepointInstallationRequest request, ProgressMonitor m) {
        try {
            try {
                Map<IResource, List<TracepointState>> map = this.stateUpdatesMap;
                synchronized (map) {
                    List<TracepointState> states = this.getPendingTracepointStates();
                    this.controller.exec(new TracepointStatesUpdate(states, request.getReset()), m);
                }
                this.controller.exec((TracepointInstallationRequest)request, m);
            }
            catch (Exception e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when updating breakpoints in R.", (Throwable)e));
                this.checkUpdates();
            }
        }
        finally {
            this.checkUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<Element> getPendingElementPositions(ProgressMonitor m) {
        IResource resource;
        UpdateData[] elementsToUpdate;
        IRBreakpoint[] breakpointsToUpdate;
        Object object = this.positionUpdatesLock;
        synchronized (object) {
            if (this.positionUpdatesBreakpoints.isEmpty() && this.positionUpdatesElements.isEmpty()) {
                return ImCollections.emptyList();
            }
            breakpointsToUpdate = this.positionUpdatesBreakpoints.toArray(new IRBreakpoint[this.positionUpdatesBreakpoints.size()]);
            this.positionUpdatesBreakpoints.clear();
            elementsToUpdate = this.positionUpdatesElements.toArray(new UpdateData[this.positionUpdatesElements.size()]);
            this.positionUpdatesElements.clear();
        }
        HashMap<IResource, HashMap<K, @Nullable V>> resourceMap = new HashMap();
        int i = 0;
        while (i < breakpointsToUpdate.length) {
            IRBreakpoint rBreakpoint = breakpointsToUpdate[i];
            String breakpointType = rBreakpoint.getBreakpointType();
            if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" || breakpointType == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
                try {
                    BreakpointTargetData breakpointData = (BreakpointTargetData)rBreakpoint.getTargetData(this.debugTarget);
                    if (breakpointData != null && breakpointData.latest != null) {
                        HashMap<String, @Nullable Object> map = (HashMap<String, Object>)resourceMap.get(breakpointData.latest.resource);
                        if (map == null) {
                            map = new HashMap<String, Object>();
                            resourceMap.put(breakpointData.latest.resource, map);
                        }
                        map.put(breakpointData.latest.elementId, null);
                    }
                    if (rBreakpoint.isRegistered()) {
                        resource = rBreakpoint.getMarker().getResource();
                        if (!resourceMap.containsKey(resource)) {
                            resourceMap.put(resource, new HashMap());
                        }
                    } else if (breakpointData != null) {
                        rBreakpoint.unregisterTarget(this.debugTarget);
                    }
                }
                catch (CoreException e) {
                    this.logPrepareError(e, rBreakpoint);
                }
            }
            ++i;
        }
        i = 0;
        while (i < elementsToUpdate.length) {
            UpdateData updateData = elementsToUpdate[i];
            HashMap<String, @Nullable Object> map = (HashMap<String, Object>)resourceMap.get(updateData.resource);
            if (map == null) {
                map = new HashMap<String, Object>();
                resourceMap.put(updateData.resource, map);
            }
            map.put(updateData.elementId, null);
            ++i;
        }
        IProgressMonitor eMonitor = EStatusUtils.convert((ProgressMonitor)m);
        int n = 0;
        for (Map.Entry resourceEntry : resourceMap.entrySet()) {
            resource = (IResource)resourceEntry.getKey();
            @Nullable Map map = (Map)resourceEntry.getValue();
            try {
                SourceUnit su;
                SrcfileData srcfile = RDbg.createRJSrcfileData((IResource)resource);
                if (resource.exists() && resource.getType() == 1 && (su = LtkModels.getSourceUnitManager().getSourceUnit(Ltk.PERSISTENCE_CONTEXT, (Object)resource, null, true, eMonitor)) != null) {
                    try {
                        if (su instanceof RWorkspaceSourceUnit) {
                            this.doGetPendingElementPositions(srcfile, (RWorkspaceSourceUnit)su, breakpointsToUpdate, map, eMonitor);
                            continue;
                        }
                    }
                    finally {
                        su.disconnect(eMonitor);
                    }
                }
                for (String elementId : map.keySet()) {
                    this.addClear(map, srcfile, resource, elementId);
                }
            }
            catch (CoreException e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", -1, NLS.bind((String)"An error occurred when preparing update of R line breakpoints in ''{0}''.", (Object)resource.getFullPath().toString()), (Throwable)e));
            }
            n += map.size();
        }
        ArrayList<Element> list = new ArrayList<Element>(n);
        for (Map.Entry resourceEntry : resourceMap.entrySet()) {
            this.addElements(list, (Map)resourceEntry.getValue(), true);
        }
        return list;
    }

    private void doGetPendingElementPositions(SrcfileData srcfile, RWorkspaceSourceUnit rSourceUnit, IRBreakpoint[] breakpointsToUpdate, Map<String, @Nullable Element> map, IProgressMonitor eMonitor) throws CoreException {
        String elementId;
        RLineBreakpointValidator validator;
        int modCounter = this.positionModCounter.get();
        List<IRLineBreakpoint> breakpoints = RDebugModel.getLineBreakpoints((IFile)rSourceUnit.getResource());
        for (IRLineBreakpoint iRLineBreakpoint : breakpoints) {
            if (!this.contains(breakpointsToUpdate, (Object)iRLineBreakpoint)) continue;
            try {
                if (!iRLineBreakpoint.isEnabled() || (validator = new RLineBreakpointValidator(rSourceUnit, iRLineBreakpoint.getBreakpointType(), iRLineBreakpoint.getCharStart(), eMonitor)).getType() != iRLineBreakpoint.getBreakpointType() || (elementId = validator.computeElementId()) == null) continue;
                this.addBreakpoint(map, srcfile, rSourceUnit.getResource(), elementId, iRLineBreakpoint, validator, modCounter);
            }
            catch (CoreException e) {
                this.logPrepareError(e, iRLineBreakpoint);
            }
        }
        for (IRLineBreakpoint iRLineBreakpoint : breakpoints) {
            if (this.contains(breakpointsToUpdate, (Object)iRLineBreakpoint)) continue;
            try {
                if (!iRLineBreakpoint.isEnabled() || (validator = new RLineBreakpointValidator(rSourceUnit, iRLineBreakpoint.getBreakpointType(), iRLineBreakpoint.getCharStart(), eMonitor)).getType() != iRLineBreakpoint.getBreakpointType() || (elementId = validator.computeElementId()) == null || !map.containsKey(elementId)) continue;
                this.addBreakpoint(map, srcfile, rSourceUnit.getResource(), elementId, iRLineBreakpoint, validator, modCounter);
            }
            catch (CoreException e) {
                this.logPrepareError(e, iRLineBreakpoint);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() != null) continue;
            this.addClear(map, srcfile, rSourceUnit.getResource(), (String)entry.getKey());
        }
    }

    private void logPrepareError(CoreException e, IRBreakpoint breakpoint) {
        if (breakpoint instanceof IRLineBreakpoint) {
            IResource resource;
            String fileName = null;
            IMarker marker = breakpoint.getMarker();
            if (marker != null && (resource = marker.getResource()) != null) {
                fileName = resource.getFullPath().toString();
            }
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", -1, NLS.bind((String)"An error occurred when preparing update of an R line breakpoint in ''{0}''.", (Object)(fileName != null ? fileName : "<missing>")), (Throwable)e));
        } else {
            String exceptionId = null;
            try {
                exceptionId = ((IRExceptionBreakpoint)breakpoint).getExceptionId();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", -1, NLS.bind((String)"An error occurred when preparing update of an R error breakpoint ''{0}''.", (Object)(exceptionId != null ? exceptionId : "<missing>")), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlagInstallData(TracepointEvent event) {
        IRBreakpoint.ITargetData newData;
        switch (event.getKind()) {
            case 16: {
                newData = INSTALLED_DATA;
                break;
            }
            case 32: {
                newData = NOT_INSTALLED_DATA;
                break;
            }
            default: {
                return;
            }
        }
        Object object = this.flagUpdateLock;
        synchronized (object) {
            this.exceptionBreakpointData = newData;
        }
        IRBreakpoint breakpoint = this.getRBreakpoint(event);
        if (breakpoint == null) {
            return;
        }
        breakpoint.registerTarget(this.debugTarget, newData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateElementInstallData(TracepointEvent event) {
        ElementInstallData installData;
        IRBreakpoint breakpoint = this.getRBreakpoint(event);
        if (breakpoint == null) {
            return;
        }
        IMarker marker = breakpoint.getMarker();
        if (marker == null) {
            return;
        }
        switch (event.getKind()) {
            case 16: {
                installData = new ElementInstallData(marker.getResource(), event.getElementId(), event.getLabel());
                break;
            }
            case 32: {
                installData = null;
                break;
            }
            default: {
                return;
            }
        }
        Object object = this.targetUpdateLock;
        synchronized (object) {
            BreakpointTargetData oldData = (BreakpointTargetData)breakpoint.getTargetData(this.debugTarget);
            breakpoint.registerTarget(this.debugTarget, new BreakpointTargetData(oldData != null ? oldData.latest : null, installData));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBreakpoint(Map<String, Element> map, SrcfileData srcfile, IResource resource, String elementId, IRLineBreakpoint breakpoint, RLineBreakpointValidator validator, int modCounter) throws CoreException {
        int type;
        IMarker marker;
        Object object = this.positionUpdatesLock;
        synchronized (object) {
            if (this.positionModCounter.get() == modCounter) {
                this.positionUpdatesBreakpoints.remove(breakpoint);
            }
        }
        Element elementPositions = map.get(elementId);
        if (elementPositions == null) {
            IRSrcref elementSrcref = validator.computeElementSrcref();
            elementPositions = new Element(srcfile, resource, elementId, elementSrcref != null ? RDbg.createRJSrcref((IRSrcref)elementSrcref) : null);
            map.put(elementId, elementPositions);
        }
        if ((marker = breakpoint.getMarker()) == null) {
            return;
        }
        int[] rExpressionIndex = validator.computeRExpressionIndex();
        if (rExpressionIndex == null) {
            rExpressionIndex = new int[]{};
        }
        if (breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint") {
            type = breakpoint.getElementType() == 9 ? 3 : 2;
        } else if (breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
            type = 1;
        } else {
            return;
        }
        Position position = new Position(type, marker.getId(), rExpressionIndex, breakpoint);
        if (!elementPositions.getPositions().contains((Object)position)) {
            String label;
            RSrcref[] rExpressionSrcrefs;
            int[] elementSrcref = elementPositions.getElementSrcref();
            if (elementSrcref != null && (rExpressionSrcrefs = validator.computeRExpressionSrcrefs()) != null) {
                int[] @Nullable [] srcrefs = position.getSrcrefs();
                int i = 0;
                while (i < rExpressionSrcrefs.length) {
                    if (rExpressionSrcrefs[i] != null) {
                        srcrefs[i] = Srcref.substract((int[])RDbg.createRJSrcref((IRSrcref)rExpressionSrcrefs[i]), (int[])elementSrcref);
                    }
                    ++i;
                }
            }
            if ((label = validator.computeSubLabel()) == null) {
                label = validator.computeElementLabel();
            }
            position.setLabel(label);
            elementPositions.getPositions().add(position);
        }
        ElementInstallData latestData = new ElementInstallData(marker.getResource(), elementId, position);
        Object object2 = this.targetUpdateLock;
        synchronized (object2) {
            BreakpointTargetData oldData = (BreakpointTargetData)breakpoint.getTargetData(this.debugTarget);
            if (oldData != null && Objects.equals(latestData, oldData.latest)) {
                return;
            }
            breakpoint.registerTarget(this.debugTarget, new BreakpointTargetData(latestData, oldData != null ? oldData.installed : null));
        }
        object2 = this.stateUpdatesLock;
        synchronized (object2) {
            this.scheduleStateUpdate(breakpoint);
        }
    }

    private void addClear(Map<String, Element> map, SrcfileData srcfile, IResource resource, String elementId) throws CoreException {
        Element elementPositions = map.get(elementId);
        if (elementPositions != null) {
            return;
        }
        elementPositions = new Element(srcfile, resource, elementId, null);
        map.put(elementId, elementPositions);
    }

    private void addElements(List<Element> list, Map<String, @Nullable Element> map, boolean delete) {
        Collection<@Nullable Element> values = map.values();
        for (Element elementPositions : values) {
            if (elementPositions == null) continue;
            if (elementPositions.getPositions().size() > 0) {
                Collections.sort(elementPositions.getPositions());
            } else if (!delete) continue;
            list.add(elementPositions);
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        try {
            this.controller.exec(new DbgEnablement(enabled));
        }
        catch (StatusException e) {
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when updating breakpoint enablement in the R engine.", (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        boolean check = false;
        try {
            int i = 0;
            while (i < breakpoints.length) {
                block17: {
                    if (breakpoints[i] instanceof IRBreakpoint) {
                        IRBreakpoint rBreakpoint = (IRBreakpoint)breakpoints[i];
                        try {
                            check = true;
                            String breakpointType = rBreakpoint.getBreakpointType();
                            if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint") {
                                IRBreakpoint.ITargetData data;
                                Object object = this.flagUpdateLock;
                                synchronized (object) {
                                    data = this.exceptionBreakpointData;
                                    if (data != INSTALLED_DATA) {
                                        this.scheduleExceptionUpdate();
                                    }
                                }
                                if (data == INSTALLED_DATA) {
                                    rBreakpoint.registerTarget(this.debugTarget, data);
                                }
                                break block17;
                            }
                            if (breakpointType != "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" && breakpointType != "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") break block17;
                            Object object = this.positionUpdatesLock;
                            synchronized (object) {
                                this.positionModCounter.incrementAndGet();
                                this.schedulePositionUpdate((IRLineBreakpoint)rBreakpoint);
                            }
                        }
                        catch (Exception e) {
                            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when handling creation of an R breakpoint.", (Throwable)e));
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            if (check) {
                this.checkUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsRemoved(IBreakpoint[] breakpoints, @Nullable IMarkerDelta[] deltas) {
        boolean check = false;
        try {
            int i = 0;
            while (i < breakpoints.length) {
                block23: {
                    if (breakpoints[i] instanceof IRBreakpoint) {
                        IRBreakpoint rBreakpoint = (IRBreakpoint)breakpoints[i];
                        try {
                            check = true;
                            String breakpointType = rBreakpoint.getBreakpointType();
                            if (breakpointType == "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint") {
                                Object object = this.flagUpdateLock;
                                synchronized (object) {
                                    IRBreakpoint.ITargetData data = this.exceptionBreakpointData;
                                    if (data == INSTALLED_DATA) {
                                        this.scheduleExceptionUpdate();
                                    }
                                    break block23;
                                }
                            }
                            if (breakpointType != "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" && breakpointType != "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") break block23;
                            IMarkerDelta delta = deltas[i];
                            IMarker marker = rBreakpoint.getMarker();
                            IResource resource = null;
                            if (delta != null) {
                                resource = delta.getResource();
                                this.deactivateBreakpoint(resource, delta.getId());
                            } else if (marker != null) {
                                resource = marker.getResource();
                                this.deactivateBreakpoint(resource, marker.getId());
                            }
                            String elementId = null;
                            if (delta != null) {
                                elementId = delta.getAttribute("org.eclipse.statet.r.resourceMarkers.ElementIdAttribute", null);
                            } else if (marker != null) {
                                elementId = marker.getAttribute("org.eclipse.statet.r.resourceMarkers.ElementIdAttribute", null);
                            }
                            Object object = this.positionUpdatesLock;
                            synchronized (object) {
                                this.positionModCounter.incrementAndGet();
                                this.schedulePositionUpdate((IRLineBreakpoint)rBreakpoint);
                                if (elementId != null) {
                                    this.positionUpdatesElements.add(new UpdateData(resource, elementId));
                                }
                            }
                        }
                        catch (Exception e) {
                            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when handling deletion of an R breakpoint.", (Throwable)e));
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            if (check) {
                this.checkUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointsChanged(IBreakpoint[] breakpoints, @Nullable IMarkerDelta[] deltas) {
        boolean check = false;
        try {
            int i = 0;
            while (i < breakpoints.length) {
                block15: {
                    if (breakpoints[i] instanceof IRBreakpoint) {
                        IRBreakpoint rBreakpoint = (IRBreakpoint)breakpoints[i];
                        try {
                            IMarkerDelta delta = deltas[i];
                            if (delta == null) break block15;
                            check = true;
                            String breakpointType = rBreakpoint.getBreakpointType();
                            IMarker marker = rBreakpoint.getMarker();
                            if (!marker.getResource().equals((Object)delta.getResource()) || marker.getId() != delta.getId()) {
                                this.deactivateBreakpoint(delta.getResource(), delta.getId());
                            }
                            Object object = this.stateUpdatesLock;
                            synchronized (object) {
                                this.scheduleStateUpdate(rBreakpoint);
                            }
                            if (breakpointType != "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" && breakpointType != "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") break block15;
                            object = this.positionUpdatesLock;
                            synchronized (object) {
                                this.positionModCounter.incrementAndGet();
                                this.schedulePositionUpdate((IRLineBreakpoint)rBreakpoint);
                            }
                        }
                        catch (Exception e) {
                            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when handling changes of an R breakpoint.", (Throwable)e));
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            if (check) {
                this.checkUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivateBreakpoint(@Nullable IResource resource, long id) {
        if (resource == null) {
            return;
        }
        Map<IResource, List<TracepointState>> map = this.stateUpdatesMap;
        synchronized (map) {
            String filePath;
            List<TracepointState> list = this.stateUpdatesMap.get(resource);
            if (list == null) {
                list = new ArrayList<TracepointState>(8);
                this.stateUpdatesMap.put(resource, list);
            }
            if (list.size() > 0) {
                int i = 0;
                while (i < list.size()) {
                    TracepointState state = list.get(i);
                    if (state.getId() == id) {
                        if (state.getType() == 0x1000000) {
                            return;
                        }
                        list.remove(i);
                    }
                    ++i;
                }
                filePath = list.get(0).getFilePath();
            } else {
                filePath = resource.getFullPath().toPortableString();
            }
            list.add(new TracepointState(0x1000000, filePath, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TracepointState> getPendingTracepointStates() {
        int i;
        ImList breakpoints;
        Object object = this.stateUpdatesLock;
        synchronized (object) {
            if (this.stateUpdatesBreakpoints.isEmpty() && this.stateUpdatesMap.isEmpty()) {
                return ImCollections.emptyList();
            }
            breakpoints = ImCollections.toList(this.stateUpdatesBreakpoints);
            this.stateUpdatesBreakpoints.clear();
        }
        block5: for (IRBreakpoint breakpoint : breakpoints) {
            try {
                TracepointState newState;
                IMarker marker = breakpoint.getMarker();
                if (marker == null || !marker.exists() || (newState = breakpoint instanceof IRExceptionBreakpoint ? this.createState((IRExceptionBreakpoint)breakpoint, marker) : (breakpoint instanceof IRLineBreakpoint ? this.createState((IRLineBreakpoint)breakpoint, marker) : null)) == null) continue;
                List<TracepointState> list = this.stateUpdatesMap.get(marker.getResource());
                if (list == null) {
                    list = new ArrayList<TracepointState>(8);
                    this.stateUpdatesMap.put(marker.getResource(), list);
                }
                i = 0;
                while (i < list.size()) {
                    TracepointState state = list.get(i);
                    if (state.getId() == newState.getId() && state.getType() == 0x1000000) continue block5;
                    ++i;
                }
                list.add(newState);
            }
            catch (CoreException e) {
                this.logPrepareError(e, breakpoint);
            }
        }
        ArrayList<TracepointState> list = new ArrayList<TracepointState>();
        Iterator<List<TracepointState>> iter = this.stateUpdatesMap.values().iterator();
        while (iter.hasNext()) {
            List<TracepointState> statesList = iter.next();
            Object[] states = statesList.toArray(new TracepointState[statesList.size()]);
            Arrays.sort(states);
            boolean delete = true;
            i = 0;
            while (i < states.length) {
                list.add((TracepointState)states[i]);
                if (states[i].getType() != 0x1000000) {
                    delete = false;
                }
                ++i;
            }
            if (delete) {
                iter.remove();
                continue;
            }
            statesList.clear();
        }
        return list;
    }

    private void schedulePositionUpdate(IRLineBreakpoint lineBreakpoint) {
        if (!this.contains(this.positionUpdatesBreakpoints, (Object)lineBreakpoint)) {
            this.positionUpdatesBreakpoints.add(lineBreakpoint);
        }
    }

    private void scheduleExceptionUpdate() {
        this.flagUpdateCheck = true;
    }

    private void scheduleStateUpdate(IRBreakpoint lineBreakpoint) {
        if (!this.contains(this.stateUpdatesBreakpoints, (Object)lineBreakpoint)) {
            this.stateUpdatesBreakpoints.add(lineBreakpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUpdates() {
        if (!this.initialized) {
            return;
        }
        Map<IResource, List<TracepointState>> map = this.stateUpdatesMap;
        synchronized (map) {
            try {
                List<TracepointState> states = this.getPendingTracepointStates();
                if (!states.isEmpty() && this.controller.getStatus() != ToolStatus.TERMINATED) {
                    this.controller.exec(new TracepointStatesUpdate(states, false));
                }
            }
            catch (StatusException e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when updating breakpoint states in the R engine.", (Throwable)e));
            }
        }
        boolean scheduleInstall = false;
        Object object = this.positionUpdatesLock;
        synchronized (object) {
            scheduleInstall |= !this.positionUpdatesBreakpoints.isEmpty();
        }
        object = this.flagUpdateLock;
        synchronized (object) {
        }
        if (scheduleInstall |= this.flagUpdateCheck) {
            object = this.updateRunnable;
            synchronized (object) {
                if (!this.updateRunnableScheduled) {
                    this.updateRunnableScheduled = true;
                    this.controller.getTool().getQueue().addHot((ToolRunnable)this.updateRunnable);
                }
            }
        }
    }

    private boolean contains(List<?> list, Object object) {
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) == object) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == object) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getLineNumber(IMarker marker, @Nullable IMarkerPositionResolver resolver) {
        return resolver != null ? resolver.getLine(marker) : marker.getAttribute("lineNumber", -1);
    }

    private boolean isScriptBreakpoint(IRLineBreakpoint breakpoint) throws CoreException {
        return breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" && breakpoint.getElementType() == 9;
    }

    private boolean isElementBreakpoint(IRLineBreakpoint breakpoint) throws CoreException {
        int elementType;
        return !(breakpoint.getBreakpointType() != "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint" && breakpoint.getBreakpointType() != "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint" || (elementType = breakpoint.getElementType()) != 1 && elementType != 2);
    }

    private @Nullable TracepointState createState(IRLineBreakpoint breakpoint, IMarker marker) throws CoreException {
        int type;
        int flags;
        int n = flags = breakpoint.isEnabled() ? 1 : 0;
        if (breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RLineBreakpoint") {
            type = breakpoint.getElementType() == 9 ? 3 : 2;
        } else if (breakpoint.getBreakpointType() == "org.eclipse.statet.r.debugBreakpoints.RMethodBreakpoint") {
            type = 1;
            IRMethodBreakpoint methodBreakpoint = (IRMethodBreakpoint)breakpoint;
            if (methodBreakpoint.isEntry()) {
                flags |= 0x10000;
            }
            if (methodBreakpoint.isExit()) {
                flags |= 0x20000;
            }
        } else {
            return null;
        }
        String expr = breakpoint.isConditionEnabled() ? breakpoint.getConditionExpr() : null;
        BreakpointTargetData breakpointData = (BreakpointTargetData)breakpoint.getTargetData(this.debugTarget);
        RLineBreakpointValidator.ModelPosition modelPosition = RLineBreakpointValidator.getModelPosition(breakpoint);
        String elementId = null;
        String elementLabel = null;
        int[] index = null;
        if (breakpointData != null) {
            if (breakpointData.installed != null) {
                elementId = breakpointData.installed.elementId;
                elementLabel = breakpointData.installed.elementLabel;
            }
            if (breakpointData.latest != null && elementId == null) {
                elementId = breakpointData.latest.elementId;
                elementLabel = breakpointData.latest.elementLabel;
            }
        }
        if (modelPosition != null) {
            if (elementId != null) {
                if (elementId.equals(modelPosition.getElementId())) {
                    index = modelPosition.getRExpressionIndex();
                }
            } else {
                elementId = modelPosition.getElementId();
                index = modelPosition.getRExpressionIndex();
            }
        }
        if (elementLabel == null && (elementLabel = breakpoint.getSubLabel()) == null) {
            elementLabel = breakpoint.getElementLabel();
        }
        if (elementId == null) {
            return null;
        }
        if (index == null) {
            index = new int[]{-1};
        }
        return new TracepointState(type, marker.getResource().getFullPath().toPortableString(), marker.getId(), elementId, index, elementLabel, flags, expr);
    }

    private @Nullable TracepointState createState(IRExceptionBreakpoint breakpoint, IMarker marker) throws CoreException {
        int flags;
        int n = flags = breakpoint.isEnabled() ? 1 : 0;
        if (breakpoint.getBreakpointType() != "org.eclipse.statet.r.debugBreakpoints.RExceptionBreakpoint") {
            return null;
        }
        int type = 5;
        String expr = null;
        String exceptionId = breakpoint.getExceptionId();
        String elementLabel = null;
        return new TracepointState(type, "exception", marker.getId(), exceptionId, elementLabel, flags, expr);
    }

    public @Nullable Object toEclipseData(TracepointEvent event) {
        try {
            IRBreakpoint breakpoint = this.getRBreakpoint(event);
            String label = event.getLabel();
            if (event.getType() == 5) {
                if (label == null || label.equals("*")) {
                    label = "error";
                }
            } else if (label == null && breakpoint instanceof IRLineBreakpoint) {
                IRLineBreakpoint lineBreakpoint = (IRLineBreakpoint)breakpoint;
                BreakpointTargetData breakpointData = (BreakpointTargetData)breakpoint.getTargetData(this.debugTarget);
                if (breakpointData != null && breakpointData.installed != null) {
                    label = breakpointData.installed.elementLabel;
                }
                if (label == null) {
                    try {
                        label = lineBreakpoint.getSubLabel();
                        if (label == null) {
                            label = lineBreakpoint.getElementLabel();
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
            switch (event.getType()) {
                case 1: {
                    return new TracepointEventMethodBreakpointStatus(event, label, breakpoint);
                }
                case 5: {
                    return new TracepointEventExceptionBreakpointStatus(event, label, breakpoint);
                }
            }
            return new TracepointEventBreakpointStatus(event, label, breakpoint);
        }
        catch (Exception e) {
            RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occurred when creating breakpoint status.", (Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.breakpointManager != null) {
            if (DebugPlugin.getDefault() != null) {
                this.breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
                this.breakpointManager.removeBreakpointListener((IBreakpointsListener)this);
                IBreakpoint[] breakpoints = this.breakpointManager.getBreakpoints("org.eclipse.statet.r.debugModels.R");
                int i = 0;
                while (i < breakpoints.length) {
                    if (breakpoints[i] instanceof IRBreakpoint) {
                        IRBreakpoint breakpoint = (IRBreakpoint)breakpoints[i];
                        breakpoint.unregisterTarget(this.debugTarget);
                    }
                    ++i;
                }
            }
            this.breakpointManager = null;
        }
        Object object = this.stateUpdatesLock;
        synchronized (object) {
            this.stateUpdatesBreakpoints.clear();
        }
        object = this.stateUpdatesMap;
        synchronized (object) {
            this.stateUpdatesMap.clear();
        }
        object = this.positionUpdatesLock;
        synchronized (object) {
            this.positionUpdatesBreakpoints.clear();
            this.positionUpdatesElements.clear();
        }
    }

    private static class BreakpointTargetData
    implements IRBreakpoint.ITargetData,
    Immutable {
        private final @Nullable ElementInstallData latest;
        private final @Nullable ElementInstallData installed;

        public BreakpointTargetData(@Nullable ElementInstallData latest, @Nullable ElementInstallData installed) {
            this.latest = latest;
            this.installed = installed;
        }

        @Override
        public boolean isInstalled() {
            return this.installed != null;
        }

        public <T> @Nullable T getAdapter(Class<T> adapterType) {
            return null;
        }
    }

    private static class Element
    extends ElementTracepoints {
        private final IResource resource;

        public Element(SrcfileData fileInfo, IResource resource, String elementId, int @Nullable [] elementSrcref) {
            super(fileInfo, elementId, elementSrcref);
            this.resource = resource;
        }

        public List<Position> getPositions() {
            return super.getPositions();
        }

        public IResource getResource() {
            return this.resource;
        }
    }

    private static class ElementInstallData {
        private final IResource resource;
        private final String elementId;
        private final @Nullable String elementLabel;

        public ElementInstallData(IResource resource, String elementId, @Nullable String elementLabel) {
            this.resource = resource;
            this.elementId = elementId;
            this.elementLabel = elementLabel;
        }

        public ElementInstallData(IResource resource, String elementId, Position position) {
            this.resource = resource;
            this.elementId = elementId;
            this.elementLabel = position.getElementLabel();
        }

        public int hashCode() {
            return this.resource.hashCode() ^ Objects.hashCode(this.elementId);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ElementInstallData) {
                ElementInstallData other = (ElementInstallData)obj;
                return this.resource.equals((Object)other.resource) && Objects.equals(this.elementId, other.elementId) && Objects.equals(this.elementLabel, other.elementLabel);
            }
            return false;
        }
    }

    private static class Position
    extends TracepointPosition {
        private final IRLineBreakpoint breakpoint;
        private @Nullable String label;

        public Position(int type, long id, int[] exprIndex, IRLineBreakpoint breakpoint) {
            super(type, id, exprIndex);
            this.breakpoint = breakpoint;
        }

        public IRLineBreakpoint getBreakpoint() {
            return this.breakpoint;
        }

        void setLabel(@Nullable String label) {
            this.label = label;
        }

        public @Nullable String getElementLabel() {
            return this.label;
        }
    }

    private static class UpdateData {
        private final IResource resource;
        private final String elementId;

        public UpdateData(IResource resource, String elementId) {
            this.resource = resource;
            this.elementId = elementId;
        }
    }
}

