/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.SourceUnitFactory;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public abstract class AbstractFilePersistenceSourceUnitFactory
implements SourceUnitFactory {
    private static final String IFILE_PREFIX = "platform:/resource";

    public static String createResourceId(IResource file) {
        IPath path = file.getFullPath();
        return IFILE_PREFIX + path.toPortableString();
    }

    public static String createResourceId(URI uri) {
        if ((uri = uri.normalize()).getScheme() == null) {
            return "xxx:" + uri.toString();
        }
        return uri.toString();
    }

    @Override
    public @Nullable String createId(Object from) {
        String s;
        if (from instanceof IFile) {
            return AbstractFilePersistenceSourceUnitFactory.createResourceId((IResource)((IFile)from));
        }
        if (from instanceof String && (s = (String)from).startsWith(IFILE_PREFIX)) {
            return s;
        }
        return null;
    }

    @Override
    public @Nullable SourceUnit createSourceUnit(String id, Object from) {
        IFile ifile;
        if (from instanceof IFile) {
            ifile = (IFile)from;
        } else {
            IPath path = Path.fromPortableString((String)id.substring(IFILE_PREFIX.length()));
            ifile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        }
        return this.createSourceUnit(id, ifile);
    }

    protected abstract SourceUnit createSourceUnit(String var1, IFile var2);
}

