/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core;

import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.databinding.core.DataStatus;

public final class AggregateValidationStatus
extends ComputedValue<IStatus> {
    public static final int MAX_INFO_SEVERITY = 3;
    private final int strategy;
    private final IObservableCollection<? extends ValidationStatusProvider> validationStatusProviders;

    public AggregateValidationStatus(DataBindingContext dbc, int strategy) {
        this(dbc.getValidationRealm(), (IObservableCollection<? extends ValidationStatusProvider>)dbc.getValidationStatusProviders(), strategy);
    }

    public AggregateValidationStatus(IObservableCollection<? extends ValidationStatusProvider> validationStatusProviders, int strategy) {
        this(Realm.getDefault(), validationStatusProviders, strategy);
    }

    public AggregateValidationStatus(Realm realm, IObservableCollection<? extends ValidationStatusProvider> validationStatusProviders, int strategy) {
        super(realm, IStatus.class);
        if (strategy != 3) {
            throw new IllegalArgumentException("strategy= " + strategy);
        }
        this.validationStatusProviders = validationStatusProviders;
        this.strategy = strategy;
    }

    protected IStatus calculate() {
        IStatus result = AggregateValidationStatus.getStatusMaxInfoSeverity(this.validationStatusProviders);
        return result;
    }

    public static IStatus getStatusMaxInfoSeverity(Collection<? extends ValidationStatusProvider> validationStatusProviders) {
        int maxSeverity = 0;
        IStatus maxStatus = Status.OK_STATUS;
        for (ValidationStatusProvider validationStatusProvider : validationStatusProviders) {
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            int severity = DataStatus.getInfoSeverity(status);
            if (severity <= maxSeverity) continue;
            maxSeverity = severity;
            maxStatus = status;
        }
        return maxStatus;
    }
}

