/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;

public final class ExtClientCmdItem
extends MainCmdItem {
    private static final int OV_WITHMAP = 0x1000000;
    private static final int OV_WITHSTATUS = 0x8000000;
    private String command;
    private RList data;
    private RjsStatus status;

    public ExtClientCmdItem(String command, int options, RList args, boolean waitForClient) {
        assert (command != null);
        this.command = command;
        int n = this.options = waitForClient ? options | Integer.MIN_VALUE : options;
        if (args != null) {
            this.options |= 0x1000000;
            this.data = args;
        }
    }

    public ExtClientCmdItem(RJIO io) throws IOException {
        this.requestId = io.readInt();
        this.command = io.readString();
        this.options = io.readInt();
        if ((this.options & 0x8000000) != 0) {
            this.status = new RjsStatus(io);
            return;
        }
        if ((this.options & 0x1000000) != 0) {
            io.flags = 0;
            this.data = (RList)DataCmdItem.gDefaultFactory.readObject(io);
        }
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeInt(this.requestId);
        out.writeString(this.command);
        out.writeInt(this.options);
        if ((this.options & 0x8000000) != 0) {
            this.status.writeExternal(out);
            return;
        }
        if ((this.options & 0x1000000) != 0) {
            out.flags = 0;
            DataCmdItem.gDefaultFactory.writeObject((RObject)this.data, out);
        }
    }

    @Override
    public byte getCmdType() {
        return 5;
    }

    @Override
    public byte getOp() {
        return 0;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        assert (status != null);
        if (status == RjsStatus.OK_STATUS) {
            this.options = this.options & 0xF00FFFFF | 0x40000000;
            this.status = null;
        } else {
            this.options = this.options & 0xF00FFFFF | 0x48000000;
            this.status = status;
        }
    }

    public void setAnswer(RList answer) {
        this.options = this.options & 0xF00FFFFF | 0x40000000;
        if (answer != null) {
            this.options |= 0x1000000;
        }
        this.status = null;
        this.data = answer;
    }

    @Override
    public boolean isOK() {
        return this.status == null || this.status.getSeverity() == 0;
    }

    @Override
    public RjsStatus getStatus() {
        return this.status;
    }

    @Override
    public String getDataText() {
        return this.command;
    }

    public RList getDataArgs() {
        return this.data;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (!(other instanceof ExtClientCmdItem)) {
            return false;
        }
        ExtClientCmdItem otherItem = (ExtClientCmdItem)other;
        if (!this.getDataText().equals(otherItem.getDataText())) {
            return false;
        }
        if (this.options != otherItem.options) {
            return false;
        }
        return (this.options & 0x1000000) == 0 || this.getDataArgs().equals(otherItem.getDataArgs());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("ExtClientCmdItem ");
        sb.append(this.command);
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        if ((this.options & 0x1000000) != 0) {
            sb.append("\n<ARGS>\n");
            sb.append(this.data.toString());
            sb.append("\n</ARGS>");
        } else {
            sb.append("\n<ARGS/>");
        }
        return sb.toString();
    }
}

