/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.status;

import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.CancelStatus;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.OkStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.WarningStatus;

@NonNullByDefault
public class Statuses {
    static final String UNKNOWN_ID = "unknown";
    public static final Status OK_STATUS = new OkStatus("unknown", 0, "OK");
    public static final Status CANCEL_STATUS = new CancelStatus("unknown", 1, "Canceled");

    public static Status newStatus(int severity, String bundleId, int code, String message, @Nullable Throwable exception) {
        switch (severity) {
            case 0: {
                return new OkStatus(bundleId, code, message);
            }
            case 1: {
                return new InfoStatus(bundleId, code, message, exception);
            }
            case 2: {
                return new WarningStatus(bundleId, code, message, exception);
            }
            case 4: {
                return new ErrorStatus(bundleId, code, message, exception);
            }
            case 8: {
                return new CancelStatus(bundleId, code, message, exception);
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    public static Status newStatus(int severity, String bundleId, String message, @Nullable Throwable exception) {
        switch (severity) {
            case 0: {
                return new OkStatus(bundleId, message);
            }
            case 1: {
                return new InfoStatus(bundleId, message, exception);
            }
            case 2: {
                return new WarningStatus(bundleId, message, exception);
            }
            case 4: {
                return new ErrorStatus(bundleId, message, exception);
            }
            case 8: {
                return new CancelStatus(bundleId, message, exception);
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    public static Status newStatus(int severity, String bundleId, String message) {
        switch (severity) {
            case 0: {
                return new OkStatus(bundleId, message);
            }
            case 1: {
                return new InfoStatus(bundleId, message);
            }
            case 2: {
                return new WarningStatus(bundleId, message);
            }
            case 4: {
                return new ErrorStatus(bundleId, message);
            }
            case 8: {
                return new CancelStatus(bundleId, message);
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    public static Status getMoreSevere(Status status1, Status status2) {
        if (status1.getSeverity() > status2.getSeverity()) {
            return status1;
        }
        return status2;
    }

    public static @Nullable Status getMostSevere(List<? extends Status> statuses) {
        Status max = null;
        for (Status status : statuses) {
            if (status.getSeverity() == 4) {
                return status;
            }
            if (max != null && status.getSeverity() < max.getSeverity()) continue;
            max = status;
        }
        return max;
    }

    public static String getSeverityString(byte severity) {
        switch (severity) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 4: {
                return "ERROR";
            }
            case 8: {
                return "CANCEL";
            }
        }
        throw new IllegalArgumentException("severity= " + severity);
    }

    private Statuses() {
    }
}

