/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport;

import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.grid.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.TransformLayer;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.IStructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.print.PrintEntireGridCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOffCommand;
import org.eclipse.statet.ecommons.waltable.print.TurnViewportOnCommand;
import org.eclipse.statet.ecommons.waltable.selection.CellSelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.ColumnSelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.RowSelectionEvent;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.statet.ecommons.waltable.viewport.IViewportDim;
import org.eclipse.statet.ecommons.waltable.viewport.RecalculateScrollBarsCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.ScrollEvent;
import org.eclipse.statet.ecommons.waltable.viewport.ScrollPageCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.ScrollStepCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.SelectRelativePageCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.ShowCellInViewportCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.ShowPositionInViewportCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportDragCommandHandler;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportLayerDim;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportSelectDimPositionsCommandHandler;
import org.eclipse.swt.widgets.Display;

public class ViewportLayer
extends TransformLayer {
    static final int EDGE_HOVER_REGION_SIZE = 16;
    static final int PAGE_INTERSECTION_SIZE = 16;
    private final ILayer scrollableLayer;
    private boolean viewportOff = false;
    private final long[] savedOriginPixel = new long[2];
    private MoveViewportRunnable edgeHoverRunnable;

    public ViewportLayer(ILayer underlyingLayer) {
        super(underlyingLayer);
        this.scrollableLayer = underlyingLayer;
        this.registerCommandHandlers();
        this.initDims();
    }

    @Override
    public void dispose() {
        super.dispose();
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            this.disposeDim(orientation);
            ++n2;
        }
        this.cancelEdgeHoverScroll();
    }

    public boolean isViewportOff() {
        return this.viewportOff;
    }

    @Override
    protected void initDims() {
        ILayer scrollable = this.getScrollableLayer();
        if (scrollable == null) {
            return;
        }
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            this.disposeDim(orientation);
            this.setDim(new ViewportLayerDim(this, scrollable.getDim(orientation)));
            ++n2;
        }
    }

    protected void disposeDim(Orientation orientation) {
        ViewportLayerDim dim = this.get(orientation);
        if (dim != null) {
            dim.dispose();
        }
    }

    @Override
    public IViewportDim getDim(Orientation orientation) {
        return (IViewportDim)super.getDim(orientation);
    }

    final ViewportLayerDim get(Orientation orientation) {
        return (ViewportLayerDim)super.getDim(orientation);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RecalculateScrollBarsCommandHandler(this));
        this.registerCommandHandler(new ShowCellInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowPositionInViewportCommandHandler());
        this.registerCommandHandler(new ViewportSelectDimPositionsCommandHandler(this));
        this.registerCommandHandler(new ViewportDragCommandHandler(this));
        this.registerCommandHandler(new SelectRelativePageCommandHandler(this));
        this.registerCommandHandler(new ScrollStepCommandHandler(this));
        this.registerCommandHandler(new ScrollPageCommandHandler(this));
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        return super.getCellByPosition(columnPosition, rowPosition);
    }

    protected void fireScrollEvent() {
        this.fireLayerEvent(new ScrollEvent(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand) {
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command.cloneCommand();
            if (clientAreaResizeCommand.convertToTargetLayer(this)) {
                long widthDiff = (long)clientAreaResizeCommand.getScrollable().getClientArea().width - clientAreaResizeCommand.getCalcArea().width;
                long heightDiff = (long)clientAreaResizeCommand.getScrollable().getClientArea().height - clientAreaResizeCommand.getCalcArea().height;
                this.get(Orientation.HORIZONTAL).checkScrollBar(clientAreaResizeCommand.getScrollable());
                this.get(Orientation.VERTICAL).checkScrollBar(clientAreaResizeCommand.getScrollable());
                this.get(Orientation.HORIZONTAL).handleResize();
                this.get(Orientation.VERTICAL).handleResize();
                LRectangle possibleArea = SWTUtil.toNatTable(clientAreaResizeCommand.getScrollable().getClientArea());
                possibleArea.width -= widthDiff;
                possibleArea.height -= heightDiff;
                clientAreaResizeCommand.setCalcArea(possibleArea);
                return super.doCommand(clientAreaResizeCommand);
            }
        } else {
            if (command instanceof TurnViewportOffCommand) {
                if (!this.isViewportOff()) {
                    Orientation[] orientationArray = Orientation.values();
                    int n = orientationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Orientation orientation = orientationArray[n2];
                        this.savedOriginPixel[orientation.ordinal()] = this.get(orientation).getOriginPixel();
                        ++n2;
                    }
                    this.viewportOff = true;
                    this.fireScrollEvent();
                }
                return true;
            }
            if (command instanceof TurnViewportOnCommand) {
                if (this.isViewportOff()) {
                    this.viewportOff = false;
                    Orientation[] orientationArray = Orientation.values();
                    int n = orientationArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Orientation orientation = orientationArray[n3];
                        this.get(orientation).doSetOriginPixel(this.savedOriginPixel[orientation.ordinal()]);
                        ++n3;
                    }
                    this.fireScrollEvent();
                }
                return true;
            }
            if (command instanceof PrintEntireGridCommand) {
                this.get(Orientation.HORIZONTAL).movePositionIntoViewport(0L);
                this.get(Orientation.VERTICAL).movePositionIntoViewport(0L);
            }
        }
        return super.doCommand(command);
    }

    public void recalculateScrollBars() {
        this.get(Orientation.HORIZONTAL).handleResize();
        this.get(Orientation.VERTICAL).handleResize();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isHorizontalStructureChanged()) {
                this.get(Orientation.HORIZONTAL).handleStructuralChange(structuralChangeEvent.getColumnDiffs());
            }
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                this.get(Orientation.VERTICAL).handleStructuralChange(structuralChangeEvent.getRowDiffs());
            }
        }
        if (event instanceof CellSelectionEvent) {
            this.processSelection((CellSelectionEvent)event);
        } else if (event instanceof ColumnSelectionEvent) {
            this.processColumnSelection((ColumnSelectionEvent)event);
        } else if (event instanceof RowSelectionEvent) {
            this.processRowSelection((RowSelectionEvent)event);
        }
        super.handleLayerEvent(event);
    }

    private void processSelection(CellSelectionEvent selectionEvent) {
        if (selectionEvent.getRevealCell()) {
            this.get(Orientation.HORIZONTAL).movePositionIntoViewport(selectionEvent.getColumnPosition());
            this.get(Orientation.VERTICAL).movePositionIntoViewport(selectionEvent.getRowPosition());
        }
    }

    private void processColumnSelection(ColumnSelectionEvent selectionEvent) {
        long explicitePosition = selectionEvent.getColumnPositionToReveal();
        if (explicitePosition >= 0L) {
            this.get(Orientation.HORIZONTAL).movePositionIntoViewport(explicitePosition);
        }
    }

    private void processRowSelection(RowSelectionEvent selectionEvent) {
        long explicitePosition = selectionEvent.getRowPositionToReveal();
        if (explicitePosition >= 0L) {
            this.get(Orientation.VERTICAL).movePositionIntoViewport(explicitePosition);
            return;
        }
    }

    public ILayer getScrollableLayer() {
        return this.scrollableLayer;
    }

    @Override
    public String toString() {
        return "Viewport Layer";
    }

    public void drag(long x, long y) {
        if (x < 0L && y < 0L) {
            this.cancelEdgeHoverScroll();
            return;
        }
        MoveViewportRunnable move = this.edgeHoverRunnable;
        if (move == null) {
            move = new MoveViewportRunnable();
        }
        move.fast = true;
        boolean requireSchedule = false;
        LRectangle clientArea = this.getClientAreaProvider().getClientArea();
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            LRange lRange = clientArea.getRange(orientation);
            long pixel = orientation == Orientation.HORIZONTAL ? x : y;
            int change = 0;
            if (pixel >= lRange.start && pixel < lRange.start + 16L) {
                change = -1;
                if (pixel >= lRange.start + 8L) {
                    move.fast = false;
                }
            } else if (pixel >= lRange.end - 16L && pixel < lRange.end) {
                change = 1;
                if (pixel < lRange.end - 8L) {
                    move.fast = false;
                }
            }
            ((MoveViewportRunnable)move).change[orientation.ordinal()] = change;
            requireSchedule |= change != 0;
            ++n2;
        }
        if (requireSchedule) {
            move.schedule();
        } else {
            this.cancelEdgeHoverScroll();
        }
    }

    private void cancelEdgeHoverScroll() {
        this.edgeHoverRunnable = null;
    }

    class MoveViewportRunnable
    implements Runnable {
        private final int[] change = new int[2];
        private boolean fast;
        private final Display display = Display.getCurrent();

        public void schedule() {
            if (ViewportLayer.this.edgeHoverRunnable != this) {
                ViewportLayer.this.edgeHoverRunnable = this;
                this.display.timerExec(500, (Runnable)this);
            }
        }

        @Override
        public void run() {
            if (ViewportLayer.this.edgeHoverRunnable != this) {
                return;
            }
            Orientation[] orientationArray = Orientation.values();
            int n = orientationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Orientation orientation = orientationArray[n2];
                switch (this.change[orientation.ordinal()]) {
                    case -1: {
                        ViewportLayer.this.get(orientation).scrollBackwardByPosition();
                        break;
                    }
                    case 1: {
                        ViewportLayer.this.get(orientation).scrollForwardByPosition();
                    }
                }
                ++n2;
            }
            this.display.timerExec(this.fast ? 100 : 500, (Runnable)this);
        }
    }
}

