/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.cell;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.data.ControlData;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;

public class LayerCell
implements ILayerCell {
    private static final ControlData NO_DATA = new ControlData(0, "");
    private final ILayer layer;
    private final ILayerCellDim h;
    private final ILayerCellDim v;

    public LayerCell(ILayer layer, ILayerCellDim horizontalDim, ILayerCellDim verticalDim) {
        this.layer = layer;
        this.h = horizontalDim;
        this.v = verticalDim;
    }

    @Override
    public final ILayer getLayer() {
        return this.layer;
    }

    @Override
    public final ILayerCellDim getDim(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? this.h : this.v;
    }

    @Override
    public final long getColumnPosition() {
        return this.h.getPosition();
    }

    @Override
    public final long getRowPosition() {
        return this.v.getPosition();
    }

    @Override
    public final long getOriginColumnPosition() {
        return this.h.getOriginPosition();
    }

    @Override
    public final long getOriginRowPosition() {
        return this.v.getOriginPosition();
    }

    @Override
    public final long getColumnSpan() {
        return this.h.getPositionSpan();
    }

    @Override
    public final long getRowSpan() {
        return this.v.getPositionSpan();
    }

    @Override
    public final boolean isSpannedCell() {
        return this.getColumnSpan() > 1L || this.getRowSpan() > 1L;
    }

    @Override
    public DisplayMode getDisplayMode() {
        return DisplayMode.NORMAL;
    }

    @Override
    public LabelStack getConfigLabels() {
        return new LabelStack();
    }

    @Override
    public Object getDataValue(int flags, IProgressMonitor monitor) {
        return NO_DATA;
    }

    @Override
    public LRectangle getBounds() {
        ILayerCellDim dim = this.getDim(Orientation.HORIZONTAL);
        long cellPosition = dim.getPosition();
        long firstPosition = dim.getOriginPosition();
        long lastPosition = firstPosition + dim.getPositionSpan() - 1L;
        ILayerDim layerDim = this.getLayer().getDim(Orientation.HORIZONTAL);
        long xOffset = layerDim.getPositionStart(cellPosition, firstPosition);
        long width = firstPosition == lastPosition ? (long)layerDim.getPositionSize(cellPosition, lastPosition) : layerDim.getPositionStart(cellPosition, lastPosition) - xOffset + (long)layerDim.getPositionSize(cellPosition, lastPosition);
        dim = this.getDim(Orientation.VERTICAL);
        cellPosition = dim.getPosition();
        firstPosition = dim.getOriginPosition();
        lastPosition = firstPosition + dim.getPositionSpan() - 1L;
        layerDim = this.getLayer().getDim(Orientation.VERTICAL);
        long yOffset = layerDim.getPositionStart(cellPosition, firstPosition);
        long height = firstPosition == lastPosition ? (long)layerDim.getPositionSize(cellPosition, lastPosition) : layerDim.getPositionStart(cellPosition, lastPosition) - yOffset + (long)layerDim.getPositionSize(cellPosition, lastPosition);
        return new LRectangle(xOffset, yOffset, width, height);
    }

    public int hashCode() {
        int h = this.h.hashCode() + this.v.hashCode();
        return h ^ h * this.getLayer().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ILayerCell)) {
            return false;
        }
        ILayerCell other = (ILayerCell)obj;
        return this.layer.equals(other.getLayer()) && this.h.equals(other.getDim(Orientation.HORIZONTAL)) && this.v.equals(other.getDim(Orientation.VERTICAL));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " (" + "\n\tdata= " + this.getDataValue(0, null) + "\n\tlayer= " + this.getLayer().getClass().getSimpleName() + "\n\thorizontal= " + this.h + "\n\tvertical= " + this.v + "\n)";
    }
}

