/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.IConfiguration;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.ILayerListener;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEventHandler;
import org.eclipse.statet.ecommons.waltable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;
import org.eclipse.statet.ecommons.waltable.ui.IClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.internal.ecommons.waltable.LayerListenerList;

public abstract class AbstractLayer
implements ILayer {
    private ILayerDim hDim;
    private ILayerDim vDim;
    protected ILayerPainter layerPainter;
    private IClientAreaProvider clientAreaProvider = IClientAreaProvider.DEFAULT;
    private final Map<Class<? extends ILayerCommand>, ILayerCommandHandler<? extends ILayerCommand>> commandHandlers = new LinkedHashMap<Class<? extends ILayerCommand>, ILayerCommandHandler<? extends ILayerCommand>>();
    private final Map<Class<? extends ILayerEvent>, ILayerEventHandler<? extends ILayerEvent>> eventHandlers = new HashMap<Class<? extends ILayerEvent>, ILayerEventHandler<? extends ILayerEvent>>();
    private final List<IPersistable> persistables = new LinkedList<IPersistable>();
    private final LayerListenerList listeners = new LayerListenerList();
    private final Collection<IConfiguration> configurations = new ArrayList<IConfiguration>();

    protected AbstractLayer() {
        this.initDims();
        this.layerPainter = this.createPainter();
    }

    protected abstract void initDims();

    protected void setDim(ILayerDim dim) {
        if (dim == null) {
            throw new NullPointerException("dim");
        }
        if (dim.getOrientation() == Orientation.HORIZONTAL) {
            this.hDim = dim;
        } else {
            this.vDim = dim;
        }
    }

    @Override
    public ILayerDim getDim(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? this.hDim : this.vDim;
    }

    protected ILayerPainter createPainter() {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        return new LabelStack();
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        for (IPersistable persistable : this.persistables) {
            persistable.saveState(prefix, properties);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        for (IPersistable persistable : this.persistables) {
            persistable.loadState(prefix, properties);
        }
    }

    @Override
    public void registerPersistable(IPersistable persistable) {
        this.persistables.add(persistable);
    }

    @Override
    public void unregisterPersistable(IPersistable persistable) {
        this.persistables.remove(persistable);
    }

    public void addConfiguration(IConfiguration configuration) {
        this.configurations.add(configuration);
    }

    public void clearConfiguration() {
        this.configurations.clear();
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(configRegistry);
            configuration.configureUiBindings(uiBindingRegistry);
        }
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        for (Class<? extends ILayerCommand> commandClass : this.commandHandlers.keySet()) {
            ILayerCommandHandler<? extends ILayerCommand> commandHandler;
            if (!commandClass.isInstance(command) || !(commandHandler = this.commandHandlers.get(commandClass)).doCommand(this, command.cloneCommand())) continue;
            return true;
        }
        return false;
    }

    protected void registerCommandHandlers() {
    }

    @Override
    public void registerCommandHandler(ILayerCommandHandler<?> commandHandler) {
        this.commandHandlers.put(commandHandler.getCommandClass(), commandHandler);
    }

    @Override
    public void unregisterCommandHandler(Class<? extends ILayerCommand> commandClass) {
        this.commandHandlers.remove(commandClass);
    }

    @Override
    public void addLayerListener(ILayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLayerListener(ILayerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        for (Class<? extends ILayerEvent> eventClass : this.eventHandlers.keySet()) {
            if (!eventClass.isInstance(event)) continue;
            ILayerEventHandler<? extends ILayerEvent> eventHandler = this.eventHandlers.get(eventClass);
            eventHandler.handleLayerEvent(event);
        }
        if (event.convertToLocal(this)) {
            this.fireLayerEvent(event);
        }
    }

    public void registerEventHandler(ILayerEventHandler<?> eventHandler) {
        this.eventHandlers.put(eventHandler.getLayerEventClass(), eventHandler);
    }

    public void unregisterEventHandler(ILayerEventHandler<?> eventHandler) {
        this.eventHandlers.remove(eventHandler.getLayerEventClass());
    }

    @Override
    public void fireLayerEvent(ILayerEvent event) {
        ILayerListener[] currentListeners = this.listeners.getListeners();
        int last = currentListeners.length - 1;
        if (last >= 0) {
            int i = 0;
            while (i < last) {
                currentListeners[i].handleLayerEvent(event.cloneEvent());
                ++i;
            }
            currentListeners[last].handleLayerEvent(event);
        }
    }

    @Override
    public ILayerPainter getLayerPainter() {
        if (this.layerPainter == null) {
            this.layerPainter = new GridLineCellLayerPainter();
        }
        return this.layerPainter;
    }

    protected void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    @Override
    public IClientAreaProvider getClientAreaProvider() {
        return this.clientAreaProvider;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        this.clientAreaProvider = clientAreaProvider;
    }

    @Override
    public final long getColumnCount() {
        return this.hDim.getPositionCount();
    }

    @Override
    public final long getWidth() {
        return this.hDim.getSize();
    }

    @Override
    public final long getColumnPositionByX(long x) {
        try {
            return this.hDim.getPositionByPixel(x);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public final long getRowCount() {
        return this.vDim.getPositionCount();
    }

    @Override
    public final long getHeight() {
        return this.vDim.getSize();
    }

    @Override
    public final long getRowPositionByY(long y) {
        try {
            return this.vDim.getPositionByPixel(y);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

