/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.layer;

import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.export.ExportCommandHandler;
import org.eclipse.statet.ecommons.waltable.grid.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.grid.layer.config.DefaultGridLayerConfiguration;
import org.eclipse.statet.ecommons.waltable.layer.CompositeLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.print.PrintCommandHandler;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;

public class GridLayer
extends CompositeLayer {
    public GridLayer(ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer) {
        this(bodyLayer, columnHeaderLayer, rowHeaderLayer, cornerLayer, true);
    }

    public GridLayer(ILayer bodyLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer, ILayer cornerLayer, boolean useDefaultConfiguration) {
        super(2, 2);
        this.setBodyLayer(bodyLayer);
        this.setColumnHeaderLayer(columnHeaderLayer);
        this.setRowHeaderLayer(rowHeaderLayer);
        this.setCornerLayer(cornerLayer);
        this.init(useDefaultConfiguration);
    }

    protected GridLayer(boolean useDefaultConfiguration) {
        super(2, 2);
        this.init(useDefaultConfiguration);
    }

    protected void init(boolean useDefaultConfiguration) {
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultGridLayerConfiguration(this));
        }
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new PrintCommandHandler(this));
        this.registerCommandHandler(new ExportCommandHandler(this));
    }

    @Override
    protected boolean doCommandOnChildLayers(ILayerCommand command) {
        if (this.getBodyLayer().doCommand(command)) {
            return true;
        }
        if (this.getColumnHeaderLayer().doCommand(command)) {
            return true;
        }
        if (this.getRowHeaderLayer().doCommand(command)) {
            return true;
        }
        return this.getCornerLayer().doCommand(command);
    }

    public ILayer getCornerLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 0);
    }

    public void setCornerLayer(ILayer cornerLayer) {
        this.setChildLayer("CORNER", cornerLayer, 0, 0);
    }

    public ILayer getColumnHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 0);
    }

    public void setColumnHeaderLayer(ILayer columnHeaderLayer) {
        this.setChildLayer("COLUMN_HEADER", columnHeaderLayer, 1, 0);
    }

    public ILayer getRowHeaderLayer() {
        return this.getChildLayerByLayoutCoordinate(0, 1);
    }

    public void setRowHeaderLayer(ILayer rowHeaderLayer) {
        this.setChildLayer("ROW_HEADER", rowHeaderLayer, 0, 1);
    }

    public ILayer getBodyLayer() {
        return this.getChildLayerByLayoutCoordinate(1, 1);
    }

    public void setBodyLayer(ILayer bodyLayer) {
        this.setChildLayer("BODY", bodyLayer, 1, 1);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[corner=" + this.getCornerLayer() + " columnHeader=" + this.getColumnHeaderLayer() + " rowHeader=" + this.getRowHeaderLayer() + " bodyLayer=" + this.getBodyLayer() + "]";
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand && command.convertToTargetLayer(this)) {
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command;
            LRectangle possibleArea = SWTUtil.toNatTable(clientAreaResizeCommand.getScrollable().getClientArea());
            LRectangle rowLayerArea = this.getRowHeaderLayer().getClientAreaProvider().getClientArea();
            LRectangle columnLayerArea = this.getColumnHeaderLayer().getClientAreaProvider().getClientArea();
            possibleArea.width -= rowLayerArea.width;
            possibleArea.height -= columnLayerArea.height;
            clientAreaResizeCommand.setCalcArea(possibleArea);
        }
        return super.doCommand(command);
    }
}

