/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.coordinate;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;

public enum Direction {
    LEFT(Orientation.HORIZONTAL),
    RIGHT(Orientation.HORIZONTAL),
    UP(Orientation.VERTICAL),
    DOWN(Orientation.VERTICAL);

    private final Orientation orientation;

    public static Direction backward(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? LEFT : UP;
    }

    public static Direction forward(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? RIGHT : LEFT;
    }

    private Direction(Orientation orientation) {
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public boolean isBackward() {
        switch (this) {
            case LEFT: 
            case UP: {
                return true;
            }
        }
        return false;
    }

    public boolean isForward() {
        switch (this) {
            case RIGHT: 
            case DOWN: {
                return true;
            }
        }
        return false;
    }

    public Direction getOpposite() {
        switch (this) {
            case LEFT: {
                return RIGHT;
            }
            case RIGHT: {
                return LEFT;
            }
            case UP: {
                return DOWN;
            }
        }
        return UP;
    }
}

