/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.style.ConfigAttribute;
import org.eclipse.statet.ecommons.waltable.style.DefaultDisplayModeOrdering;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.IDisplayModeLookupStrategy;

public class ConfigRegistry
implements IConfigRegistry {
    final Map<ConfigAttribute<?>, Map<DisplayMode, Map<String, ?>>> configRegistry = new HashMap();
    private IDisplayModeLookupStrategy displayModeLookupStrategy = new DefaultDisplayModeOrdering();

    @Override
    public IDisplayModeLookupStrategy getDisplayModeOrdering() {
        return this.displayModeLookupStrategy;
    }

    public void setDisplayModeOrdering(IDisplayModeLookupStrategy displayModeLookupStrategy) {
        this.displayModeLookupStrategy = displayModeLookupStrategy;
    }

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, DisplayMode targetDisplayMode, String ... configLabels) {
        return this.getConfigAttribute(configAttribute, targetDisplayMode, Arrays.asList(configLabels));
    }

    @Override
    public <T> T getConfigAttribute(ConfigAttribute<T> configAttribute, DisplayMode targetDisplayMode, List<String> configLabels) {
        T attributeValue = null;
        Map<DisplayMode, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeConfigAttributeMap != null) {
            for (DisplayMode displayMode : this.displayModeLookupStrategy.getDisplayModeOrdering(targetDisplayMode)) {
                Map<String, ?> configAttributeMap = displayModeConfigAttributeMap.get((Object)displayMode);
                if (configAttributeMap == null) continue;
                for (String configLabel : configLabels) {
                    attributeValue = (T)configAttributeMap.get(configLabel);
                    if (attributeValue == null) continue;
                    return attributeValue;
                }
                attributeValue = (T)configAttributeMap.get(null);
                if (attributeValue == null) continue;
                return attributeValue;
            }
        }
        return attributeValue;
    }

    @Override
    public <T> T getSpecificConfigAttribute(ConfigAttribute<T> configAttribute, DisplayMode displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        T attributeValue = null;
        Map<DisplayMode, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeConfigAttributeMap != null && (configAttributeMap = displayModeConfigAttributeMap.get((Object)displayMode)) != null && (attributeValue = (T)configAttributeMap.get(configLabel)) != null) {
            return attributeValue;
        }
        return attributeValue;
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue) {
        this.registerConfigAttribute(configAttribute, attributeValue, DisplayMode.NORMAL);
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, DisplayMode displayMode) {
        this.registerConfigAttribute(configAttribute, attributeValue, displayMode, null);
    }

    @Override
    public <T> void registerConfigAttribute(ConfigAttribute<T> configAttribute, T attributeValue, DisplayMode displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        Map<DisplayMode, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttribute);
        if (displayModeConfigAttributeMap == null) {
            displayModeConfigAttributeMap = new HashMap();
            this.configRegistry.put(configAttribute, displayModeConfigAttributeMap);
        }
        if ((configAttributeMap = displayModeConfigAttributeMap.get((Object)displayMode)) == null) {
            configAttributeMap = new HashMap();
            displayModeConfigAttributeMap.put(displayMode, configAttributeMap);
        }
        configAttributeMap.put(configLabel, attributeValue);
    }

    @Override
    public <T> void unregisterConfigAttribute(ConfigAttribute<T> configAttributeType, DisplayMode displayMode, String configLabel) {
        Map<String, ?> configAttributeMap;
        Map<DisplayMode, Map<String, ?>> displayModeConfigAttributeMap = this.configRegistry.get(configAttributeType);
        if (displayModeConfigAttributeMap != null && (configAttributeMap = displayModeConfigAttributeMap.get((Object)displayMode)) != null) {
            configAttributeMap.remove(configLabel);
        }
    }
}

