/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui.sourceediting;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCodeStyleSettings;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.WikidocDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikidocSourceViewerConfiguration;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;

public class WikidocSourceViewerConfigurator
extends SourceEditorViewerConfigurator
implements WikitextCoreAccess,
PropertyChangeListener {
    private static final Set<String> RESET_GROUP_IDS = new HashSet<String>(Arrays.asList("Wikitext/Wikitext.codestyle/indent"));
    private final WikitextMarkupLanguage markupLanguage;
    private WikitextCoreAccess sourceCoreAccess;
    private final WikitextCodeStyleSettings wikitextCodeStyleCopy;

    public WikidocSourceViewerConfigurator(WikitextMarkupLanguage markupLanguage, WikitextCoreAccess coreAccess, WikidocSourceViewerConfiguration config) {
        super((SourceEditorViewerConfiguration)config);
        if (markupLanguage == null) {
            throw new NullPointerException("markupLanguage");
        }
        this.markupLanguage = markupLanguage;
        this.wikitextCodeStyleCopy = new WikitextCodeStyleSettings(1);
        config.setCoreAccess(this);
        this.setSource(coreAccess);
        this.wikitextCodeStyleCopy.load(this.sourceCoreAccess.getWikitextCodeStyle());
        this.wikitextCodeStyleCopy.resetDirty();
        this.wikitextCodeStyleCopy.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new WikidocDocumentSetupParticipant(this.markupLanguage);
    }

    protected Set<String> getResetGroupIds() {
        return RESET_GROUP_IDS;
    }

    public void setSource(WikitextCoreAccess newAccess) {
        if (newAccess == null) {
            newAccess = WikitextCore.getWorkbenchAccess();
        }
        if (this.sourceCoreAccess != newAccess) {
            this.sourceCoreAccess = newAccess;
            this.handleSettingsChanged(null, null);
        }
    }

    public void setTarget(ISourceEditor sourceEditor) {
        super.setTarget(sourceEditor);
        SourceViewer viewer = sourceEditor.getViewer();
        viewer.getTextWidget().setData(ISourceViewer.class.getName(), (Object)viewer);
        viewer.getTextWidget().setData(MarkupLanguage.class.getName(), (Object)this.markupLanguage);
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        this.wikitextCodeStyleCopy.resetDirty();
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        super.checkSettingsChanges(groupIds, options);
        if (groupIds.contains("Wikitext/Wikitext.codestyle/indent")) {
            this.wikitextCodeStyleCopy.load(this.sourceCoreAccess.getWikitextCodeStyle());
        }
        if (groupIds.contains("org.eclipse.statet.docmlet.wikitext.ui/editor/editing")) {
            this.updateCompleteConfig = true;
        }
    }

    public PreferenceAccess getPrefs() {
        return this.sourceCoreAccess.getPrefs();
    }

    public WikitextCodeStyleSettings getWikitextCodeStyle() {
        return this.wikitextCodeStyleCopy;
    }
}

