/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.yaml.core.ast.YamlAst;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.ast.YamlAstVisitor;

public abstract class Scalar
extends YamlAstNode {
    String value;

    Scalar(YamlAstNode parent, int startOffset, int endOffset, String value) {
        super(parent, startOffset, endOffset);
        this.value = value;
    }

    @Override
    public YamlAst.NodeType getNodeType() {
        return YamlAst.NodeType.SCALAR;
    }

    public String getText() {
        return this.value;
    }

    public boolean hasChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    @Override
    public YamlAstNode getChild(int index) {
        throw new IndexOutOfBoundsException();
    }

    public int getChildIndex(AstNode element) {
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInYamlChildren(YamlAstVisitor visitor) throws InvocationTargetException {
    }

    static class DQuoted
    extends Scalar {
        DQuoted(YamlAstNode parent, int startOffset, int endOffset, String value) {
            super(parent, startOffset, endOffset, value);
        }

        @Override
        public char getOperator() {
            return '\"';
        }
    }

    static class Plain
    extends Scalar {
        Plain(YamlAstNode parent, int startOffset, int endOffset, String value) {
            super(parent, startOffset, endOffset, value);
        }

        @Override
        public char getOperator() {
            return '\u0000';
        }
    }

    static class SQuoated
    extends Scalar {
        SQuoated(YamlAstNode parent, int startOffset, int endOffset, String value) {
            super(parent, startOffset, endOffset, value);
        }

        @Override
        public char getOperator() {
            return '\'';
        }
    }
}

