/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.RjInvalidConfigurationException;
import org.eclipse.statet.rj.server.util.PathEntry;
import org.eclipse.statet.rj.server.util.PathEntryProvider;

@NonNullByDefault
public class RJContext {
    public static final String RJ_BUNDLE_PATH_PROPERTY_KEY = "org.eclipse.statet.rj.Path";
    public static final String RJ_SERVER_CLASS_PATH_PROPERTY_KEY = "org.eclipse.statet.rj.server.ClassPath.urls";
    public static final String RJ_PATH_SEPARATOR = ":,:";
    private static final Pattern RJ_PATH_SEPARATOR_PATTERN = Pattern.compile(":,:", 16);
    protected static final String LOCALHOST_POLICY_FILENAME = "localhost.policy";
    private ImList<PathEntryProvider> libPathEntryProviders;

    public static PathEntryProvider detectRJLibPaths() throws RjInitFailedException {
        ArrayList<Path> expliciteBaseDirectories = null;
        String path = System.getProperty(RJ_BUNDLE_PATH_PROPERTY_KEY);
        if (path != null) {
            String[] directories;
            expliciteBaseDirectories = new ArrayList<Path>();
            String[] stringArray = directories = RJ_PATH_SEPARATOR_PATTERN.split(path);
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                String pathString = stringArray[n2];
                expliciteBaseDirectories.add(Paths.get(pathString, new String[0]));
                ++n2;
            }
        }
        return PathEntryProvider.detectLibPaths(RJContext.class, expliciteBaseDirectories);
    }

    public RJContext(PathEntryProvider pathEntryProvider, PathEntryProvider ... pathEntryProviderAdditionals) {
        this.libPathEntryProviders = ImCollections.addElement((List)ImCollections.newList((Object[])pathEntryProviderAdditionals), (int)0, (Object)pathEntryProvider);
    }

    public RJContext(Collection<PathEntryProvider> pathEntryProviders) {
        this.libPathEntryProviders = ImCollections.toList(pathEntryProviders);
    }

    protected RJContext() {
    }

    public List<PathEntry> searchRJLibs(List<String> libIds) throws RjInvalidConfigurationException {
        List<? extends PathEntry> candidates = this.getRJLibCandidates();
        ArrayList<PathEntry> resolved = new ArrayList<PathEntry>(libIds.size());
        StringBuilder sb = null;
        Collections.sort(candidates);
        for (String libId : libIds) {
            PathEntry entry = this.searchLib(candidates, libId);
            if (entry == null) {
                if (sb == null) {
                    sb = new StringBuilder("Missing RJ library ");
                } else {
                    sb.append(", ");
                }
                sb.append('\'');
                sb.append(libId);
                sb.append('\'');
                continue;
            }
            resolved.add(entry);
        }
        if (sb != null) {
            sb.append('.');
            throw new RjInvalidConfigurationException(sb.toString());
        }
        return resolved;
    }

    protected List<? extends PathEntry> getRJLibCandidates() throws RjInvalidConfigurationException {
        ArrayList<PathEntry> pathsEntries = new ArrayList<PathEntry>();
        for (PathEntryProvider provider : this.libPathEntryProviders) {
            provider.getEntries(pathsEntries);
        }
        return pathsEntries;
    }

    protected @Nullable PathEntry searchLib(List<? extends PathEntry> files, String bundleId) {
        for (PathEntry pathEntry : files) {
            if (!pathEntry.bundleId.equals(bundleId)) continue;
            return pathEntry;
        }
        return null;
    }

    public String getServerPolicyFilePath() throws RjInvalidConfigurationException {
        URL resource = RJContext.class.getClassLoader().getResource(LOCALHOST_POLICY_FILENAME);
        if (resource != null) {
            resource.toString();
        }
        try {
            PathEntry lib = this.searchRJLibs((List<String>)ImCollections.newList((Object)"org.eclipse.statet.rj.server")).get(0);
            Path policyPath = lib.getResourcePath(LOCALHOST_POLICY_FILENAME);
            if (policyPath != null && Files.isRegularFile(policyPath, new LinkOption[0])) {
                return policyPath.toUri().toString();
            }
            String s = lib.getUrlString();
            if (s.endsWith("/")) {
                return String.valueOf(s) + LOCALHOST_POLICY_FILENAME;
            }
            throw new UnsupportedOperationException(String.format("PathEntry= '%1$s'", lib));
        }
        catch (Exception e) {
            throw new RjInvalidConfigurationException("Failed find server policy file.", e);
        }
    }

    protected String getPropertiesDirPath() {
        return System.getProperty("user.dir");
    }

    protected @Nullable InputStream getInputStream(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    protected OutputStream getOutputStream(String path) throws IOException {
        File file = new File(path);
        return new FileOutputStream(file, false);
    }

    public @Nullable Properties loadProperties(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String path = String.valueOf(this.getPropertiesDirPath()) + '/' + name + ".properties";
        InputStream in = this.getInputStream(path);
        if (in == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public void saveProperties(String name, Properties properties) throws IOException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        String path = String.valueOf(this.getPropertiesDirPath()) + '/' + name + ".properties";
        OutputStream out = this.getOutputStream(path);
        try {
            properties.store(out, null);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

