/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.impl.AbstractCharacterStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRStore;

public class RCharacterFix64Store
extends AbstractCharacterStore
implements ExternalizableRStore {
    public static final int SEGMENT_LENGTH = 0x10000000;
    private final long length;
    protected final String[][] charValues;

    public RCharacterFix64Store(long length) {
        this.length = length;
        this.charValues = RCharacterFix64Store.new2dStringArray(length, 0x10000000);
        int i = 0;
        while (i < this.charValues.length) {
            Arrays.fill(this.charValues[i], "");
            ++i;
        }
    }

    public RCharacterFix64Store(String[][] values) {
        this.length = RCharacterFix64Store.check2dArrayLength(values, 0x10000000);
        this.charValues = values;
    }

    public RCharacterFix64Store(RJIO io, long length) throws IOException {
        this.length = length;
        this.charValues = RCharacterFix64Store.new2dStringArray(length, 0x10000000);
        int i = 0;
        while (i < this.charValues.length) {
            io.readStringData(this.charValues[i], this.charValues[i].length);
            ++i;
        }
    }

    @Override
    public void writeExternal(RJIO io) throws IOException {
        int i = 0;
        while (i < this.charValues.length) {
            io.writeStringData(this.charValues[i], this.charValues[i].length);
            ++i;
        }
    }

    @Override
    protected final boolean isStructOnly() {
        return false;
    }

    @Override
    public final long getLength() {
        return this.length;
    }

    @Override
    public boolean isNA(int idx) {
        return this.charValues[idx / 0x10000000][idx % 0x10000000] == null;
    }

    @Override
    public boolean isNA(long idx) {
        return this.charValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] == null;
    }

    @Override
    public void setNA(int idx) {
        this.charValues[idx / 0x10000000][idx % 0x10000000] = null;
    }

    @Override
    public void setNA(long idx) {
        this.charValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = null;
    }

    @Override
    public boolean isMissing(int idx) {
        return this.charValues[idx / 0x10000000][idx % 0x10000000] == null;
    }

    @Override
    public boolean isMissing(long idx) {
        return this.charValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] == null;
    }

    @Override
    public String getChar(int idx) {
        return this.charValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public String getChar(long idx) {
        return this.charValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public void setChar(int idx, String value) {
        this.charValues[idx / 0x10000000][idx % 0x10000000] = value;
    }

    @Override
    public void setChar(long idx, String value) {
        this.charValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)] = value;
    }

    @Override
    public String get(int idx) {
        if (idx < 0 || (long)idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[idx / 0x10000000][idx % 0x10000000];
    }

    @Override
    public String get(long idx) {
        if (idx < 0L || idx >= this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.charValues[(int)(idx / 0x10000000L)][(int)(idx % 0x10000000L)];
    }

    @Override
    public String[] toArray() {
        int l = this.checkToArrayLength();
        String[] array = new String[l];
        int k = 0;
        int i = 0;
        while (i < this.charValues.length) {
            String[] chars = this.charValues[i];
            System.arraycopy(chars, 0, array, k, chars.length);
            k += chars.length;
            ++i;
        }
        return array;
    }

    @Override
    public long indexOfNA(long fromIdx) {
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.charValues.length) {
            String[] chars = this.charValues[i];
            while (j < chars.length) {
                if (chars[j] != null) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }

    @Override
    public long indexOf(String character, long fromIdx) {
        if (character == null) {
            return -1L;
        }
        if (fromIdx < 0L) {
            fromIdx = 0L;
        }
        int i = (int)(fromIdx / 0x10000000L);
        int j = (int)(fromIdx % 0x10000000L);
        while (i < this.charValues.length) {
            String[] chars = this.charValues[i];
            while (j < chars.length) {
                if (chars[j] == null || !chars[j].equals(character)) continue;
                return (long)i * 0x10000000L + (long)j;
            }
            ++i;
            j = 0;
        }
        return -1L;
    }
}

