/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.statet.ecommons.text.ITokenScanner;
import org.eclipse.statet.ecommons.text.core.IPartitionConstraint;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.jcommons.collections.IntArrayList;

public class BasicHeuristicTokenScanner
implements ITokenScanner {
    protected static final IPartitionConstraint ALL_PARTITIONS_CONSTRAINT = new IPartitionConstraint(){

        public boolean matches(String partitionType) {
            return true;
        }
    };
    private final String partitioning;
    private final IPartitionConstraint defaultPartitionConstraint;
    private IDocument document;
    private IPartitionConstraint partitionConstraint;
    protected char ch;
    protected int pos;
    private int line;
    private StopCondition nonWSCondition;
    private StopCondition nonWSorLRCondition;

    public BasicHeuristicTokenScanner(IDocContentSections documentContentInfo, IPartitionConstraint defaultContentConstraint) {
        this.partitioning = documentContentInfo.getPartitioning();
        this.defaultPartitionConstraint = defaultContentConstraint;
    }

    public final IDocument getDocument() {
        return this.document;
    }

    public final String getDocumentPartitioning() {
        return this.partitioning;
    }

    protected final IPartitionConstraint getDefaultPartitionConstraint() {
        return this.defaultPartitionConstraint;
    }

    protected final IPartitionConstraint getPartitionConstraint() {
        return this.partitionConstraint;
    }

    public final char getChar() {
        return this.ch;
    }

    protected boolean isWhitespace() {
        return Character.getType(this.ch) == 12 || this.ch == '\t';
    }

    protected final StopCondition getAnyNonWSCondition() {
        if (this.nonWSCondition == null) {
            this.nonWSCondition = new StopCondition(this){

                @Override
                public boolean stop() {
                    return !this.isWhitespace();
                }
            };
        }
        return this.nonWSCondition;
    }

    protected final StopCondition getAnyNonWSorLRCondition() {
        if (this.nonWSorLRCondition == null) {
            this.nonWSorLRCondition = new StopCondition(this){

                @Override
                public boolean stop() {
                    return !this.isWhitespace() && ch != '\r' && ch != '\n';
                }
            };
        }
        return this.nonWSorLRCondition;
    }

    protected final StopCondition getNonWSCondition() {
        if (this.nonWSCondition == null) {
            this.nonWSCondition = new PartitionBasedCondition(this){

                @Override
                protected boolean matchesChar() {
                    return !this.isWhitespace();
                }
            };
        }
        return this.nonWSCondition;
    }

    protected final StopCondition getNonWSorLRCondition() {
        if (this.nonWSorLRCondition == null) {
            this.nonWSorLRCondition = new PartitionBasedCondition(this){

                @Override
                protected boolean matchesChar() {
                    return !this.isWhitespace() && ch != '\r' && ch != '\n';
                }
            };
        }
        return this.nonWSorLRCondition;
    }

    @Override
    public void configure(IDocument document, final String partitionType) {
        assert (document != null && partitionType != null);
        this.document = document;
        this.partitionConstraint = new IPartitionConstraint(){

            public boolean matches(String partitionTypeToTest) {
                return partitionType == partitionTypeToTest;
            }
        };
    }

    public void configure(IDocument document) {
        assert (document != null);
        this.document = document;
        this.partitionConstraint = ALL_PARTITIONS_CONSTRAINT;
    }

    public void configureDefaultParitions(IDocument document) {
        assert (document != null);
        this.document = document;
        this.partitionConstraint = this.getDefaultPartitionConstraint();
    }

    public void configure(IDocument document, IPartitionConstraint partitionConstraint) {
        assert (document != null && partitionConstraint != null);
        this.document = document;
        this.partitionConstraint = partitionConstraint;
    }

    public int getPosition() {
        return this.pos;
    }

    protected StopCondition createFindPeerStopCondition(int start, char[] pair, char escapeChar) {
        return escapeChar == '\u0000' ? new CharacterMatchCondition(pair) : new ExtCharacterMatchCondition(pair, escapeChar);
    }

    protected int createForwardBound(int start) throws BadLocationException {
        return this.document.getLength();
    }

    protected int createBackwardBound(int start) throws BadLocationException {
        return -1;
    }

    @Override
    public int findClosingPeer(int start, char[] pair) {
        return this.findClosingPeer(start, pair, '\u0000');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findClosingPeer(int start, char[] pair, char escapeChar) {
        Assert.isNotNull((Object)this.document);
        Assert.isTrue((start >= 0 ? 1 : 0) != 0);
        try {
            StopCondition cond = this.createFindPeerStopCondition(start, pair, escapeChar);
            int bound = this.createForwardBound(start);
            int depth = 1;
            --start;
            do {
                if ((start = this.scanForward(start + 1, bound, cond)) == -1) {
                    return -1;
                }
                if (this.ch == pair[0]) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findOpeningPeer(int start, char[] pair) {
        if (start >= this.document.getLength()) {
            start = this.document.getLength() - 1;
        }
        try {
            StopCondition cond = this.createFindPeerStopCondition(start, pair, '\u0000');
            int bound = this.createBackwardBound(start);
            int depth = 1;
            ++start;
            do {
                if ((start = this.scanBackward(start - 1, bound, cond)) == -1) {
                    return -1;
                }
                if (this.ch == pair[1]) {
                    ++depth;
                    continue;
                }
                --depth;
            } while (depth != 0);
            return start;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findOpeningPeer(int start, char[] pair, char escapeChar) {
        Assert.isTrue((start < this.document.getLength() ? 1 : 0) != 0);
        if (escapeChar == '\u0000') {
            return this.findOpeningPeer(start, pair);
        }
        try {
            StopCondition cond = this.createFindPeerStopCondition(start, pair, escapeChar);
            int bound = this.createBackwardBound(start);
            int depth = 1;
            this.line = this.document.getLineOfOffset(++start);
            block2: while (true) {
                int[] list;
                if ((list = this.preScanBackward(start - 1, bound, cond)) == null) {
                    return -1;
                }
                int i = list.length - 1;
                while (true) {
                    if (i < 0) {
                        start = this.document.getLineOffset(this.line + 1);
                        continue block2;
                    }
                    start = list[i];
                    depth = this.document.getChar(start) == pair[1] ? ++depth : --depth;
                    if (depth == 0) {
                        return start;
                    }
                    --i;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int computePairBalance(int backwardOffset, int backwardBound, int forwardOffset, int forwardBound, int initial, char[] pair, char escapeChar) {
        int balance = 0;
        StopCondition condition = this.createFindPeerStopCondition(forwardBound, pair, escapeChar);
        while (--backwardOffset >= 0) {
            if ((backwardOffset = this.scanBackward(backwardOffset, backwardBound, condition)) == -1) break;
            if (this.ch == pair[0]) {
                ++balance;
                continue;
            }
            --balance;
        }
        if (balance < 0) {
            balance = 0;
        }
        balance += initial;
        while (forwardOffset < forwardBound) {
            if ((forwardOffset = this.scanForward(forwardOffset, forwardBound, condition)) == -1) break;
            balance = this.ch == pair[0] ? ++balance : --balance;
            if (balance == 0) break;
            ++forwardOffset;
        }
        return balance;
    }

    public final int findAnyNonBlankForward(int position, int bound, boolean linebreakIsBlank) {
        return this.scanForward(position, bound, linebreakIsBlank ? this.getAnyNonWSorLRCondition() : this.getAnyNonWSCondition());
    }

    public final int findAnyNonBlankBackward(int position, int bound, boolean linebreakIsBlank) {
        return this.scanBackward(position - 1, bound, linebreakIsBlank ? this.getAnyNonWSorLRCondition() : this.getAnyNonWSCondition());
    }

    public final int findNonBlankForward(int position, int bound, boolean linebreakIsBlank) {
        return this.scanForward(position, bound, linebreakIsBlank ? this.getNonWSorLRCondition() : this.getNonWSCondition());
    }

    public final int findNonBlankBackward(int position, int bound, boolean linebreakIsBlank) {
        return this.scanBackward(position - 1, bound, linebreakIsBlank ? this.getNonWSorLRCondition() : this.getNonWSCondition());
    }

    public IRegion findBlankRegion(int position, boolean linebreakIsBlank) {
        return this.findRegion(position, linebreakIsBlank ? this.getAnyNonWSorLRCondition() : this.getAnyNonWSCondition());
    }

    public boolean isBlankLine(int position) throws BadLocationException {
        IRegion line = this.document.getLineInformationOfOffset(position);
        if (line.getLength() > 0) {
            int nonWhitespace = this.findAnyNonBlankForward(line.getOffset(), line.getOffset() + line.getLength(), false);
            return nonWhitespace == -1;
        }
        return true;
    }

    public final IRegion findCommonWord(int position) {
        return this.findRegion(position, new StopCondition(this){

            @Override
            public boolean stop() {
                return !Character.isLetterOrDigit(ch);
            }
        });
    }

    public final int getFirstLineOfRegion(IRegion region) throws BadLocationException {
        return this.document.getLineOfOffset(region.getOffset());
    }

    public final int getLastLineOfRegion(IRegion region) throws BadLocationException {
        if (region.getLength() == 0) {
            return this.document.getLineOfOffset(region.getOffset());
        }
        return this.document.getLineOfOffset(region.getOffset() + region.getLength() - 1);
    }

    private final int[] preScanBackward(int start, int bound, StopCondition condition) throws BadLocationException {
        IntArrayList list = new IntArrayList();
        int scanEnd = start + 1;
        while (list.isEmpty() && this.line >= 0) {
            int lineOffset = this.document.getLineOffset(this.line);
            int next = lineOffset - 1;
            while ((next = this.scanForward(next + 1, scanEnd, condition)) != -1) {
                if (bound >= next) continue;
                list.add(next);
            }
            --this.line;
            if (lineOffset <= bound) break;
            scanEnd = lineOffset;
        }
        if (!list.isEmpty()) {
            return list.toArray();
        }
        return null;
    }

    protected final int scanForward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = this.document.getLength();
        }
        assert (bound <= this.document.getLength());
        assert (start >= 0);
        try {
            this.pos = start;
            while (this.pos < bound) {
                this.ch = this.document.getChar(this.pos);
                if (condition.stop()) {
                    return this.pos;
                }
                this.pos = condition.nextPositionForward();
            }
            this.pos = bound;
            this.ch = (char)(this.pos >= 0 && this.pos < this.document.getLength() ? (int)this.document.getChar(this.pos) : 65535);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    public final int scanForward(int position, int bound, char ch) {
        return this.scanForward(position, bound, new SingleCharacterMatchCondition(ch));
    }

    public final int scanForward(int position, int bound, char[] chars) {
        return this.scanForward(position, bound, new CharacterMatchCondition(chars));
    }

    public final int scanForward(int position, int bound, String s, char escapeChar) {
        if (bound == -2) {
            bound = this.document.getLength();
        }
        return this.scanForward(position, bound -= s.length(), new StringMatchCondition(s, escapeChar));
    }

    protected final int scanBackward(int start, int bound, StopCondition condition) {
        if (bound == -2) {
            bound = -1;
        }
        assert (bound >= -1);
        try {
            if (this.document.getLength() > 0) {
                this.pos = start;
                while (this.pos > bound) {
                    this.ch = this.document.getChar(this.pos);
                    if (condition.stop()) {
                        return this.pos;
                    }
                    this.pos = condition.nextPositionBackward();
                }
            }
            this.pos = bound;
            this.ch = (char)(this.pos >= 0 && this.pos < this.document.getLength() ? (int)this.document.getChar(this.pos) : 65535);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    public final int scanBackward(int position, int bound, char ch) {
        return this.scanBackward(position, bound, new SingleCharacterMatchCondition(ch));
    }

    public final int scanBackward(int position, int bound, char[] chars) {
        return this.scanBackward(position, bound, new CharacterMatchCondition(chars));
    }

    public final int count(int start, int stop, char c) {
        int count = 0;
        SingleCharacterMatchCondition condition = new SingleCharacterMatchCondition(c);
        while (start < stop && (start = this.scanForward(start, stop, condition)) != -1) {
            ++count;
            ++start;
        }
        return count;
    }

    protected final IRegion findRegion(int position, StopCondition condition) {
        return this.findRegion(position, condition, false);
    }

    protected final IRegion findRegion(int position, StopCondition condition, boolean allowClosing) {
        int start = position;
        int end = this.scanForward(position, -2, condition);
        if (end == -1) {
            end = this.pos;
        }
        if (allowClosing || end > position) {
            --start;
            if ((start = this.scanBackward(start, -2, condition)) == -1) {
                start = this.pos;
            }
            ++start;
        }
        if (start < end) {
            return new Region(start, end - start);
        }
        return null;
    }

    protected final String getContentType() {
        try {
            return TextUtilities.getContentType((IDocument)this.document, (String)this.partitioning, (int)this.pos, (boolean)false);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    protected final ITypedRegion getPartition() {
        try {
            return TextUtilities.getPartition((IDocument)this.document, (String)this.partitioning, (int)this.pos, (boolean)false);
        }
        catch (BadLocationException e) {
            return new TypedRegion(this.pos, 0, "__no_partition_at_all");
        }
    }

    public final ITypedRegion getPartition(int position) {
        try {
            return TextUtilities.getPartition((IDocument)this.document, (String)this.partitioning, (int)position, (boolean)false);
        }
        catch (BadLocationException e) {
            return new TypedRegion(this.pos, 0, "__no_partition_at_all");
        }
    }

    protected class CharacterMatchCondition
    extends PartitionBasedCondition {
        protected final char[] fChars;

        public CharacterMatchCondition(char[] chars) {
            assert (chars != null);
            this.fChars = chars;
        }

        @Override
        protected boolean matchesChar() {
            int i = 0;
            while (i < this.fChars.length) {
                if (this.fChars[i] == BasicHeuristicTokenScanner.this.ch) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    protected class ExtCharacterMatchCondition
    extends CharacterMatchCondition {
        private final char fEscapeChar;
        private int fLastEscapeOffset;

        ExtCharacterMatchCondition(char[] chars, char escapeChar) {
            super(chars);
            this.fLastEscapeOffset = -100;
            this.fEscapeChar = escapeChar;
        }

        @Override
        protected boolean matchesChar() {
            if (BasicHeuristicTokenScanner.this.pos == this.fLastEscapeOffset + 1) {
                return false;
            }
            if (BasicHeuristicTokenScanner.this.ch == this.fEscapeChar) {
                this.fLastEscapeOffset = BasicHeuristicTokenScanner.this.pos;
                return false;
            }
            return super.matchesChar();
        }
    }

    protected abstract class PartitionBasedCondition
    extends StopCondition {
        private ITypedRegion currentPartition;
        private boolean currentPartitionMatched;
        private int currentPartitionStart;
        private int currentPartitionEnd;

        public PartitionBasedCondition() {
            this.currentPartitionMatched = false;
        }

        @Override
        public boolean stop() {
            if (this.currentPartitionMatched && this.currentPartitionStart <= BasicHeuristicTokenScanner.this.pos && BasicHeuristicTokenScanner.this.pos < this.currentPartitionEnd) {
                return this.matchesChar();
            }
            this.currentPartition = BasicHeuristicTokenScanner.this.getPartition();
            this.currentPartitionStart = this.currentPartition.getOffset();
            this.currentPartitionEnd = this.currentPartitionStart + this.currentPartition.getLength();
            if (BasicHeuristicTokenScanner.this.partitionConstraint.matches(this.currentPartition.getType())) {
                this.currentPartitionMatched = true;
                return this.matchesChar();
            }
            this.currentPartitionMatched = false;
            return false;
        }

        protected abstract boolean matchesChar();

        @Override
        public int nextPositionForward() {
            if (this.currentPartitionMatched) {
                return BasicHeuristicTokenScanner.this.pos + 1;
            }
            if (BasicHeuristicTokenScanner.this.pos < this.currentPartitionEnd) {
                return this.currentPartitionEnd;
            }
            return BasicHeuristicTokenScanner.this.pos + 1;
        }

        @Override
        public int nextPositionBackward() {
            if (this.currentPartitionMatched) {
                return BasicHeuristicTokenScanner.this.pos - 1;
            }
            if (BasicHeuristicTokenScanner.this.pos >= this.currentPartitionStart) {
                return this.currentPartitionStart - 1;
            }
            return BasicHeuristicTokenScanner.this.pos - 1;
        }
    }

    protected class SingleCharacterMatchCondition
    extends PartitionBasedCondition {
        protected final int singleChar;

        public SingleCharacterMatchCondition(char ch) {
            this.singleChar = ch;
        }

        @Override
        protected boolean matchesChar() {
            return this.singleChar == BasicHeuristicTokenScanner.this.ch;
        }
    }

    protected abstract class StopCondition {
        protected StopCondition() {
        }

        public abstract boolean stop();

        public int nextPositionForward() {
            return BasicHeuristicTokenScanner.this.pos + 1;
        }

        public int nextPositionBackward() {
            return BasicHeuristicTokenScanner.this.pos - 1;
        }
    }

    protected class StringMatchCondition
    extends PartitionBasedCondition {
        protected final String fString;
        private final char fEscapeChar;
        private int fLastEscapeOffset = -100;

        public StringMatchCondition(String s, char escapeChar) {
            this.fString = s;
            this.fEscapeChar = escapeChar;
        }

        @Override
        protected boolean matchesChar() {
            if (BasicHeuristicTokenScanner.this.pos == this.fLastEscapeOffset + 1) {
                return false;
            }
            if (this.fString.charAt(0) == BasicHeuristicTokenScanner.this.ch) {
                try {
                    if (this.fString.regionMatches(1, BasicHeuristicTokenScanner.this.document.get(BasicHeuristicTokenScanner.this.pos + 1, this.fString.length() - 1), 0, this.fString.length() - 1)) {
                        return true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (this.fEscapeChar == BasicHeuristicTokenScanner.this.ch) {
                this.fLastEscapeOffset = BasicHeuristicTokenScanner.this.pos;
                return false;
            }
            return false;
        }
    }
}

