/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.rmi;

import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.rmi.RMIAddress;

@NonNullByDefault
public class RMIRegistry {
    private final RMIAddress address;
    private final Registry registry;

    public RMIRegistry(RMIAddress address, Registry registry, boolean validate) throws RemoteException {
        if (address.getName().length() > 0) {
            throw new IllegalArgumentException();
        }
        this.address = address;
        this.registry = ObjectUtils.nonNullAssert(registry);
        if (validate) {
            this.registry.list();
        }
    }

    public RMIRegistry(RMIAddress address, boolean validate) throws RemoteException {
        if (address.getName().length() > 0) {
            throw new IllegalArgumentException();
        }
        this.address = address;
        this.registry = LocateRegistry.getRegistry(address.getHost(), address.getPort().get(), address.isSsl() ? new SslRMIClientSocketFactory() : null);
        if (validate) {
            this.registry.list();
        }
    }

    public RMIAddress getAddress() {
        return this.address;
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

