/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class AbstractProcess
extends PlatformObject
implements IProcess {
    private final ILaunch launch;
    private final String name;
    private volatile @Nullable Map<String, String> attributes;
    private int exitValue;

    public AbstractProcess(ILaunch launch, String label) {
        this.launch = launch;
        this.name = label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getLabel() {
        return this.name;
    }

    public @Nullable IStreamsProxy getStreamsProxy() {
        return null;
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireEvents(DebugEvent[] events) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, String> getAttributes() {
        Map<String, String> map = this.attributes;
        if (map == null) {
            AbstractProcess abstractProcess = this;
            synchronized (abstractProcess) {
                map = this.attributes;
                if (map == null) {
                    this.attributes = map = new HashMap<String, String>();
                }
            }
        }
        return map;
    }

    protected final @Nullable Map<String, String> getAttributesIfPresent() {
        return this.attributes;
    }

    protected final @Nullable DebugEvent doSet(Map<String, String> map, String key, @Nullable String value) {
        String oldValue = map.put(key, value);
        if (Objects.equals(oldValue, value)) {
            return null;
        }
        DebugEvent event = new DebugEvent((Object)this, 16);
        event.setData((Object)new String[]{key, oldValue, value});
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, @Nullable String value) {
        DebugEvent event;
        Map<String, String> attributes;
        Map<String, String> map = attributes = this.getAttributes();
        synchronized (map) {
            event = this.doSet(attributes, key, value);
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable String getAttribute(String key) {
        Map<String, String> attributes = this.getAttributesIfPresent();
        if (attributes != null) {
            Map<String, String> map = attributes;
            synchronized (map) {
                return attributes.get(key);
            }
        }
        return null;
    }

    protected void created() {
        this.getLaunch().addProcess((IProcess)this);
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void terminated() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void doSetExitValue(int value) {
        this.exitValue = value;
    }

    protected int doGetExitValue() {
        return this.exitValue;
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", 5010, "Exit value is not available until process is terminated.", null));
        }
        return this.doGetExitValue();
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == IProcess.class) {
            return (T)((Object)this);
        }
        if (adapterType == ILaunch.class) {
            return (T)this.getLaunch();
        }
        if (adapterType == IDebugTarget.class) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (((Object)((Object)this)).equals(targets[i].getProcess())) {
                    return (T)targets[i];
                }
                ++i;
            }
            return null;
        }
        return (T)super.getAdapter(adapterType);
    }
}

