/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.debug.core.sourcelookup;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.sourcelookup.Messages;

public class RLibrarySourceContainer
extends AbstractSourceContainer {
    public static final String TYPE_ID = "org.eclipse.statet.r.debugSourceContainers.RLibraryType";
    private final String location;
    private final Path locationPath;

    private static Path resolve(String path) {
        if (path != null) {
            try {
                IFileStore store = FileUtil.expandToLocalFileStore((String)path, null, null);
                if (store != null) {
                    return Paths.get(store.toURI());
                }
            }
            catch (Exception e) {
                RDebugCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.r.core", 0, NLS.bind((String)"Could not resolve configured R library path ''{0}}'' of a source lookup entry.", (Object)path), (Throwable)e));
            }
        }
        return null;
    }

    public RLibrarySourceContainer(String locationPath) {
        this(locationPath, RLibrarySourceContainer.resolve(locationPath));
    }

    public RLibrarySourceContainer(String locationPath, Path locationStore) {
        if (locationPath == null) {
            throw new NullPointerException("location");
        }
        this.location = locationPath;
        this.locationPath = locationStore;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public String getName() {
        String s = this.location.toString();
        if (this.locationPath == null) {
            return String.valueOf(s) + Messages.RLibrarySourceContainer_name_UnresolvablePath_message;
        }
        return s;
    }

    public String getLocation() {
        return this.location;
    }

    public Path getLocationPath() {
        return this.locationPath;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        return null;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RLibrarySourceContainer && this.location.equals(((RLibrarySourceContainer)((Object)obj)).location);
    }
}

