/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.Objects;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
abstract class InlineWithText
extends Inline {
    protected final String text;

    public InlineWithText(Line line, int offset, int length, int cursorLength, String text) {
        super(line, offset, length, cursorLength);
        this.text = (String)ObjectUtils.nonNullAssert((Object)text);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getStartOffset(), this.getLength(), this.text);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            InlineWithText other = (InlineWithText)obj;
            return this.text.equals(other.text);
        }
        return false;
    }

    @Override
    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(this.getClass(), this.getClass());
        sb.addProp("startOffset", this.getStartOffset());
        sb.addProp("length", this.getLength());
        sb.addProp("text", this.getText());
        return sb.build();
    }
}

