/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceHeadingAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ParagraphBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class SetextHeaderOrParagraphBlock
extends ParagraphBlock {
    private static final Pattern UNDERLINE_PATTERN = Pattern.compile("(=+|-+)[ \t]*", 32);
    private static final int UNDERLINE_GROUP = 1;
    private final Matcher setextMatcher = UNDERLINE_PATTERN.matcher("");

    public SetextHeaderOrParagraphBlock() {
    }

    public SetextHeaderOrParagraphBlock(Collection<Class<? extends SourceBlock>> interruptExclusions) {
        super(interruptExclusions);
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        Line line;
        SetextHeaderOrParagraphBlockItem typedBlockItem = new SetextHeaderOrParagraphBlockItem(this, builder);
        lineSequence.advance();
        while ((line = lineSequence.getCurrentLine()) != null && !line.isBlank()) {
            Matcher setextMatcher;
            if (!line.isLazy() && line.getIndent() < 4 && (setextMatcher = line.setupIndent(this.setextMatcher)).matches()) {
                typedBlockItem.headingLevel = this.headingLevel(setextMatcher, line);
                lineSequence.advance();
                break;
            }
            if (this.isAnotherBlockStart(lineSequence, builder.getSourceBlocks(), typedBlockItem)) break;
            lineSequence.advance();
        }
    }

    private byte headingLevel(Matcher matcher, Line line) {
        switch (line.getText().charAt(matcher.start(1))) {
            case '=': {
                return 1;
            }
            case '-': {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void initializeContext(ProcessingContext context, SourceBlockItem<?> blockItem) {
        SetextHeaderOrParagraphBlockItem typedBlockItem = (SetextHeaderOrParagraphBlockItem)blockItem;
        if (typedBlockItem.headingLevel > 0) {
            return;
        }
        super.initializeContext(context, typedBlockItem);
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        SetextHeaderOrParagraphBlockItem typedBlockItem = (SetextHeaderOrParagraphBlockItem)blockItem;
        if (typedBlockItem.headingLevel > 0) {
            this.emitHeading(context, typedBlockItem, locator, builder);
        } else {
            this.emit(context, blockItem, true, locator, builder);
        }
    }

    private void emitHeading(ProcessingContext context, SetextHeaderOrParagraphBlockItem blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        ImList<Line> lines = blockItem.getLines();
        TextSegment textSegment = new TextSegment((ImList<Line>)lines.subList(0, lines.size() - 1));
        SourceHeadingAttributes attributes = new SourceHeadingAttributes(0);
        InlineParser inlineParser = context.getInlineParser();
        String headingText = inlineParser.toStringContent(context, textSegment);
        attributes.setId(context.generateHeadingId(blockItem.headingLevel, headingText));
        locator.setBlockBegin(blockItem);
        builder.beginHeading((int)blockItem.headingLevel, (Attributes)attributes);
        inlineParser.emit(context, textSegment, locator, builder);
        locator.setBlockEnd(blockItem);
        builder.endHeading();
    }

    private static class SetextHeaderOrParagraphBlockItem
    extends ParagraphBlock.ParagraphSourceBlockItem<SetextHeaderOrParagraphBlock> {
        private byte headingLevel;

        public SetextHeaderOrParagraphBlockItem(SetextHeaderOrParagraphBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }

        @Override
        public boolean isParagraph() {
            return this.headingLevel == 0;
        }
    }
}

