/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sphinx.emf.check.ui.internal.Activator;
import org.eclipse.sphinx.emf.check.ui.internal.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class CheckValidationOptionsSelectionDialog
extends ListSelectionDialog {
    private static final String SECTION_CATEGORY_SELECTION_DIALOG = "CheckValidationOptionsSelectionDialog";
    private static final String ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS = "EnableIntrinsicModelIntegrityConstraints";

    public CheckValidationOptionsSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        super(parentShell, input, contentProvider, labelProvider, message);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        Button button = new Button((Composite)control, 32);
        button.setText(Messages.text_enable_intrinsic_constraints);
        button.setSelection(this.getSelectionFromSettings().booleanValue());
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                CheckValidationOptionsSelectionDialog.this.setSelectionToSettings(source.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.getViewer().setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return super.compare(viewer, e1, e2);
            }
        });
        return control;
    }

    public boolean enableIntrinsicModelIntegrityConstraints() {
        return this.getSelectionFromSettings();
    }

    protected Boolean getSelectionFromSettings() {
        IDialogSettings section = this.getDialogSettings().getSection(SECTION_CATEGORY_SELECTION_DIALOG);
        if (section != null) {
            return section.getBoolean(ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS);
        }
        return false;
    }

    protected void setSelectionToSettings(boolean selected) {
        IDialogSettings section = this.getDialogSettings().getSection(SECTION_CATEGORY_SELECTION_DIALOG);
        if (section == null) {
            section = this.getDialogSettings().addNewSection(SECTION_CATEGORY_SELECTION_DIALOG);
        }
        section.put(ENABLE_INTRINSIC_MODEL_INTEGRITY_CONSTRAINTS, selected);
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }
}

