/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.services;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.check.internal.messages.Messages;
import org.eclipse.sphinx.emf.check.services.ICheckValidationProblemMarkerFactory;
import org.eclipse.sphinx.emf.check.util.DiagnosticLocation;
import org.eclipse.sphinx.emf.check.util.SourceLocation;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;

public class CheckProblemMarkerFactory
implements ICheckValidationProblemMarkerFactory {
    @Override
    public void createMarker(IResource resource, Diagnostic diagnostic) throws CoreException {
        this.createMarker(resource, diagnostic, "org.eclipse.sphinx.emf.check.checkvalidationproblemmarker");
    }

    @Override
    public void createMarker(IResource resource, Diagnostic diagnostic, String markerType) throws CoreException {
        int severity;
        DiagnosticLocation affectedLocation;
        IMarker marker = resource.createMarker(markerType);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        EObject affectedObject = this.getAffectedObject(diagnostic);
        if (affectedObject != null) {
            attributes.put("uri", EcoreResourceUtil.getURI((EObject)affectedObject).toString());
        }
        if ((affectedLocation = this.getAffectedLocation(diagnostic)) != null) {
            String value = String.valueOf(affectedLocation.getObject().eClass().getName()) + "#" + affectedLocation.getFeature().getName();
            if (affectedLocation.getIndex() != -1) {
                value = value.concat("." + affectedLocation.getIndex());
            }
            attributes.put("location", value);
        }
        int markerSeverity = (severity = diagnostic.getSeverity()) < 2 ? 0 : (severity < 4 ? 1 : 2);
        attributes.put("severity", markerSeverity);
        String message = diagnostic.getMessage();
        if (message == null) {
            message = Messages.noMessageAvailableForThisMarker;
        }
        attributes.put("message", message);
        attributes.put("sourceId", this.getSource(diagnostic));
        marker.setAttributes(attributes);
    }

    protected EObject getAffectedObject(Diagnostic diagnostic) {
        DiagnosticLocation affectedLocation = this.getAffectedLocation(diagnostic);
        if (affectedLocation != null) {
            return affectedLocation.getObject();
        }
        List data = diagnostic.getData();
        Object item = data.get(0);
        if (item instanceof EObject) {
            return (EObject)item;
        }
        return null;
    }

    protected DiagnosticLocation getAffectedLocation(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        for (Object obj : data) {
            if (!(obj instanceof DiagnosticLocation)) continue;
            return (DiagnosticLocation)obj;
        }
        return null;
    }

    protected String getSource(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        for (Object obj : data) {
            if (!(obj instanceof SourceLocation)) continue;
            SourceLocation sourceLocation = (SourceLocation)obj;
            if (sourceLocation.getConstraintId() != null && !sourceLocation.getConstraintId().isEmpty()) {
                return sourceLocation.getConstraintId();
            }
            StringBuilder sourceBuilder = new StringBuilder();
            sourceBuilder.append(sourceLocation.getCheckValidator().getSimpleName());
            sourceBuilder.append("#");
            sourceBuilder.append(sourceLocation.getCheckMethod().getName());
            return sourceBuilder.toString();
        }
        return diagnostic.getSource();
    }

    @Override
    public void deleteMarkers(Resource resource) throws CoreException {
        this.deleteMarkers(resource, "org.eclipse.sphinx.emf.check.checkvalidationproblemmarker");
    }

    @Override
    public void deleteMarkers(Resource resource, String markerType) throws CoreException {
        IMarker[] markers;
        IFile file = EcorePlatformUtil.getFile((Resource)resource);
        if (file == null || !file.exists()) {
            return;
        }
        IMarker[] iMarkerArray = markers = file.findMarkers(markerType, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }
}

