/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.viewer.content;

import org.eclipse.compare.IResourceProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.TypedElementWrapper;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabFolder;
import org.eclipse.emf.compare.ui.viewer.content.part.diff.ModelContentMergeDiffTab;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.viewer.content.ModelElementContentMergeTabFolder;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Composite;

public class ModelElementContentMergeDiffTab
extends ModelContentMergeDiffTab {
    public ModelElementContentMergeDiffTab(Composite parentComposite, int side, ModelContentMergeTabFolder parentFolder) {
        super(parentComposite, side, parentFolder);
        if (this.parent instanceof ModelElementContentMergeTabFolder) {
            final ModelElementContentMergeTabFolder tabFolder = (ModelElementContentMergeTabFolder)this.parent;
            this.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (!(element instanceof EObject)) {
                        return false;
                    }
                    Object input = tabFolder.getContentMergeViewer().getInput();
                    if (input instanceof ModelCompareInput) {
                        ModelCompareInput mcInput = (ModelCompareInput)input;
                        Object typedElement = null;
                        switch (ModelElementContentMergeDiffTab.this.partSide) {
                            case 1: {
                                Object leftFromMatch = ModelElementContentMergeDiffTab.this.getLeftFromMatch(mcInput);
                                if (leftFromMatch != null) {
                                    typedElement = leftFromMatch;
                                    break;
                                }
                                Object leftFromDiff = ModelElementContentMergeDiffTab.this.getLeftFromDiff(mcInput);
                                if (leftFromDiff != null) {
                                    typedElement = leftFromDiff;
                                    break;
                                }
                                typedElement = mcInput.getLeft();
                                break;
                            }
                            case 2: {
                                Object rightFromMatch = ModelElementContentMergeDiffTab.this.getRightFromMatch(mcInput);
                                if (rightFromMatch != null) {
                                    typedElement = rightFromMatch;
                                    break;
                                }
                                Object rightFromDiff = ModelElementContentMergeDiffTab.this.getRightFromDiff(mcInput);
                                if (rightFromDiff != null) {
                                    typedElement = rightFromDiff;
                                    break;
                                }
                                typedElement = mcInput.getRight();
                                break;
                            }
                            case 3: {
                                Object ancestorFromDiff;
                                Object ancestorFromMatch = ModelElementContentMergeDiffTab.this.getAncestorFromMatch(mcInput);
                                typedElement = ancestorFromMatch != null ? ancestorFromMatch : ((ancestorFromDiff = ModelElementContentMergeDiffTab.this.getAncestorFromDiff(mcInput)) != null ? ancestorFromDiff : mcInput.getAncestor());
                            }
                        }
                        if (typedElement instanceof EObject) {
                            EObject obj = (EObject)typedElement;
                            return EcoreUtil.isAncestor((EObject)obj, (EObject)((EObject)element));
                        }
                        if (typedElement instanceof TypedElementWrapper) {
                            EObject inputObject = ((TypedElementWrapper)typedElement).getObject();
                            return EcoreUtil.isAncestor((EObject)inputObject, (EObject)((EObject)element));
                        }
                        if (typedElement instanceof IResourceProvider) {
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
    }

    public void setReflectiveInput(Object input) {
        this.clearCaches();
        AdapterFactory adapterFactory = AdapterUtils.getAdapterFactory();
        this.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory));
        if (input instanceof EObject) {
            EObject eContainer = ((EObject)input).eContainer();
            if (eContainer != null) {
                this.setInput(eContainer);
            } else {
                this.setInput(((EObject)input).eResource());
            }
        } else if (input instanceof IResourceProvider) {
            IFile resource = (IFile)((IResourceProvider)input).getResource();
            this.setInput(EcorePlatformUtil.getResource((IFile)resource));
        }
        try {
            this.setupCaches();
        }
        catch (RuntimeException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new RuntimeException("Caches initialization failed.", ex));
        }
        this.needsRedraw = true;
    }

    protected Object getLeftFromMatch(ModelCompareInput input) {
        MatchModel matchModel;
        Object match = input.getMatch();
        if (match instanceof MatchModel && (matchModel = (MatchModel)match).getLeftRoots() != null && !matchModel.getLeftRoots().isEmpty()) {
            return matchModel.getLeftRoots().get(0);
        }
        return null;
    }

    protected Object getLeftFromDiff(ModelCompareInput input) {
        DiffModel diffModel;
        Object diff = input.getDiff();
        if (diff instanceof DiffModel && (diffModel = (DiffModel)diff).getLeftRoots() != null && !diffModel.getLeftRoots().isEmpty()) {
            return diffModel.getLeftRoots().get(0);
        }
        return null;
    }

    protected Object getRightFromMatch(ModelCompareInput input) {
        MatchModel matchModel;
        Object match = input.getMatch();
        if (match instanceof MatchModel && (matchModel = (MatchModel)match).getRightRoots() != null && !matchModel.getRightRoots().isEmpty()) {
            return matchModel.getRightRoots().get(0);
        }
        return null;
    }

    protected Object getRightFromDiff(ModelCompareInput input) {
        DiffModel diffModel;
        Object diff = input.getDiff();
        if (diff instanceof DiffModel && (diffModel = (DiffModel)diff).getRightRoots() != null && !diffModel.getRightRoots().isEmpty()) {
            return diffModel.getRightRoots().get(0);
        }
        return null;
    }

    protected Object getAncestorFromMatch(ModelCompareInput input) {
        MatchModel matchModel;
        Object match = input.getMatch();
        if (match instanceof MatchModel && (matchModel = (MatchModel)match).getAncestorRoots() != null && !matchModel.getAncestorRoots().isEmpty()) {
            return matchModel.getAncestorRoots().get(0);
        }
        return null;
    }

    protected Object getAncestorFromDiff(ModelCompareInput input) {
        DiffModel diffModel;
        Object diff = input.getDiff();
        if (diff instanceof DiffModel && (diffModel = (DiffModel)diff).getAncestorRoots() != null && !diffModel.getAncestorRoots().isEmpty()) {
            return diffModel.getAncestorRoots().get(0);
        }
        return null;
    }
}

