/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.toolcontrol;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.set.application.Messages;
import org.eclipse.set.application.toolcontrol.ServiceProvider;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class LoadedFileStatusControl {
    private final MApplication application;
    private final DialogService dialogService;
    private final Messages msg;
    private final Shell shell;
    private final Button iconButton;
    private Image invalidIconImage;
    private Image incompleteIconImage;
    private static final String INVALID_ICON_URI = "platform:/plugin/org.eclipse.set.utils/icons/warning_red_transparent.png";
    private static final String INCOMPLETE_ICON_URI = "platform:/plugin/org.eclipse.set.utils/icons/warning_yellow_transparent.png";

    public LoadedFileStatusControl(Composite parent, ServiceProvider provider, Shell shell) {
        this.application = provider.application;
        this.dialogService = provider.dialogService;
        this.msg = provider.messages;
        this.shell = shell;
        this.invalidIconImage = LoadedFileStatusControl.loadImage(INVALID_ICON_URI);
        this.incompleteIconImage = LoadedFileStatusControl.loadImage(INCOMPLETE_ICON_URI);
        this.iconButton = new Button(parent, 8);
        this.iconButton.setVisible(false);
        this.iconButton.addSelectionListener(this.onButtonClick());
        this.application.getContext().runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                IModelSession session = (IModelSession)context.get(IModelSession.class);
                if (session != null && LoadedFileStatusControl.this.incompleteIconImage != null && LoadedFileStatusControl.this.invalidIconImage != null) {
                    switch (session.getFileValidateState()) {
                        case INCOMPLETE: {
                            LoadedFileStatusControl.this.iconButton.setImage(LoadedFileStatusControl.this.incompleteIconImage);
                            LoadedFileStatusControl.this.iconButton.setVisible(true);
                            break;
                        }
                        case INVALID: {
                            LoadedFileStatusControl.this.iconButton.setImage(LoadedFileStatusControl.this.invalidIconImage);
                            LoadedFileStatusControl.this.iconButton.setVisible(true);
                            break;
                        }
                        default: {
                            LoadedFileStatusControl.this.iconButton.setImage(null);
                            LoadedFileStatusControl.this.iconButton.setVisible(false);
                            break;
                        }
                    }
                } else {
                    LoadedFileStatusControl.this.iconButton.setImage(null);
                    LoadedFileStatusControl.this.iconButton.setVisible(false);
                }
                return true;
            }
        });
        provider.broker.subscribe("modelsession/close", event -> {
            this.iconButton.setImage(null);
            this.iconButton.setVisible(false);
        });
    }

    private SelectionListener onButtonClick() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IModelSession session = (IModelSession)LoadedFileStatusControl.this.application.getContext().get(IModelSession.class);
                if (session == null) {
                    return;
                }
                switch (session.getFileValidateState()) {
                    case INCOMPLETE: {
                        LoadedFileStatusControl.this.dialogService.loadIncompleteModel(LoadedFileStatusControl.this.shell, LoadedFileStatusControl.this.msg.IncompleteFileDialog_Title, LoadedFileStatusControl.this.msg.IncompleteFileDialog_Message, new String[]{JFaceResources.getString((String)"ok")});
                        break;
                    }
                    case INVALID: {
                        LoadedFileStatusControl.this.dialogService.loadInvalidModel(LoadedFileStatusControl.this.shell, LoadedFileStatusControl.this.msg.InvalidFileDialog_Title, LoadedFileStatusControl.this.msg.InvalidFileDialog_Message, new String[]{JFaceResources.getString((String)"ok")});
                        break;
                    }
                }
            }
        };
    }

    private static Image loadImage(String uri) {
        try {
            return ImageDescriptor.createFromURL((URL)new URI(uri).toURL()).createImage();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }
}

