/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Lageplan_Lang_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_Strecke_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Strecke_Km_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.Bezeichnung_Strecke_TypeClass;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.Strecke_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.LST_Objekte_Planungsbereich_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.Planung_Einzel;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.model.planpro.Verweise.ID_Strecke_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Ur_Objekt_TypeClass;
import org.eclipse.set.model.siteplan.Coordinate;
import org.eclipse.set.model.siteplan.Label;
import org.eclipse.set.model.siteplan.ObjectManagement;
import org.eclipse.set.model.siteplan.RouteLocation;
import org.eclipse.set.model.siteplan.RouteObject;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TransformUtils {
    private static final String UNKNOWN_ROUTE = "Unbekannte Strecke";
    public static List<Thread> transformThreads = CollectionLiterals.newLinkedList();

    public static Label getLabel(Bezeichnung_Element_AttributeGroup labelelement) {
        String labeltext;
        Bezeichnung_Lageplan_Lang_TypeClass _bezeichnungLageplanLang = null;
        if (labelelement != null) {
            _bezeichnungLageplanLang = labelelement.getBezeichnungLageplanLang();
        }
        String _wert = null;
        if (_bezeichnungLageplanLang != null) {
            _wert = _bezeichnungLageplanLang.getWert();
        }
        if ((labeltext = _wert) == null) {
            return null;
        }
        Label label = SiteplanFactory.eINSTANCE.createLabel();
        label.setText(labeltext);
        return label;
    }

    public static double distanceTo(Coordinate position, Coordinate position2) {
        double _x = position.getX();
        double _x_1 = position2.getX();
        double xdistance = _x - _x_1;
        double _y = position.getY();
        double _y_1 = position2.getY();
        double ydistance = _y - _y_1;
        return Math.sqrt(xdistance * xdistance + ydistance * ydistance);
    }

    public static void transformPunktObjektStrecke(Punkt_Objekt punktObjekt, RouteObject routeObject) {
        TransformUtils.transformPunktObjektStrecke((EList<Punkt_Objekt_Strecke_AttributeGroup>)punktObjekt.getPunktObjektStrecke(), routeObject);
    }

    public static void transformPunktObjektStrecke(EList<Punkt_Objekt_Strecke_AttributeGroup> punktObjektStrecke, RouteObject routeObject) {
        if (punktObjektStrecke == null) {
            return;
        }
        Functions.Function1 _function = it -> {
            RouteLocation location = SiteplanFactory.eINSTANCE.createRouteLocation();
            Strecke_Km_TypeClass _streckeKm = it.getStreckeKm();
            String _wert = null;
            if (_streckeKm != null) {
                _wert = _streckeKm.getWert();
            }
            location.setKm(_wert);
            String _elvis = null;
            ID_Strecke_TypeClass _iDStrecke = it.getIDStrecke();
            Strecke _value = null;
            if (_iDStrecke != null) {
                _value = _iDStrecke.getValue();
            }
            Strecke_Bezeichnung_AttributeGroup _bezeichnung = null;
            if (_value != null) {
                _bezeichnung = _value.getBezeichnung();
            }
            Bezeichnung_Strecke_TypeClass _bezeichnungStrecke = null;
            if (_bezeichnung != null) {
                _bezeichnungStrecke = _bezeichnung.getBezeichnungStrecke();
            }
            String _wert_1 = null;
            if (_bezeichnungStrecke != null) {
                _wert_1 = _bezeichnungStrecke.getWert();
            }
            _elvis = _wert_1 != null ? _wert_1 : UNKNOWN_ROUTE;
            location.setRoute(_elvis);
            return location;
        };
        routeObject.getRouteLocations().addAll((Collection)ListExtensions.map(punktObjektStrecke, (Functions.Function1)_function));
    }

    public static void transformPlanningRegion(Siteplan siteplan, PlanPro_Schnittstelle schnittstelle) {
        Optional projects = PlanProSchnittstelleExtensions.getLSTPlanungGruppe((PlanPro_Schnittstelle)schnittstelle);
        boolean _isPresent = projects.isPresent();
        if (_isPresent) {
            Consumer<Planung_Gruppe> _function = it -> {
                ObjectManagement objectManagement = SiteplanFactory.eINSTANCE.createObjectManagement();
                Identitaet_TypeClass _identitaet = it.getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                objectManagement.setPlanningGroupID(_wert);
                Planung_Einzel _lSTPlanungEinzel = it.getLSTPlanungEinzel();
                LST_Objekte_Planungsbereich_AttributeGroup _lSTObjektePlanungsbereich = null;
                if (_lSTPlanungEinzel != null) {
                    _lSTObjektePlanungsbereich = _lSTPlanungEinzel.getLSTObjektePlanungsbereich();
                }
                EList _iDLSTObjektPlanungsbereich = null;
                if (_lSTObjektePlanungsbereich != null) {
                    _iDLSTObjektPlanungsbereich = _lSTObjektePlanungsbereich.getIDLSTObjektPlanungsbereich();
                }
                if (_iDLSTObjektPlanungsbereich != null) {
                    Consumer<ID_Ur_Objekt_TypeClass> _function_1 = it_1 -> {
                        boolean _not;
                        boolean _contains = objectManagement.getPlanningObjectIDs().contains((Object)it_1.getWert());
                        boolean bl = _not = !_contains;
                        if (_not) {
                            objectManagement.getPlanningObjectIDs().add((Object)it_1.getWert());
                        }
                    };
                    _iDLSTObjektPlanungsbereich.forEach(_function_1);
                }
                siteplan.getObjectManagement().add((Object)objectManagement);
            };
            ((Iterable)projects.get()).forEach(_function);
        }
    }

    public static <T> void createTransformatorThread(List<T> transformators, String threadName, int threadNumber, final Procedures.Procedure1<? super T> runFunction) {
        int transformatorsSize = transformators.size();
        LinkedList threadList = CollectionLiterals.newLinkedList();
        int i = 0;
        while (i < threadNumber) {
            final List<T> sublist = transformators.subList(i * transformatorsSize / threadNumber, (i + 1) * transformatorsSize / threadNumber);
            Thread thread = new Thread(threadName + "_" + String.valueOf((Object)i)){

                @Override
                public void run() {
                    int index = 0;
                    while (!Thread.interrupted() && index < sublist.size()) {
                        runFunction.apply(sublist.get(index));
                        ++index;
                    }
                }
            };
            transformThreads.add(thread);
            threadList.add(thread);
            thread.start();
            ++i;
        }
        Consumer<Thread> _function = it -> {
            try {
                if (it.isAlive() && !it.isInterrupted()) {
                    it.join();
                }
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        threadList.forEach(_function);
    }
}

