/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Ortung;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMFMA Element Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.model.model11001.Ortung.OrtungPackage#getENUMFMAElementArt()
 * @model extendedMetaData="name='ENUMFMA_Element_Art'"
 * @generated
 */
public enum ENUMFMAElementArt implements Enumerator {
	/**
	 * The '<em><b>ENUMFMA Element Art Anschlussseile</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_ANSCHLUSSSEILE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_ANSCHLUSSSEILE(0, "ENUMFMA_Element_Art_Anschlussseile", "Anschlussseile"),

	/**
	 * The '<em><b>ENUMFMA Element Art Drosselspule</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_DROSSELSPULE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_DROSSELSPULE(1, "ENUMFMA_Element_Art_Drosselspule", "Drosselspule"),

	/**
	 * The '<em><b>ENUMFMA Element Art Endverbinder</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_ENDVERBINDER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_ENDVERBINDER(2, "ENUMFMA_Element_Art_Endverbinder", "Endverbinder"),

	/**
	 * The '<em><b>ENUMFMA Element Art Endverbinder modifiziert</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_ENDVERBINDER_MODIFIZIERT_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_ENDVERBINDER_MODIFIZIERT(3, "ENUMFMA_Element_Art_Endverbinder_modifiziert", "Endverbinder_modifiziert"),

	/**
	 * The '<em><b>ENUMFMA Element Art Kurzschlussverbinder</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_KURZSCHLUSSVERBINDER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_KURZSCHLUSSVERBINDER(4, "ENUMFMA_Element_Art_Kurzschlussverbinder", "Kurzschlussverbinder"),

	/**
	 * The '<em><b>ENUMFMA Element Art Potentialausgleichsverbinder</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_POTENTIALAUSGLEICHSVERBINDER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_POTENTIALAUSGLEICHSVERBINDER(5, "ENUMFMA_Element_Art_Potentialausgleichsverbinder", "Potentialausgleichsverbinder"),

	/**
	 * The '<em><b>ENUMFMA Element Art sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_SONSTIGE(6, "ENUMFMA_Element_Art_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUMFMA Element Art SVerbinder</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_SVERBINDER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_SVERBINDER(7, "ENUMFMA_Element_Art_S_Verbinder", "S_Verbinder"),

	/**
	 * The '<em><b>ENUMFMA Element Art Ueberlagerungsverbinder</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_UEBERLAGERUNGSVERBINDER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMFMA_ELEMENT_ART_UEBERLAGERUNGSVERBINDER(8, "ENUMFMA_Element_Art_Ueberlagerungsverbinder", "Ueberlagerungsverbinder");

	/**
	 * The '<em><b>ENUMFMA Element Art Anschlussseile</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_ANSCHLUSSSEILE
	 * @model name="ENUMFMA_Element_Art_Anschlussseile" literal="Anschlussseile"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_ANSCHLUSSSEILE_VALUE = 0;

	/**
	 * The '<em><b>ENUMFMA Element Art Drosselspule</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_DROSSELSPULE
	 * @model name="ENUMFMA_Element_Art_Drosselspule" literal="Drosselspule"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_DROSSELSPULE_VALUE = 1;

	/**
	 * The '<em><b>ENUMFMA Element Art Endverbinder</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_ENDVERBINDER
	 * @model name="ENUMFMA_Element_Art_Endverbinder" literal="Endverbinder"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_ENDVERBINDER_VALUE = 2;

	/**
	 * The '<em><b>ENUMFMA Element Art Endverbinder modifiziert</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_ENDVERBINDER_MODIFIZIERT
	 * @model name="ENUMFMA_Element_Art_Endverbinder_modifiziert" literal="Endverbinder_modifiziert"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_ENDVERBINDER_MODIFIZIERT_VALUE = 3;

	/**
	 * The '<em><b>ENUMFMA Element Art Kurzschlussverbinder</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_KURZSCHLUSSVERBINDER
	 * @model name="ENUMFMA_Element_Art_Kurzschlussverbinder" literal="Kurzschlussverbinder"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_KURZSCHLUSSVERBINDER_VALUE = 4;

	/**
	 * The '<em><b>ENUMFMA Element Art Potentialausgleichsverbinder</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_POTENTIALAUSGLEICHSVERBINDER
	 * @model name="ENUMFMA_Element_Art_Potentialausgleichsverbinder" literal="Potentialausgleichsverbinder"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_POTENTIALAUSGLEICHSVERBINDER_VALUE = 5;

	/**
	 * The '<em><b>ENUMFMA Element Art sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_SONSTIGE
	 * @model name="ENUMFMA_Element_Art_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_SONSTIGE_VALUE = 6;

	/**
	 * The '<em><b>ENUMFMA Element Art SVerbinder</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_SVERBINDER
	 * @model name="ENUMFMA_Element_Art_S_Verbinder" literal="S_Verbinder"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_SVERBINDER_VALUE = 7;

	/**
	 * The '<em><b>ENUMFMA Element Art Ueberlagerungsverbinder</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMFMA_ELEMENT_ART_UEBERLAGERUNGSVERBINDER
	 * @model name="ENUMFMA_Element_Art_Ueberlagerungsverbinder" literal="Ueberlagerungsverbinder"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMFMA_ELEMENT_ART_UEBERLAGERUNGSVERBINDER_VALUE = 8;

	/**
	 * An array of all the '<em><b>ENUMFMA Element Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMFMAElementArt[] VALUES_ARRAY =
		new ENUMFMAElementArt[] {
			ENUMFMA_ELEMENT_ART_ANSCHLUSSSEILE,
			ENUMFMA_ELEMENT_ART_DROSSELSPULE,
			ENUMFMA_ELEMENT_ART_ENDVERBINDER,
			ENUMFMA_ELEMENT_ART_ENDVERBINDER_MODIFIZIERT,
			ENUMFMA_ELEMENT_ART_KURZSCHLUSSVERBINDER,
			ENUMFMA_ELEMENT_ART_POTENTIALAUSGLEICHSVERBINDER,
			ENUMFMA_ELEMENT_ART_SONSTIGE,
			ENUMFMA_ELEMENT_ART_SVERBINDER,
			ENUMFMA_ELEMENT_ART_UEBERLAGERUNGSVERBINDER,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMFMA Element Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMFMAElementArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMFMA Element Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMFMAElementArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMFMAElementArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMFMA Element Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMFMAElementArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMFMAElementArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMFMA Element Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMFMAElementArt get(int value) {
		switch (value) {
			case ENUMFMA_ELEMENT_ART_ANSCHLUSSSEILE_VALUE: return ENUMFMA_ELEMENT_ART_ANSCHLUSSSEILE;
			case ENUMFMA_ELEMENT_ART_DROSSELSPULE_VALUE: return ENUMFMA_ELEMENT_ART_DROSSELSPULE;
			case ENUMFMA_ELEMENT_ART_ENDVERBINDER_VALUE: return ENUMFMA_ELEMENT_ART_ENDVERBINDER;
			case ENUMFMA_ELEMENT_ART_ENDVERBINDER_MODIFIZIERT_VALUE: return ENUMFMA_ELEMENT_ART_ENDVERBINDER_MODIFIZIERT;
			case ENUMFMA_ELEMENT_ART_KURZSCHLUSSVERBINDER_VALUE: return ENUMFMA_ELEMENT_ART_KURZSCHLUSSVERBINDER;
			case ENUMFMA_ELEMENT_ART_POTENTIALAUSGLEICHSVERBINDER_VALUE: return ENUMFMA_ELEMENT_ART_POTENTIALAUSGLEICHSVERBINDER;
			case ENUMFMA_ELEMENT_ART_SONSTIGE_VALUE: return ENUMFMA_ELEMENT_ART_SONSTIGE;
			case ENUMFMA_ELEMENT_ART_SVERBINDER_VALUE: return ENUMFMA_ELEMENT_ART_SVERBINDER;
			case ENUMFMA_ELEMENT_ART_UEBERLAGERUNGSVERBINDER_VALUE: return ENUMFMA_ELEMENT_ART_UEBERLAGERUNGSVERBINDER;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMFMAElementArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMFMAElementArt
