/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Signale.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model11001.Signale.util.SignaleAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SignaleItemProviderAdapterFactory extends SignaleAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SignaleItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Anschaltdauer_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Anschaltdauer_TypeClassItemProvider anschaltdauer_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Anschaltdauer_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnschaltdauer_TypeClassAdapter() {
		if (anschaltdauer_TypeClassItemProvider == null) {
			anschaltdauer_TypeClassItemProvider = new Anschaltdauer_TypeClassItemProvider(this);
		}

		return anschaltdauer_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Auto_Einstellung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Auto_Einstellung_TypeClassItemProvider auto_Einstellung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Auto_Einstellung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuto_Einstellung_TypeClassAdapter() {
		if (auto_Einstellung_TypeClassItemProvider == null) {
			auto_Einstellung_TypeClassItemProvider = new Auto_Einstellung_TypeClassItemProvider(this);
		}

		return auto_Einstellung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Befestigung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Befestigung_Art_TypeClassItemProvider befestigung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Befestigung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBefestigung_Art_TypeClassAdapter() {
		if (befestigung_Art_TypeClassItemProvider == null) {
			befestigung_Art_TypeClassItemProvider = new Befestigung_Art_TypeClassItemProvider(this);
		}

		return befestigung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Beleuchtet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Beleuchtet_TypeClassItemProvider beleuchtet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Beleuchtet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBeleuchtet_TypeClassAdapter() {
		if (beleuchtet_TypeClassItemProvider == null) {
			beleuchtet_TypeClassItemProvider = new Beleuchtet_TypeClassItemProvider(this);
		}

		return beleuchtet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Besetzte_Ausfahrt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Besetzte_Ausfahrt_TypeClassItemProvider besetzte_Ausfahrt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Besetzte_Ausfahrt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBesetzte_Ausfahrt_TypeClassAdapter() {
		if (besetzte_Ausfahrt_TypeClassItemProvider == null) {
			besetzte_Ausfahrt_TypeClassItemProvider = new Besetzte_Ausfahrt_TypeClassItemProvider(this);
		}

		return besetzte_Ausfahrt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.DA_Manuell_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DA_Manuell_TypeClassItemProvider dA_Manuell_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.DA_Manuell_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDA_Manuell_TypeClassAdapter() {
		if (dA_Manuell_TypeClassItemProvider == null) {
			dA_Manuell_TypeClassItemProvider = new DA_Manuell_TypeClassItemProvider(this);
		}

		return dA_Manuell_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Dunkelschaltung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Dunkelschaltung_TypeClassItemProvider dunkelschaltung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Dunkelschaltung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDunkelschaltung_TypeClassAdapter() {
		if (dunkelschaltung_TypeClassItemProvider == null) {
			dunkelschaltung_TypeClassItemProvider = new Dunkelschaltung_TypeClassItemProvider(this);
		}

		return dunkelschaltung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Durchfahrt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Durchfahrt_TypeClassItemProvider durchfahrt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Durchfahrt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDurchfahrt_TypeClassAdapter() {
		if (durchfahrt_TypeClassItemProvider == null) {
			durchfahrt_TypeClassItemProvider = new Durchfahrt_TypeClassItemProvider(this);
		}

		return durchfahrt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Fiktives_Signal_Funktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fiktives_Signal_Funktion_TypeClassItemProvider fiktives_Signal_Funktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Fiktives_Signal_Funktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFiktives_Signal_Funktion_TypeClassAdapter() {
		if (fiktives_Signal_Funktion_TypeClassItemProvider == null) {
			fiktives_Signal_Funktion_TypeClassItemProvider = new Fiktives_Signal_Funktion_TypeClassItemProvider(this);
		}

		return fiktives_Signal_Funktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Fundament_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Fundament_Art_TypeClassItemProvider fundament_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Fundament_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFundament_Art_TypeClassAdapter() {
		if (fundament_Art_TypeClassItemProvider == null) {
			fundament_Art_TypeClassItemProvider = new Fundament_Art_TypeClassItemProvider(this);
		}

		return fundament_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Funktion_Ohne_Signal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Funktion_Ohne_Signal_TypeClassItemProvider funktion_Ohne_Signal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Funktion_Ohne_Signal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFunktion_Ohne_Signal_TypeClassAdapter() {
		if (funktion_Ohne_Signal_TypeClassItemProvider == null) {
			funktion_Ohne_Signal_TypeClassItemProvider = new Funktion_Ohne_Signal_TypeClassItemProvider(this);
		}

		return funktion_Ohne_Signal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Gegengleis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Gegengleis_TypeClassItemProvider gegengleis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Gegengleis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGegengleis_TypeClassAdapter() {
		if (gegengleis_TypeClassItemProvider == null) {
			gegengleis_TypeClassItemProvider = new Gegengleis_TypeClassItemProvider(this);
		}

		return gegengleis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Geltungsbereich_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Geltungsbereich_TypeClassItemProvider geltungsbereich_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Geltungsbereich_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeltungsbereich_TypeClassAdapter() {
		if (geltungsbereich_TypeClassItemProvider == null) {
			geltungsbereich_TypeClassItemProvider = new Geltungsbereich_TypeClassItemProvider(this);
		}

		return geltungsbereich_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Geschaltet_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Geschaltet_TypeClassItemProvider geschaltet_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Geschaltet_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeschaltet_TypeClassAdapter() {
		if (geschaltet_TypeClassItemProvider == null) {
			geschaltet_TypeClassItemProvider = new Geschaltet_TypeClassItemProvider(this);
		}

		return geschaltet_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Hoehe_Fundamentoberkante_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hoehe_Fundamentoberkante_TypeClassItemProvider hoehe_Fundamentoberkante_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Hoehe_Fundamentoberkante_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehe_Fundamentoberkante_TypeClassAdapter() {
		if (hoehe_Fundamentoberkante_TypeClassItemProvider == null) {
			hoehe_Fundamentoberkante_TypeClassItemProvider = new Hoehe_Fundamentoberkante_TypeClassItemProvider(this);
		}

		return hoehe_Fundamentoberkante_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Obere_Lichtpunkthoehe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Obere_Lichtpunkthoehe_TypeClassItemProvider obere_Lichtpunkthoehe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Obere_Lichtpunkthoehe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createObere_Lichtpunkthoehe_TypeClassAdapter() {
		if (obere_Lichtpunkthoehe_TypeClassItemProvider == null) {
			obere_Lichtpunkthoehe_TypeClassItemProvider = new Obere_Lichtpunkthoehe_TypeClassItemProvider(this);
		}

		return obere_Lichtpunkthoehe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.PZB_Schutzstrecke_Soll_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PZB_Schutzstrecke_Soll_TypeClassItemProvider pzB_Schutzstrecke_Soll_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.PZB_Schutzstrecke_Soll_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPZB_Schutzstrecke_Soll_TypeClassAdapter() {
		if (pzB_Schutzstrecke_Soll_TypeClassItemProvider == null) {
			pzB_Schutzstrecke_Soll_TypeClassItemProvider = new PZB_Schutzstrecke_Soll_TypeClassItemProvider(this);
		}

		return pzB_Schutzstrecke_Soll_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Rahmen_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rahmen_Art_TypeClassItemProvider rahmen_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Rahmen_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRahmen_Art_TypeClassAdapter() {
		if (rahmen_Art_TypeClassItemProvider == null) {
			rahmen_Art_TypeClassItemProvider = new Rahmen_Art_TypeClassItemProvider(this);
		}

		return rahmen_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Rahmen_Hoehe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rahmen_Hoehe_TypeClassItemProvider rahmen_Hoehe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Rahmen_Hoehe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRahmen_Hoehe_TypeClassAdapter() {
		if (rahmen_Hoehe_TypeClassItemProvider == null) {
			rahmen_Hoehe_TypeClassItemProvider = new Rahmen_Hoehe_TypeClassItemProvider(this);
		}

		return rahmen_Hoehe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Rangierstrasse_Restaufloesung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rangierstrasse_Restaufloesung_TypeClassItemProvider rangierstrasse_Restaufloesung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Rangierstrasse_Restaufloesung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRangierstrasse_Restaufloesung_TypeClassAdapter() {
		if (rangierstrasse_Restaufloesung_TypeClassItemProvider == null) {
			rangierstrasse_Restaufloesung_TypeClassItemProvider = new Rangierstrasse_Restaufloesung_TypeClassItemProvider(this);
		}

		return rangierstrasse_Restaufloesung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Richtpunkt_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Richtpunkt_TypeClassItemProvider richtpunkt_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Richtpunkt_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRichtpunkt_TypeClassAdapter() {
		if (richtpunkt_TypeClassItemProvider == null) {
			richtpunkt_TypeClassItemProvider = new Richtpunkt_TypeClassItemProvider(this);
		}

		return richtpunkt_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Richtpunktentfernung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Richtpunktentfernung_TypeClassItemProvider richtpunktentfernung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Richtpunktentfernung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRichtpunktentfernung_TypeClassAdapter() {
		if (richtpunktentfernung_TypeClassItemProvider == null) {
			richtpunktentfernung_TypeClassItemProvider = new Richtpunktentfernung_TypeClassItemProvider(this);
		}

		return richtpunktentfernung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SignalItemProvider signalItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalAdapter() {
		if (signalItemProvider == null) {
			signalItemProvider = new SignalItemProvider(this);
		}

		return signalItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Art_TypeClassItemProvider signal_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Art_TypeClassAdapter() {
		if (signal_Art_TypeClassItemProvider == null) {
			signal_Art_TypeClassItemProvider = new Signal_Art_TypeClassItemProvider(this);
		}

		return signal_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Befestigung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_BefestigungItemProvider signal_BefestigungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Befestigung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_BefestigungAdapter() {
		if (signal_BefestigungItemProvider == null) {
			signal_BefestigungItemProvider = new Signal_BefestigungItemProvider(this);
		}

		return signal_BefestigungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Befestigung_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Befestigung_Allg_AttributeGroupItemProvider signal_Befestigung_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Befestigung_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Befestigung_Allg_AttributeGroupAdapter() {
		if (signal_Befestigung_Allg_AttributeGroupItemProvider == null) {
			signal_Befestigung_Allg_AttributeGroupItemProvider = new Signal_Befestigung_Allg_AttributeGroupItemProvider(this);
		}

		return signal_Befestigung_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Befestigungsart_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Befestigungsart_TypeClassItemProvider signal_Befestigungsart_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Befestigungsart_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Befestigungsart_TypeClassAdapter() {
		if (signal_Befestigungsart_TypeClassItemProvider == null) {
			signal_Befestigungsart_TypeClassItemProvider = new Signal_Befestigungsart_TypeClassItemProvider(this);
		}

		return signal_Befestigungsart_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Fank_Zuordnung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Fank_ZuordnungItemProvider signal_Fank_ZuordnungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Fank_Zuordnung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Fank_ZuordnungAdapter() {
		if (signal_Fank_ZuordnungItemProvider == null) {
			signal_Fank_ZuordnungItemProvider = new Signal_Fank_ZuordnungItemProvider(this);
		}

		return signal_Fank_ZuordnungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Fiktiv_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Fiktiv_AttributeGroupItemProvider signal_Fiktiv_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Fiktiv_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Fiktiv_AttributeGroupAdapter() {
		if (signal_Fiktiv_AttributeGroupItemProvider == null) {
			signal_Fiktiv_AttributeGroupItemProvider = new Signal_Fiktiv_AttributeGroupItemProvider(this);
		}

		return signal_Fiktiv_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Fstr_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Fstr_AttributeGroupItemProvider signal_Fstr_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Fstr_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Fstr_AttributeGroupAdapter() {
		if (signal_Fstr_AttributeGroupItemProvider == null) {
			signal_Fstr_AttributeGroupItemProvider = new Signal_Fstr_AttributeGroupItemProvider(this);
		}

		return signal_Fstr_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Fstr_Aus_Inselgleis_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Fstr_Aus_Inselgleis_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Fstr_Aus_Inselgleis_AttributeGroupAdapter() {
		if (signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider == null) {
			signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider = new Signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider(this);
		}

		return signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Fstr_S_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Fstr_S_AttributeGroupItemProvider signal_Fstr_S_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Fstr_S_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Fstr_S_AttributeGroupAdapter() {
		if (signal_Fstr_S_AttributeGroupItemProvider == null) {
			signal_Fstr_S_AttributeGroupItemProvider = new Signal_Fstr_S_AttributeGroupItemProvider(this);
		}

		return signal_Fstr_S_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Funktion_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Funktion_TypeClassItemProvider signal_Funktion_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Funktion_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Funktion_TypeClassAdapter() {
		if (signal_Funktion_TypeClassItemProvider == null) {
			signal_Funktion_TypeClassItemProvider = new Signal_Funktion_TypeClassItemProvider(this);
		}

		return signal_Funktion_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Rahmen} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_RahmenItemProvider signal_RahmenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Rahmen}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_RahmenAdapter() {
		if (signal_RahmenItemProvider == null) {
			signal_RahmenItemProvider = new Signal_RahmenItemProvider(this);
		}

		return signal_RahmenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Real_Aktiv_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Real_Aktiv_AttributeGroupItemProvider signal_Real_Aktiv_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Real_Aktiv_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Real_Aktiv_AttributeGroupAdapter() {
		if (signal_Real_Aktiv_AttributeGroupItemProvider == null) {
			signal_Real_Aktiv_AttributeGroupItemProvider = new Signal_Real_Aktiv_AttributeGroupItemProvider(this);
		}

		return signal_Real_Aktiv_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Real_Aktiv_Schirm_AttributeGroupItemProvider signal_Real_Aktiv_Schirm_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Real_Aktiv_Schirm_AttributeGroupAdapter() {
		if (signal_Real_Aktiv_Schirm_AttributeGroupItemProvider == null) {
			signal_Real_Aktiv_Schirm_AttributeGroupItemProvider = new Signal_Real_Aktiv_Schirm_AttributeGroupItemProvider(this);
		}

		return signal_Real_Aktiv_Schirm_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Real_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Real_AttributeGroupItemProvider signal_Real_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Real_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Real_AttributeGroupAdapter() {
		if (signal_Real_AttributeGroupItemProvider == null) {
			signal_Real_AttributeGroupItemProvider = new Signal_Real_AttributeGroupItemProvider(this);
		}

		return signal_Real_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Signalbegriff} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_SignalbegriffItemProvider signal_SignalbegriffItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Signalbegriff}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_SignalbegriffAdapter() {
		if (signal_SignalbegriffItemProvider == null) {
			signal_SignalbegriffItemProvider = new Signal_SignalbegriffItemProvider(this);
		}

		return signal_SignalbegriffItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signal_Signalbegriff_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signal_Signalbegriff_Allg_AttributeGroupItemProvider signal_Signalbegriff_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signal_Signalbegriff_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignal_Signalbegriff_Allg_AttributeGroupAdapter() {
		if (signal_Signalbegriff_Allg_AttributeGroupItemProvider == null) {
			signal_Signalbegriff_Allg_AttributeGroupItemProvider = new Signal_Signalbegriff_Allg_AttributeGroupItemProvider(this);
		}

		return signal_Signalbegriff_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signalsicht_Erreichbar_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signalsicht_Erreichbar_TypeClassItemProvider signalsicht_Erreichbar_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signalsicht_Erreichbar_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsicht_Erreichbar_TypeClassAdapter() {
		if (signalsicht_Erreichbar_TypeClassItemProvider == null) {
			signalsicht_Erreichbar_TypeClassItemProvider = new Signalsicht_Erreichbar_TypeClassItemProvider(this);
		}

		return signalsicht_Erreichbar_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signalsicht_Mindest_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signalsicht_Mindest_TypeClassItemProvider signalsicht_Mindest_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signalsicht_Mindest_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsicht_Mindest_TypeClassAdapter() {
		if (signalsicht_Mindest_TypeClassItemProvider == null) {
			signalsicht_Mindest_TypeClassItemProvider = new Signalsicht_Mindest_TypeClassItemProvider(this);
		}

		return signalsicht_Mindest_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signalsicht_Soll_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signalsicht_Soll_TypeClassItemProvider signalsicht_Soll_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signalsicht_Soll_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsicht_Soll_TypeClassAdapter() {
		if (signalsicht_Soll_TypeClassItemProvider == null) {
			signalsicht_Soll_TypeClassItemProvider = new Signalsicht_Soll_TypeClassItemProvider(this);
		}

		return signalsicht_Soll_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Signalsystem_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Signalsystem_TypeClassItemProvider signalsystem_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Signalsystem_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSignalsystem_TypeClassAdapter() {
		if (signalsystem_TypeClassItemProvider == null) {
			signalsystem_TypeClassItemProvider = new Signalsystem_TypeClassItemProvider(this);
		}

		return signalsystem_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Sonstige_Zulaessige_Anordnung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Sonstige_Zulaessige_Anordnung_TypeClassItemProvider sonstige_Zulaessige_Anordnung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Sonstige_Zulaessige_Anordnung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSonstige_Zulaessige_Anordnung_TypeClassAdapter() {
		if (sonstige_Zulaessige_Anordnung_TypeClassItemProvider == null) {
			sonstige_Zulaessige_Anordnung_TypeClassItemProvider = new Sonstige_Zulaessige_Anordnung_TypeClassItemProvider(this);
		}

		return sonstige_Zulaessige_Anordnung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Streuscheibe_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Streuscheibe_Art_TypeClassItemProvider streuscheibe_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Streuscheibe_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStreuscheibe_Art_TypeClassAdapter() {
		if (streuscheibe_Art_TypeClassItemProvider == null) {
			streuscheibe_Art_TypeClassItemProvider = new Streuscheibe_Art_TypeClassItemProvider(this);
		}

		return streuscheibe_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Streuscheibe_Betriebsstellung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Streuscheibe_Betriebsstellung_TypeClassItemProvider streuscheibe_Betriebsstellung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Streuscheibe_Betriebsstellung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStreuscheibe_Betriebsstellung_TypeClassAdapter() {
		if (streuscheibe_Betriebsstellung_TypeClassItemProvider == null) {
			streuscheibe_Betriebsstellung_TypeClassItemProvider = new Streuscheibe_Betriebsstellung_TypeClassItemProvider(this);
		}

		return streuscheibe_Betriebsstellung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Tunnelsignal_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Tunnelsignal_TypeClassItemProvider tunnelsignal_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Tunnelsignal_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTunnelsignal_TypeClassAdapter() {
		if (tunnelsignal_TypeClassItemProvider == null) {
			tunnelsignal_TypeClassItemProvider = new Tunnelsignal_TypeClassItemProvider(this);
		}

		return tunnelsignal_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.Signale.Zs2_Ueberwacht_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zs2_Ueberwacht_TypeClassItemProvider zs2_Ueberwacht_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.Signale.Zs2_Ueberwacht_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZs2_Ueberwacht_TypeClassAdapter() {
		if (zs2_Ueberwacht_TypeClassItemProvider == null) {
			zs2_Ueberwacht_TypeClassItemProvider = new Zs2_Ueberwacht_TypeClassItemProvider(this);
		}

		return zs2_Ueberwacht_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (anschaltdauer_TypeClassItemProvider != null) anschaltdauer_TypeClassItemProvider.dispose();
		if (auto_Einstellung_TypeClassItemProvider != null) auto_Einstellung_TypeClassItemProvider.dispose();
		if (befestigung_Art_TypeClassItemProvider != null) befestigung_Art_TypeClassItemProvider.dispose();
		if (beleuchtet_TypeClassItemProvider != null) beleuchtet_TypeClassItemProvider.dispose();
		if (besetzte_Ausfahrt_TypeClassItemProvider != null) besetzte_Ausfahrt_TypeClassItemProvider.dispose();
		if (dA_Manuell_TypeClassItemProvider != null) dA_Manuell_TypeClassItemProvider.dispose();
		if (dunkelschaltung_TypeClassItemProvider != null) dunkelschaltung_TypeClassItemProvider.dispose();
		if (durchfahrt_TypeClassItemProvider != null) durchfahrt_TypeClassItemProvider.dispose();
		if (fiktives_Signal_Funktion_TypeClassItemProvider != null) fiktives_Signal_Funktion_TypeClassItemProvider.dispose();
		if (fundament_Art_TypeClassItemProvider != null) fundament_Art_TypeClassItemProvider.dispose();
		if (funktion_Ohne_Signal_TypeClassItemProvider != null) funktion_Ohne_Signal_TypeClassItemProvider.dispose();
		if (gegengleis_TypeClassItemProvider != null) gegengleis_TypeClassItemProvider.dispose();
		if (geltungsbereich_TypeClassItemProvider != null) geltungsbereich_TypeClassItemProvider.dispose();
		if (geschaltet_TypeClassItemProvider != null) geschaltet_TypeClassItemProvider.dispose();
		if (hoehe_Fundamentoberkante_TypeClassItemProvider != null) hoehe_Fundamentoberkante_TypeClassItemProvider.dispose();
		if (obere_Lichtpunkthoehe_TypeClassItemProvider != null) obere_Lichtpunkthoehe_TypeClassItemProvider.dispose();
		if (pzB_Schutzstrecke_Soll_TypeClassItemProvider != null) pzB_Schutzstrecke_Soll_TypeClassItemProvider.dispose();
		if (rahmen_Art_TypeClassItemProvider != null) rahmen_Art_TypeClassItemProvider.dispose();
		if (rahmen_Hoehe_TypeClassItemProvider != null) rahmen_Hoehe_TypeClassItemProvider.dispose();
		if (rangierstrasse_Restaufloesung_TypeClassItemProvider != null) rangierstrasse_Restaufloesung_TypeClassItemProvider.dispose();
		if (richtpunkt_TypeClassItemProvider != null) richtpunkt_TypeClassItemProvider.dispose();
		if (richtpunktentfernung_TypeClassItemProvider != null) richtpunktentfernung_TypeClassItemProvider.dispose();
		if (signalItemProvider != null) signalItemProvider.dispose();
		if (signal_Art_TypeClassItemProvider != null) signal_Art_TypeClassItemProvider.dispose();
		if (signal_BefestigungItemProvider != null) signal_BefestigungItemProvider.dispose();
		if (signal_Befestigung_Allg_AttributeGroupItemProvider != null) signal_Befestigung_Allg_AttributeGroupItemProvider.dispose();
		if (signal_Befestigungsart_TypeClassItemProvider != null) signal_Befestigungsart_TypeClassItemProvider.dispose();
		if (signal_Fank_ZuordnungItemProvider != null) signal_Fank_ZuordnungItemProvider.dispose();
		if (signal_Fiktiv_AttributeGroupItemProvider != null) signal_Fiktiv_AttributeGroupItemProvider.dispose();
		if (signal_Fstr_AttributeGroupItemProvider != null) signal_Fstr_AttributeGroupItemProvider.dispose();
		if (signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider != null) signal_Fstr_Aus_Inselgleis_AttributeGroupItemProvider.dispose();
		if (signal_Fstr_S_AttributeGroupItemProvider != null) signal_Fstr_S_AttributeGroupItemProvider.dispose();
		if (signal_Funktion_TypeClassItemProvider != null) signal_Funktion_TypeClassItemProvider.dispose();
		if (signal_RahmenItemProvider != null) signal_RahmenItemProvider.dispose();
		if (signal_Real_Aktiv_AttributeGroupItemProvider != null) signal_Real_Aktiv_AttributeGroupItemProvider.dispose();
		if (signal_Real_Aktiv_Schirm_AttributeGroupItemProvider != null) signal_Real_Aktiv_Schirm_AttributeGroupItemProvider.dispose();
		if (signal_Real_AttributeGroupItemProvider != null) signal_Real_AttributeGroupItemProvider.dispose();
		if (signal_SignalbegriffItemProvider != null) signal_SignalbegriffItemProvider.dispose();
		if (signal_Signalbegriff_Allg_AttributeGroupItemProvider != null) signal_Signalbegriff_Allg_AttributeGroupItemProvider.dispose();
		if (signalsicht_Erreichbar_TypeClassItemProvider != null) signalsicht_Erreichbar_TypeClassItemProvider.dispose();
		if (signalsicht_Mindest_TypeClassItemProvider != null) signalsicht_Mindest_TypeClassItemProvider.dispose();
		if (signalsicht_Soll_TypeClassItemProvider != null) signalsicht_Soll_TypeClassItemProvider.dispose();
		if (signalsystem_TypeClassItemProvider != null) signalsystem_TypeClassItemProvider.dispose();
		if (sonstige_Zulaessige_Anordnung_TypeClassItemProvider != null) sonstige_Zulaessige_Anordnung_TypeClassItemProvider.dispose();
		if (streuscheibe_Art_TypeClassItemProvider != null) streuscheibe_Art_TypeClassItemProvider.dispose();
		if (streuscheibe_Betriebsstellung_TypeClassItemProvider != null) streuscheibe_Betriebsstellung_TypeClassItemProvider.dispose();
		if (tunnelsignal_TypeClassItemProvider != null) tunnelsignal_TypeClassItemProvider.dispose();
		if (zs2_Ueberwacht_TypeClassItemProvider != null) zs2_Ueberwacht_TypeClassItemProvider.dispose();
	}

}
