/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.Bedienung;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUMA Wert</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.model.model11001.Bedienung.BedienungPackage#getENUMAWert()
 * @model extendedMetaData="name='ENUMA_Wert'"
 * @generated
 */
public enum ENUMAWert implements Enumerator {
	/**
	 * The '<em><b>ENUMA Wert 16</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_16_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_16(0, "ENUMA_Wert_16", "16"),

	/**
	 * The '<em><b>ENUMA Wert 32</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_32_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_32(1, "ENUMA_Wert_32", "32"),

	/**
	 * The '<em><b>ENUMA Wert 48</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_48_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_48(2, "ENUMA_Wert_48", "48"),

	/**
	 * The '<em><b>ENUMA Wert 64</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_64_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_64(3, "ENUMA_Wert_64", "64"),

	/**
	 * The '<em><b>ENUMA Wert 80</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_80_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_80(4, "ENUMA_Wert_80", "80"),

	/**
	 * The '<em><b>ENUMA Wert 96</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_96_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_96(5, "ENUMA_Wert_96", "96"),

	/**
	 * The '<em><b>ENUMA Wert 112</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_112_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_112(6, "ENUMA_Wert_112", "112"),

	/**
	 * The '<em><b>ENUMA Wert 128</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_128_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_128(7, "ENUMA_Wert_128", "128"),

	/**
	 * The '<em><b>ENUMA Wert 144</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_144_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_144(8, "ENUMA_Wert_144", "144"),

	/**
	 * The '<em><b>ENUMA Wert 160</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_160_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_160(9, "ENUMA_Wert_160", "160"),

	/**
	 * The '<em><b>ENUMA Wert 176</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_176_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_176(10, "ENUMA_Wert_176", "176"),

	/**
	 * The '<em><b>ENUMA Wert 192</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_192_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_192(11, "ENUMA_Wert_192", "192"),

	/**
	 * The '<em><b>ENUMA Wert 208</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_208_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_208(12, "ENUMA_Wert_208", "208"),

	/**
	 * The '<em><b>ENUMA Wert 224</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_224_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_224(13, "ENUMA_Wert_224", "224"),

	/**
	 * The '<em><b>ENUMA Wert 240</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_240_VALUE
	 * @generated
	 * @ordered
	 */
	ENUMA_WERT_240(14, "ENUMA_Wert_240", "240");

	/**
	 * The '<em><b>ENUMA Wert 16</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_16
	 * @model name="ENUMA_Wert_16" literal="16"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_16_VALUE = 0;

	/**
	 * The '<em><b>ENUMA Wert 32</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_32
	 * @model name="ENUMA_Wert_32" literal="32"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_32_VALUE = 1;

	/**
	 * The '<em><b>ENUMA Wert 48</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_48
	 * @model name="ENUMA_Wert_48" literal="48"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_48_VALUE = 2;

	/**
	 * The '<em><b>ENUMA Wert 64</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_64
	 * @model name="ENUMA_Wert_64" literal="64"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_64_VALUE = 3;

	/**
	 * The '<em><b>ENUMA Wert 80</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_80
	 * @model name="ENUMA_Wert_80" literal="80"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_80_VALUE = 4;

	/**
	 * The '<em><b>ENUMA Wert 96</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_96
	 * @model name="ENUMA_Wert_96" literal="96"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_96_VALUE = 5;

	/**
	 * The '<em><b>ENUMA Wert 112</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_112
	 * @model name="ENUMA_Wert_112" literal="112"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_112_VALUE = 6;

	/**
	 * The '<em><b>ENUMA Wert 128</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_128
	 * @model name="ENUMA_Wert_128" literal="128"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_128_VALUE = 7;

	/**
	 * The '<em><b>ENUMA Wert 144</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_144
	 * @model name="ENUMA_Wert_144" literal="144"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_144_VALUE = 8;

	/**
	 * The '<em><b>ENUMA Wert 160</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_160
	 * @model name="ENUMA_Wert_160" literal="160"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_160_VALUE = 9;

	/**
	 * The '<em><b>ENUMA Wert 176</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_176
	 * @model name="ENUMA_Wert_176" literal="176"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_176_VALUE = 10;

	/**
	 * The '<em><b>ENUMA Wert 192</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_192
	 * @model name="ENUMA_Wert_192" literal="192"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_192_VALUE = 11;

	/**
	 * The '<em><b>ENUMA Wert 208</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_208
	 * @model name="ENUMA_Wert_208" literal="208"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_208_VALUE = 12;

	/**
	 * The '<em><b>ENUMA Wert 224</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_224
	 * @model name="ENUMA_Wert_224" literal="224"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_224_VALUE = 13;

	/**
	 * The '<em><b>ENUMA Wert 240</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUMA_WERT_240
	 * @model name="ENUMA_Wert_240" literal="240"
	 * @generated
	 * @ordered
	 */
	public static final int ENUMA_WERT_240_VALUE = 14;

	/**
	 * An array of all the '<em><b>ENUMA Wert</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMAWert[] VALUES_ARRAY =
		new ENUMAWert[] {
			ENUMA_WERT_16,
			ENUMA_WERT_32,
			ENUMA_WERT_48,
			ENUMA_WERT_64,
			ENUMA_WERT_80,
			ENUMA_WERT_96,
			ENUMA_WERT_112,
			ENUMA_WERT_128,
			ENUMA_WERT_144,
			ENUMA_WERT_160,
			ENUMA_WERT_176,
			ENUMA_WERT_192,
			ENUMA_WERT_208,
			ENUMA_WERT_224,
			ENUMA_WERT_240,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUMA Wert</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMAWert> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUMA Wert</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMAWert get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMAWert result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMA Wert</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMAWert getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMAWert result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUMA Wert</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMAWert get(int value) {
		switch (value) {
			case ENUMA_WERT_16_VALUE: return ENUMA_WERT_16;
			case ENUMA_WERT_32_VALUE: return ENUMA_WERT_32;
			case ENUMA_WERT_48_VALUE: return ENUMA_WERT_48;
			case ENUMA_WERT_64_VALUE: return ENUMA_WERT_64;
			case ENUMA_WERT_80_VALUE: return ENUMA_WERT_80;
			case ENUMA_WERT_96_VALUE: return ENUMA_WERT_96;
			case ENUMA_WERT_112_VALUE: return ENUMA_WERT_112;
			case ENUMA_WERT_128_VALUE: return ENUMA_WERT_128;
			case ENUMA_WERT_144_VALUE: return ENUMA_WERT_144;
			case ENUMA_WERT_160_VALUE: return ENUMA_WERT_160;
			case ENUMA_WERT_176_VALUE: return ENUMA_WERT_176;
			case ENUMA_WERT_192_VALUE: return ENUMA_WERT_192;
			case ENUMA_WERT_208_VALUE: return ENUMA_WERT_208;
			case ENUMA_WERT_224_VALUE: return ENUMA_WERT_224;
			case ENUMA_WERT_240_VALUE: return ENUMA_WERT_240;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMAWert(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMAWert
