/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef;

import org.eclipse.set.browser.lib.ChromiumLib;
import org.eclipse.swt.widgets.Display;

public class MessageLoop {
    private static final int LOOP = 75;
    private boolean loopDisable;
    private boolean loopShutdown = false;
    private Runnable loopWork;
    private final Runnable loopWorkRunnable = () -> {
        Display display = Display.getCurrent();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.loop_work();
    };
    private boolean pumpDisable;

    public void disablePump() {
        this.pumpDisable = true;
    }

    public void pause() {
        this.loopDisable = true;
    }

    public void restartLoop(Display display, int ms) {
        if (this.loopWork != null) {
            display.timerExec(-1, this.loopWork);
            display.timerExec(75 + ms, this.loopWork);
        }
    }

    public void scheduleMessagePumpWork(int delay) {
        if (this.pumpDisable) {
            return;
        }
        Display display = Display.getDefault();
        Runnable scheduleWork = () -> {
            this.restartLoop(display, delay);
            display.timerExec(-1, this.loopWorkRunnable);
            display.timerExec(delay, this.loopWorkRunnable);
        };
        if (Display.getCurrent() != null) {
            if (delay <= 0) {
                this.restartLoop(display, 0);
                display.asyncExec(this.loopWorkRunnable);
            } else {
                scheduleWork.run();
            }
        } else if (delay <= 0) {
            display.asyncExec(() -> {
                this.restartLoop(display, 0);
                this.loopWorkRunnable.run();
            });
        } else {
            display.asyncExec(scheduleWork);
        }
    }

    public void shutdown() {
        this.loopShutdown = true;
    }

    public void start() {
        this.loopWork = () -> {
            if (!this.loopShutdown && !Display.getDefault().isDisposed()) {
                this.loop_work();
                Display.getDefault().timerExec(150, this.loopWork);
            }
        };
        Display.getDefault().timerExec(75, this.loopWork);
    }

    public void unpause() {
        this.loopDisable = false;
    }

    private void loop_work() {
        if (!this.loopDisable) {
            if (ChromiumLib.cefswt_do_message_loop_work() == 0) {
                System.err.println("error looping chromium");
            }
            if (this.pumpDisable) {
                this.pumpDisable = false;
            }
        }
    }
}

