/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef;

import org.eclipse.set.browser.lib.CEFLibrary;

public class CEFConfiguration {
    public int DebugPort = CEFConfiguration.getDebugPort();
    public String Locale = System.getProperty("org.eclipse.set.browser.locale", "en-US");
    public String LogPath = String.valueOf(CEFLibrary.getTempPath()) + "/cef_lib.log";
    public LOG_SEVERITY LogLevel = LOG_SEVERITY.INFO;
    public String UserAgentProduct = System.getProperty("org.eclipse.set.browser.user-agent-product", "Eclipse SET");

    private static int getDebugPort() {
        try {
            return Integer.parseInt(System.getProperty("org.eclipse.set.browser.remote-debugging-port", "0"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static enum LOG_SEVERITY {
        DEFAULT(0),
        VERBOSE(1),
        INFO(2),
        WARNING(3),
        ERROR(4),
        FATAL(5),
        DISABLE(99);

        private final int value;

        private LOG_SEVERITY(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

