/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.toolboxmodel.transform.internal;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.toolboxmodel.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.toolboxmodel.PlanPro.util.IDReference;
import org.eclipse.set.toolboxmodel.transform.internal.GuidCache;

public class ToolboxIDResolver {
    private final GuidCache guidCache = new GuidCache();

    private ToolboxIDResolver(PlanPro_Schnittstelle model) {
        this.guidCache.prepare(model);
    }

    public static List<IDReference> resolveIDReferences(PlanPro_Schnittstelle model, List<IDReference> references) {
        ToolboxIDResolver resolver = new ToolboxIDResolver(model);
        return references.stream().filter(reference -> !resolver.resolveIDReference((IDReference)reference)).toList();
    }

    private boolean resolveIDReference(IDReference reference) {
        if (reference.guid() == null) {
            if (reference.targetRef().isUnsettable()) {
                return ToolboxIDResolver.setIDReference(reference, null);
            }
            return false;
        }
        EObject value = this.guidCache.get(reference.guid(), reference.target());
        if (value != null) {
            return ToolboxIDResolver.setIDReference(reference, value);
        }
        return false;
    }

    private static boolean setIDReference(IDReference reference, EObject value) {
        EClass referenceType = reference.targetRef().getEReferenceType();
        if (value != null) {
            Class<?> valueClass = value.getClass();
            Class referenceClass = referenceType.getInstanceClass();
            if (!referenceClass.isAssignableFrom(valueClass)) {
                return false;
            }
        }
        if (reference.targetRef().isMany()) {
            EList list = (EList)reference.target().eGet((EStructuralFeature)reference.targetRef());
            list.add((Object)value);
        } else {
            reference.target().eSet((EStructuralFeature)reference.targetRef(), (Object)value);
        }
        return true;
    }
}

