/**
 * Copyright (c) 2022 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Geodaten.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Geodaten.util.GeodatenAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class GeodatenItemProviderAdapterFactory extends GeodatenAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GeodatenItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Bezeichnung_Strecke_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_Strecke_TypeClassItemProvider bezeichnung_Strecke_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Bezeichnung_Strecke_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_Strecke_TypeClassAdapter() {
		if (bezeichnung_Strecke_TypeClassItemProvider == null) {
			bezeichnung_Strecke_TypeClassItemProvider = new Bezeichnung_Strecke_TypeClassItemProvider(this);
		}

		return bezeichnung_Strecke_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Form_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_Form_TypeClassItemProvider geO_Form_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Form_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_Form_TypeClassAdapter() {
		if (geO_Form_TypeClassItemProvider == null) {
			geO_Form_TypeClassItemProvider = new GEO_Form_TypeClassItemProvider(this);
		}

		return geO_Form_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_KanteItemProvider geO_KanteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_KanteAdapter() {
		if (geO_KanteItemProvider == null) {
			geO_KanteItemProvider = new GEO_KanteItemProvider(this);
		}

		return geO_KanteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_Kante_Allg_AttributeGroupItemProvider geO_Kante_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_Kante_Allg_AttributeGroupAdapter() {
		if (geO_Kante_Allg_AttributeGroupItemProvider == null) {
			geO_Kante_Allg_AttributeGroupItemProvider = new GEO_Kante_Allg_AttributeGroupItemProvider(this);
		}

		return geO_Kante_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_KnotenItemProvider geO_KnotenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_KnotenAdapter() {
		if (geO_KnotenItemProvider == null) {
			geO_KnotenItemProvider = new GEO_KnotenItemProvider(this);
		}

		return geO_KnotenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_KoordinatenSystem_LSys_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_KoordinatenSystem_LSys_TypeClassItemProvider geO_KoordinatenSystem_LSys_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_KoordinatenSystem_LSys_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_KoordinatenSystem_LSys_TypeClassAdapter() {
		if (geO_KoordinatenSystem_LSys_TypeClassItemProvider == null) {
			geO_KoordinatenSystem_LSys_TypeClassItemProvider = new GEO_KoordinatenSystem_LSys_TypeClassItemProvider(this);
		}

		return geO_KoordinatenSystem_LSys_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_KoordinatenSystem_Sonstige_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_KoordinatenSystem_Sonstige_TypeClassItemProvider geO_KoordinatenSystem_Sonstige_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_KoordinatenSystem_Sonstige_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_KoordinatenSystem_Sonstige_TypeClassAdapter() {
		if (geO_KoordinatenSystem_Sonstige_TypeClassItemProvider == null) {
			geO_KoordinatenSystem_Sonstige_TypeClassItemProvider = new GEO_KoordinatenSystem_Sonstige_TypeClassItemProvider(this);
		}

		return geO_KoordinatenSystem_Sonstige_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_Laenge_TypeClassItemProvider geO_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_Laenge_TypeClassAdapter() {
		if (geO_Laenge_TypeClassItemProvider == null) {
			geO_Laenge_TypeClassItemProvider = new GEO_Laenge_TypeClassItemProvider(this);
		}

		return geO_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_PAD_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_PAD_TypeClassItemProvider geO_PAD_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_PAD_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_PAD_TypeClassAdapter() {
		if (geO_PAD_TypeClassItemProvider == null) {
			geO_PAD_TypeClassItemProvider = new GEO_PAD_TypeClassItemProvider(this);
		}

		return geO_PAD_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_PunktItemProvider geO_PunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_PunktAdapter() {
		if (geO_PunktItemProvider == null) {
			geO_PunktItemProvider = new GEO_PunktItemProvider(this);
		}

		return geO_PunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_Punkt_Allg_AttributeGroupItemProvider geO_Punkt_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_Punkt_Allg_AttributeGroupAdapter() {
		if (geO_Punkt_Allg_AttributeGroupItemProvider == null) {
			geO_Punkt_Allg_AttributeGroupItemProvider = new GEO_Punkt_Allg_AttributeGroupItemProvider(this);
		}

		return geO_Punkt_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Radius_A_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_Radius_A_TypeClassItemProvider geO_Radius_A_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Radius_A_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_Radius_A_TypeClassAdapter() {
		if (geO_Radius_A_TypeClassItemProvider == null) {
			geO_Radius_A_TypeClassItemProvider = new GEO_Radius_A_TypeClassItemProvider(this);
		}

		return geO_Radius_A_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Radius_B_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_Radius_B_TypeClassItemProvider geO_Radius_B_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Radius_B_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_Radius_B_TypeClassAdapter() {
		if (geO_Radius_B_TypeClassItemProvider == null) {
			geO_Radius_B_TypeClassItemProvider = new GEO_Radius_B_TypeClassItemProvider(this);
		}

		return geO_Radius_B_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Richtungswinkel_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GEO_Richtungswinkel_TypeClassItemProvider geO_Richtungswinkel_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GEO_Richtungswinkel_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGEO_Richtungswinkel_TypeClassAdapter() {
		if (geO_Richtungswinkel_TypeClassItemProvider == null) {
			geO_Richtungswinkel_TypeClassItemProvider = new GEO_Richtungswinkel_TypeClassItemProvider(this);
		}

		return geO_Richtungswinkel_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Geschwindigkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Geschwindigkeit_TypeClassItemProvider geschwindigkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Geschwindigkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeschwindigkeit_TypeClassAdapter() {
		if (geschwindigkeit_TypeClassItemProvider == null) {
			geschwindigkeit_TypeClassItemProvider = new Geschwindigkeit_TypeClassItemProvider(this);
		}

		return geschwindigkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Geschwindigkeitsprofil} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GeschwindigkeitsprofilItemProvider geschwindigkeitsprofilItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Geschwindigkeitsprofil}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeschwindigkeitsprofilAdapter() {
		if (geschwindigkeitsprofilItemProvider == null) {
			geschwindigkeitsprofilItemProvider = new GeschwindigkeitsprofilItemProvider(this);
		}

		return geschwindigkeitsprofilItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Geschwindigkeitsprofil_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Geschwindigkeitsprofil_Allg_AttributeGroupItemProvider geschwindigkeitsprofil_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Geschwindigkeitsprofil_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGeschwindigkeitsprofil_Allg_AttributeGroupAdapter() {
		if (geschwindigkeitsprofil_Allg_AttributeGroupItemProvider == null) {
			geschwindigkeitsprofil_Allg_AttributeGroupItemProvider = new Geschwindigkeitsprofil_Allg_AttributeGroupItemProvider(this);
		}

		return geschwindigkeitsprofil_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GK_X_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GK_X_TypeClassItemProvider gK_X_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GK_X_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGK_X_TypeClassAdapter() {
		if (gK_X_TypeClassItemProvider == null) {
			gK_X_TypeClassItemProvider = new GK_X_TypeClassItemProvider(this);
		}

		return gK_X_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GK_Y_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GK_Y_TypeClassItemProvider gK_Y_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GK_Y_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGK_Y_TypeClassAdapter() {
		if (gK_Y_TypeClassItemProvider == null) {
			gK_Y_TypeClassItemProvider = new GK_Y_TypeClassItemProvider(this);
		}

		return gK_Y_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.GK_Z_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GK_Z_TypeClassItemProvider gK_Z_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.GK_Z_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGK_Z_TypeClassAdapter() {
		if (gK_Z_TypeClassItemProvider == null) {
			gK_Z_TypeClassItemProvider = new GK_Z_TypeClassItemProvider(this);
		}

		return gK_Z_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HoehenlinieItemProvider hoehenlinieItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenlinieAdapter() {
		if (hoehenlinieItemProvider == null) {
			hoehenlinieItemProvider = new HoehenlinieItemProvider(this);
		}

		return hoehenlinieItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hoehenlinie_Allg_AttributeGroupItemProvider hoehenlinie_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenlinie_Allg_AttributeGroupAdapter() {
		if (hoehenlinie_Allg_AttributeGroupItemProvider == null) {
			hoehenlinie_Allg_AttributeGroupItemProvider = new Hoehenlinie_Allg_AttributeGroupItemProvider(this);
		}

		return hoehenlinie_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie_Form_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hoehenlinie_Form_TypeClassItemProvider hoehenlinie_Form_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie_Form_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenlinie_Form_TypeClassAdapter() {
		if (hoehenlinie_Form_TypeClassItemProvider == null) {
			hoehenlinie_Form_TypeClassItemProvider = new Hoehenlinie_Form_TypeClassItemProvider(this);
		}

		return hoehenlinie_Form_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hoehenlinie_Laenge_TypeClassItemProvider hoehenlinie_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenlinie_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenlinie_Laenge_TypeClassAdapter() {
		if (hoehenlinie_Laenge_TypeClassItemProvider == null) {
			hoehenlinie_Laenge_TypeClassItemProvider = new Hoehenlinie_Laenge_TypeClassItemProvider(this);
		}

		return hoehenlinie_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HoehenpunktItemProvider hoehenpunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenpunktAdapter() {
		if (hoehenpunktItemProvider == null) {
			hoehenpunktItemProvider = new HoehenpunktItemProvider(this);
		}

		return hoehenpunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hoehenpunkt_Allg_AttributeGroupItemProvider hoehenpunkt_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenpunkt_Allg_AttributeGroupAdapter() {
		if (hoehenpunkt_Allg_AttributeGroupItemProvider == null) {
			hoehenpunkt_Allg_AttributeGroupItemProvider = new Hoehenpunkt_Allg_AttributeGroupItemProvider(this);
		}

		return hoehenpunkt_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt_Datum_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hoehenpunkt_Datum_TypeClassItemProvider hoehenpunkt_Datum_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt_Datum_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenpunkt_Datum_TypeClassAdapter() {
		if (hoehenpunkt_Datum_TypeClassItemProvider == null) {
			hoehenpunkt_Datum_TypeClassItemProvider = new Hoehenpunkt_Datum_TypeClassItemProvider(this);
		}

		return hoehenpunkt_Datum_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt_Hoehe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Hoehenpunkt_Hoehe_TypeClassItemProvider hoehenpunkt_Hoehe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Hoehenpunkt_Hoehe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHoehenpunkt_Hoehe_TypeClassAdapter() {
		if (hoehenpunkt_Hoehe_TypeClassItemProvider == null) {
			hoehenpunkt_Hoehe_TypeClassItemProvider = new Hoehenpunkt_Hoehe_TypeClassItemProvider(this);
		}

		return hoehenpunkt_Hoehe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.HSystem_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HSystem_TypeClassItemProvider hSystem_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.HSystem_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHSystem_TypeClassAdapter() {
		if (hSystem_TypeClassItemProvider == null) {
			hSystem_TypeClassItemProvider = new HSystem_TypeClassItemProvider(this);
		}

		return hSystem_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Knotenname_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Knotenname_TypeClassItemProvider knotenname_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Knotenname_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createKnotenname_TypeClassAdapter() {
		if (knotenname_TypeClassItemProvider == null) {
			knotenname_TypeClassItemProvider = new Knotenname_TypeClassItemProvider(this);
		}

		return knotenname_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Neigung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Neigung_TypeClassItemProvider neigung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Neigung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNeigung_TypeClassAdapter() {
		if (neigung_TypeClassItemProvider == null) {
			neigung_TypeClassItemProvider = new Neigung_TypeClassItemProvider(this);
		}

		return neigung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OertlichkeitItemProvider oertlichkeitItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeitAdapter() {
		if (oertlichkeitItemProvider == null) {
			oertlichkeitItemProvider = new OertlichkeitItemProvider(this);
		}

		return oertlichkeitItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Abkuerzung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Abkuerzung_TypeClassItemProvider oertlichkeit_Abkuerzung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Abkuerzung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Abkuerzung_TypeClassAdapter() {
		if (oertlichkeit_Abkuerzung_TypeClassItemProvider == null) {
			oertlichkeit_Abkuerzung_TypeClassItemProvider = new Oertlichkeit_Abkuerzung_TypeClassItemProvider(this);
		}

		return oertlichkeit_Abkuerzung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Allg_AttributeGroupItemProvider oertlichkeit_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Allg_AttributeGroupAdapter() {
		if (oertlichkeit_Allg_AttributeGroupItemProvider == null) {
			oertlichkeit_Allg_AttributeGroupItemProvider = new Oertlichkeit_Allg_AttributeGroupItemProvider(this);
		}

		return oertlichkeit_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Art_TypeClassItemProvider oertlichkeit_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Art_TypeClassAdapter() {
		if (oertlichkeit_Art_TypeClassItemProvider == null) {
			oertlichkeit_Art_TypeClassItemProvider = new Oertlichkeit_Art_TypeClassItemProvider(this);
		}

		return oertlichkeit_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Bezeichnung_AttributeGroupItemProvider oertlichkeit_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Bezeichnung_AttributeGroupAdapter() {
		if (oertlichkeit_Bezeichnung_AttributeGroupItemProvider == null) {
			oertlichkeit_Bezeichnung_AttributeGroupItemProvider = new Oertlichkeit_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return oertlichkeit_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Gueltig_Ab_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Gueltig_Ab_TypeClassItemProvider oertlichkeit_Gueltig_Ab_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Gueltig_Ab_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Gueltig_Ab_TypeClassAdapter() {
		if (oertlichkeit_Gueltig_Ab_TypeClassItemProvider == null) {
			oertlichkeit_Gueltig_Ab_TypeClassItemProvider = new Oertlichkeit_Gueltig_Ab_TypeClassItemProvider(this);
		}

		return oertlichkeit_Gueltig_Ab_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Gueltig_Bis_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Gueltig_Bis_TypeClassItemProvider oertlichkeit_Gueltig_Bis_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Gueltig_Bis_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Gueltig_Bis_TypeClassAdapter() {
		if (oertlichkeit_Gueltig_Bis_TypeClassItemProvider == null) {
			oertlichkeit_Gueltig_Bis_TypeClassItemProvider = new Oertlichkeit_Gueltig_Bis_TypeClassItemProvider(this);
		}

		return oertlichkeit_Gueltig_Bis_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Kurzname_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Kurzname_TypeClassItemProvider oertlichkeit_Kurzname_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Kurzname_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Kurzname_TypeClassAdapter() {
		if (oertlichkeit_Kurzname_TypeClassItemProvider == null) {
			oertlichkeit_Kurzname_TypeClassItemProvider = new Oertlichkeit_Kurzname_TypeClassItemProvider(this);
		}

		return oertlichkeit_Kurzname_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Langname_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Oertlichkeit_Langname_TypeClassItemProvider oertlichkeit_Langname_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Oertlichkeit_Langname_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOertlichkeit_Langname_TypeClassAdapter() {
		if (oertlichkeit_Langname_TypeClassItemProvider == null) {
			oertlichkeit_Langname_TypeClassItemProvider = new Oertlichkeit_Langname_TypeClassItemProvider(this);
		}

		return oertlichkeit_Langname_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Plan_Quelle_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Plan_Quelle_TypeClassItemProvider plan_Quelle_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Plan_Quelle_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPlan_Quelle_TypeClassAdapter() {
		if (plan_Quelle_TypeClassItemProvider == null) {
			plan_Quelle_TypeClassItemProvider = new Plan_Quelle_TypeClassItemProvider(this);
		}

		return plan_Quelle_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StreckeItemProvider streckeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStreckeAdapter() {
		if (streckeItemProvider == null) {
			streckeItemProvider = new StreckeItemProvider(this);
		}

		return streckeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_Bezeichnung_AttributeGroupItemProvider strecke_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_Bezeichnung_AttributeGroupAdapter() {
		if (strecke_Bezeichnung_AttributeGroupItemProvider == null) {
			strecke_Bezeichnung_AttributeGroupItemProvider = new Strecke_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return strecke_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke_Meter_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_Meter_TypeClassItemProvider strecke_Meter_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke_Meter_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_Meter_TypeClassAdapter() {
		if (strecke_Meter_TypeClassItemProvider == null) {
			strecke_Meter_TypeClassItemProvider = new Strecke_Meter_TypeClassItemProvider(this);
		}

		return strecke_Meter_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke_Punkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_PunktItemProvider strecke_PunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Strecke_Punkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_PunktAdapter() {
		if (strecke_PunktItemProvider == null) {
			strecke_PunktItemProvider = new Strecke_PunktItemProvider(this);
		}

		return strecke_PunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TB_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TB_Art_TypeClassItemProvider tB_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TB_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTB_Art_TypeClassAdapter() {
		if (tB_Art_TypeClassItemProvider == null) {
			tB_Art_TypeClassItemProvider = new TB_Art_TypeClassItemProvider(this);
		}

		return tB_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TB_Beschreibung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TB_Beschreibung_TypeClassItemProvider tB_Beschreibung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TB_Beschreibung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTB_Beschreibung_TypeClassAdapter() {
		if (tB_Beschreibung_TypeClassItemProvider == null) {
			tB_Beschreibung_TypeClassItemProvider = new TB_Beschreibung_TypeClassItemProvider(this);
		}

		return tB_Beschreibung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Technischer_Bereich} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Technischer_BereichItemProvider technischer_BereichItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Technischer_Bereich}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnischer_BereichAdapter() {
		if (technischer_BereichItemProvider == null) {
			technischer_BereichItemProvider = new Technischer_BereichItemProvider(this);
		}

		return technischer_BereichItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Technischer_Punkt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Technischer_PunktItemProvider technischer_PunktItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Technischer_Punkt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTechnischer_PunktAdapter() {
		if (technischer_PunktItemProvider == null) {
			technischer_PunktItemProvider = new Technischer_PunktItemProvider(this);
		}

		return technischer_PunktItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Anschluss_A_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TOP_Anschluss_A_TypeClassItemProvider toP_Anschluss_A_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Anschluss_A_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTOP_Anschluss_A_TypeClassAdapter() {
		if (toP_Anschluss_A_TypeClassItemProvider == null) {
			toP_Anschluss_A_TypeClassItemProvider = new TOP_Anschluss_A_TypeClassItemProvider(this);
		}

		return toP_Anschluss_A_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Anschluss_B_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TOP_Anschluss_B_TypeClassItemProvider toP_Anschluss_B_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Anschluss_B_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTOP_Anschluss_B_TypeClassAdapter() {
		if (toP_Anschluss_B_TypeClassItemProvider == null) {
			toP_Anschluss_B_TypeClassItemProvider = new TOP_Anschluss_B_TypeClassItemProvider(this);
		}

		return toP_Anschluss_B_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TOP_KanteItemProvider toP_KanteItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTOP_KanteAdapter() {
		if (toP_KanteItemProvider == null) {
			toP_KanteItemProvider = new TOP_KanteItemProvider(this);
		}

		return toP_KanteItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TOP_Kante_Allg_AttributeGroupItemProvider toP_Kante_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTOP_Kante_Allg_AttributeGroupAdapter() {
		if (toP_Kante_Allg_AttributeGroupItemProvider == null) {
			toP_Kante_Allg_AttributeGroupItemProvider = new TOP_Kante_Allg_AttributeGroupItemProvider(this);
		}

		return toP_Kante_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TOP_KnotenItemProvider toP_KnotenItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTOP_KnotenAdapter() {
		if (toP_KnotenItemProvider == null) {
			toP_KnotenItemProvider = new TOP_KnotenItemProvider(this);
		}

		return toP_KnotenItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TOP_Laenge_TypeClassItemProvider toP_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TOP_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTOP_Laenge_TypeClassAdapter() {
		if (toP_Laenge_TypeClassItemProvider == null) {
			toP_Laenge_TypeClassItemProvider = new TOP_Laenge_TypeClassItemProvider(this);
		}

		return toP_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TP_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TP_Art_TypeClassItemProvider tP_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TP_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTP_Art_TypeClassAdapter() {
		if (tP_Art_TypeClassItemProvider == null) {
			tP_Art_TypeClassItemProvider = new TP_Art_TypeClassItemProvider(this);
		}

		return tP_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.TP_Beschreibung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TP_Beschreibung_TypeClassItemProvider tP_Beschreibung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.TP_Beschreibung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTP_Beschreibung_TypeClassAdapter() {
		if (tP_Beschreibung_TypeClassItemProvider == null) {
			tP_Beschreibung_TypeClassItemProvider = new TP_Beschreibung_TypeClassItemProvider(this);
		}

		return tP_Beschreibung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UeberhoehungItemProvider ueberhoehungItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehungAdapter() {
		if (ueberhoehungItemProvider == null) {
			ueberhoehungItemProvider = new UeberhoehungItemProvider(this);
		}

		return ueberhoehungItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberhoehung_Allg_AttributeGroupItemProvider ueberhoehung_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehung_Allg_AttributeGroupAdapter() {
		if (ueberhoehung_Allg_AttributeGroupItemProvider == null) {
			ueberhoehung_Allg_AttributeGroupItemProvider = new Ueberhoehung_Allg_AttributeGroupItemProvider(this);
		}

		return ueberhoehung_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung_Datum_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberhoehung_Datum_TypeClassItemProvider ueberhoehung_Datum_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung_Datum_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehung_Datum_TypeClassAdapter() {
		if (ueberhoehung_Datum_TypeClassItemProvider == null) {
			ueberhoehung_Datum_TypeClassItemProvider = new Ueberhoehung_Datum_TypeClassItemProvider(this);
		}

		return ueberhoehung_Datum_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung_Hoehe_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberhoehung_Hoehe_TypeClassItemProvider ueberhoehung_Hoehe_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehung_Hoehe_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehung_Hoehe_TypeClassAdapter() {
		if (ueberhoehung_Hoehe_TypeClassItemProvider == null) {
			ueberhoehung_Hoehe_TypeClassItemProvider = new Ueberhoehung_Hoehe_TypeClassItemProvider(this);
		}

		return ueberhoehung_Hoehe_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UeberhoehungslinieItemProvider ueberhoehungslinieItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehungslinieAdapter() {
		if (ueberhoehungslinieItemProvider == null) {
			ueberhoehungslinieItemProvider = new UeberhoehungslinieItemProvider(this);
		}

		return ueberhoehungslinieItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberhoehungslinie_Allg_AttributeGroupItemProvider ueberhoehungslinie_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehungslinie_Allg_AttributeGroupAdapter() {
		if (ueberhoehungslinie_Allg_AttributeGroupItemProvider == null) {
			ueberhoehungslinie_Allg_AttributeGroupItemProvider = new Ueberhoehungslinie_Allg_AttributeGroupItemProvider(this);
		}

		return ueberhoehungslinie_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Form_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberhoehungslinie_Form_TypeClassItemProvider ueberhoehungslinie_Form_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Form_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehungslinie_Form_TypeClassAdapter() {
		if (ueberhoehungslinie_Form_TypeClassItemProvider == null) {
			ueberhoehungslinie_Form_TypeClassItemProvider = new Ueberhoehungslinie_Form_TypeClassItemProvider(this);
		}

		return ueberhoehungslinie_Form_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Laenge_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Ueberhoehungslinie_Laenge_TypeClassItemProvider ueberhoehungslinie_Laenge_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Ueberhoehungslinie_Laenge_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUeberhoehungslinie_Laenge_TypeClassAdapter() {
		if (ueberhoehungslinie_Laenge_TypeClassItemProvider == null) {
			ueberhoehungslinie_Laenge_TypeClassItemProvider = new Ueberhoehungslinie_Laenge_TypeClassItemProvider(this);
		}

		return ueberhoehungslinie_Laenge_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.V_Profil_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected V_Profil_Art_TypeClassItemProvider v_Profil_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.V_Profil_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createV_Profil_Art_TypeClassAdapter() {
		if (v_Profil_Art_TypeClassItemProvider == null) {
			v_Profil_Art_TypeClassItemProvider = new V_Profil_Art_TypeClassItemProvider(this);
		}

		return v_Profil_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Geodaten.Wirkrichtung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Wirkrichtung_TypeClassItemProvider wirkrichtung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Geodaten.Wirkrichtung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createWirkrichtung_TypeClassAdapter() {
		if (wirkrichtung_TypeClassItemProvider == null) {
			wirkrichtung_TypeClassItemProvider = new Wirkrichtung_TypeClassItemProvider(this);
		}

		return wirkrichtung_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (bezeichnung_Strecke_TypeClassItemProvider != null) bezeichnung_Strecke_TypeClassItemProvider.dispose();
		if (geO_Form_TypeClassItemProvider != null) geO_Form_TypeClassItemProvider.dispose();
		if (geO_KanteItemProvider != null) geO_KanteItemProvider.dispose();
		if (geO_Kante_Allg_AttributeGroupItemProvider != null) geO_Kante_Allg_AttributeGroupItemProvider.dispose();
		if (geO_KnotenItemProvider != null) geO_KnotenItemProvider.dispose();
		if (geO_KoordinatenSystem_LSys_TypeClassItemProvider != null) geO_KoordinatenSystem_LSys_TypeClassItemProvider.dispose();
		if (geO_KoordinatenSystem_Sonstige_TypeClassItemProvider != null) geO_KoordinatenSystem_Sonstige_TypeClassItemProvider.dispose();
		if (geO_Laenge_TypeClassItemProvider != null) geO_Laenge_TypeClassItemProvider.dispose();
		if (geO_PAD_TypeClassItemProvider != null) geO_PAD_TypeClassItemProvider.dispose();
		if (geO_PunktItemProvider != null) geO_PunktItemProvider.dispose();
		if (geO_Punkt_Allg_AttributeGroupItemProvider != null) geO_Punkt_Allg_AttributeGroupItemProvider.dispose();
		if (geO_Radius_A_TypeClassItemProvider != null) geO_Radius_A_TypeClassItemProvider.dispose();
		if (geO_Radius_B_TypeClassItemProvider != null) geO_Radius_B_TypeClassItemProvider.dispose();
		if (geO_Richtungswinkel_TypeClassItemProvider != null) geO_Richtungswinkel_TypeClassItemProvider.dispose();
		if (geschwindigkeit_TypeClassItemProvider != null) geschwindigkeit_TypeClassItemProvider.dispose();
		if (geschwindigkeitsprofilItemProvider != null) geschwindigkeitsprofilItemProvider.dispose();
		if (geschwindigkeitsprofil_Allg_AttributeGroupItemProvider != null) geschwindigkeitsprofil_Allg_AttributeGroupItemProvider.dispose();
		if (gK_X_TypeClassItemProvider != null) gK_X_TypeClassItemProvider.dispose();
		if (gK_Y_TypeClassItemProvider != null) gK_Y_TypeClassItemProvider.dispose();
		if (gK_Z_TypeClassItemProvider != null) gK_Z_TypeClassItemProvider.dispose();
		if (hoehenlinieItemProvider != null) hoehenlinieItemProvider.dispose();
		if (hoehenlinie_Allg_AttributeGroupItemProvider != null) hoehenlinie_Allg_AttributeGroupItemProvider.dispose();
		if (hoehenlinie_Form_TypeClassItemProvider != null) hoehenlinie_Form_TypeClassItemProvider.dispose();
		if (hoehenlinie_Laenge_TypeClassItemProvider != null) hoehenlinie_Laenge_TypeClassItemProvider.dispose();
		if (hoehenpunktItemProvider != null) hoehenpunktItemProvider.dispose();
		if (hoehenpunkt_Allg_AttributeGroupItemProvider != null) hoehenpunkt_Allg_AttributeGroupItemProvider.dispose();
		if (hoehenpunkt_Datum_TypeClassItemProvider != null) hoehenpunkt_Datum_TypeClassItemProvider.dispose();
		if (hoehenpunkt_Hoehe_TypeClassItemProvider != null) hoehenpunkt_Hoehe_TypeClassItemProvider.dispose();
		if (hSystem_TypeClassItemProvider != null) hSystem_TypeClassItemProvider.dispose();
		if (knotenname_TypeClassItemProvider != null) knotenname_TypeClassItemProvider.dispose();
		if (neigung_TypeClassItemProvider != null) neigung_TypeClassItemProvider.dispose();
		if (oertlichkeitItemProvider != null) oertlichkeitItemProvider.dispose();
		if (oertlichkeit_Abkuerzung_TypeClassItemProvider != null) oertlichkeit_Abkuerzung_TypeClassItemProvider.dispose();
		if (oertlichkeit_Allg_AttributeGroupItemProvider != null) oertlichkeit_Allg_AttributeGroupItemProvider.dispose();
		if (oertlichkeit_Art_TypeClassItemProvider != null) oertlichkeit_Art_TypeClassItemProvider.dispose();
		if (oertlichkeit_Bezeichnung_AttributeGroupItemProvider != null) oertlichkeit_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (oertlichkeit_Gueltig_Ab_TypeClassItemProvider != null) oertlichkeit_Gueltig_Ab_TypeClassItemProvider.dispose();
		if (oertlichkeit_Gueltig_Bis_TypeClassItemProvider != null) oertlichkeit_Gueltig_Bis_TypeClassItemProvider.dispose();
		if (oertlichkeit_Kurzname_TypeClassItemProvider != null) oertlichkeit_Kurzname_TypeClassItemProvider.dispose();
		if (oertlichkeit_Langname_TypeClassItemProvider != null) oertlichkeit_Langname_TypeClassItemProvider.dispose();
		if (plan_Quelle_TypeClassItemProvider != null) plan_Quelle_TypeClassItemProvider.dispose();
		if (streckeItemProvider != null) streckeItemProvider.dispose();
		if (strecke_Bezeichnung_AttributeGroupItemProvider != null) strecke_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (strecke_Meter_TypeClassItemProvider != null) strecke_Meter_TypeClassItemProvider.dispose();
		if (strecke_PunktItemProvider != null) strecke_PunktItemProvider.dispose();
		if (tB_Art_TypeClassItemProvider != null) tB_Art_TypeClassItemProvider.dispose();
		if (tB_Beschreibung_TypeClassItemProvider != null) tB_Beschreibung_TypeClassItemProvider.dispose();
		if (technischer_BereichItemProvider != null) technischer_BereichItemProvider.dispose();
		if (technischer_PunktItemProvider != null) technischer_PunktItemProvider.dispose();
		if (toP_Anschluss_A_TypeClassItemProvider != null) toP_Anschluss_A_TypeClassItemProvider.dispose();
		if (toP_Anschluss_B_TypeClassItemProvider != null) toP_Anschluss_B_TypeClassItemProvider.dispose();
		if (toP_KanteItemProvider != null) toP_KanteItemProvider.dispose();
		if (toP_Kante_Allg_AttributeGroupItemProvider != null) toP_Kante_Allg_AttributeGroupItemProvider.dispose();
		if (toP_KnotenItemProvider != null) toP_KnotenItemProvider.dispose();
		if (toP_Laenge_TypeClassItemProvider != null) toP_Laenge_TypeClassItemProvider.dispose();
		if (tP_Art_TypeClassItemProvider != null) tP_Art_TypeClassItemProvider.dispose();
		if (tP_Beschreibung_TypeClassItemProvider != null) tP_Beschreibung_TypeClassItemProvider.dispose();
		if (ueberhoehungItemProvider != null) ueberhoehungItemProvider.dispose();
		if (ueberhoehung_Allg_AttributeGroupItemProvider != null) ueberhoehung_Allg_AttributeGroupItemProvider.dispose();
		if (ueberhoehung_Datum_TypeClassItemProvider != null) ueberhoehung_Datum_TypeClassItemProvider.dispose();
		if (ueberhoehung_Hoehe_TypeClassItemProvider != null) ueberhoehung_Hoehe_TypeClassItemProvider.dispose();
		if (ueberhoehungslinieItemProvider != null) ueberhoehungslinieItemProvider.dispose();
		if (ueberhoehungslinie_Allg_AttributeGroupItemProvider != null) ueberhoehungslinie_Allg_AttributeGroupItemProvider.dispose();
		if (ueberhoehungslinie_Form_TypeClassItemProvider != null) ueberhoehungslinie_Form_TypeClassItemProvider.dispose();
		if (ueberhoehungslinie_Laenge_TypeClassItemProvider != null) ueberhoehungslinie_Laenge_TypeClassItemProvider.dispose();
		if (v_Profil_Art_TypeClassItemProvider != null) v_Profil_Art_TypeClassItemProvider.dispose();
		if (wirkrichtung_TypeClassItemProvider != null) wirkrichtung_TypeClassItemProvider.dispose();
	}

}
