/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import org.eclipse.rwt.internal.application.RWTFactory;
import org.eclipse.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rwt.internal.textsize.Probe;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.FontUtil;

public class MeasurementUtil {
    public static Object getStartupProbeObject() {
        Object[] result = null;
        Probe[] probeList = RWTFactory.getProbeStore().getProbes();
        if (probeList.length > 0) {
            result = new Object[probeList.length];
            int i = 0;
            while (i < probeList.length) {
                result[i] = MeasurementUtil.createProbeParamObject(probeList[i]);
                ++i;
            }
        }
        return result;
    }

    static Object createItemParamObject(MeasurementItem item) {
        Object[] result = new Object[8];
        result[0] = item.hashCode();
        result[1] = item.getTextToMeasure();
        FontData fontData = item.getFontData();
        result[2] = ProtocolUtil.parseFontName(fontData.getName());
        result[3] = fontData.getHeight();
        result[4] = (fontData.getStyle() & 1) != 0;
        result[5] = (fontData.getStyle() & 2) != 0;
        result[6] = item.getWrapWidth();
        result[7] = MeasurementUtil.isMarkup(item.getMode());
        return result;
    }

    static Object createProbeParamObject(Probe probe) {
        Object[] result = new Object[6];
        FontData fontData = probe.getFontData();
        result[0] = fontData.hashCode();
        result[1] = probe.getText();
        result[2] = ProtocolUtil.parseFontName(fontData.getName());
        result[3] = fontData.getHeight();
        result[4] = (fontData.getStyle() & 1) != 0;
        result[5] = (fontData.getStyle() & 2) != 0;
        return result;
    }

    static void addItemToMeasure(String toMeasure, Font font, int wrapWidth, int mode) {
        FontData fontData = FontUtil.getData(font);
        MeasurementItem newItem = new MeasurementItem(toMeasure, fontData, wrapWidth, mode);
        MeasurementOperator.getInstance().addItemToMeasure(newItem);
    }

    private static boolean isMarkup(int mode) {
        return mode == 2;
    }

    private MeasurementUtil() {
    }
}

