/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.util;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.service.ContextProvider;

public final class URLHelper {
    public static final String EQUAL = "=";
    public static final String AMPERSAND = "&";
    public static final String QUESTION_MARK = "?";

    private URLHelper() {
    }

    public static String getServletName() {
        String result = ContextProvider.getRequest().getServletPath();
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    public static String getURLString() {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuilder result = new StringBuilder();
        result.append(URLHelper.getContextURLString());
        result.append(request.getServletPath());
        return result.toString();
    }

    public static String getContextURLString() {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuilder result = new StringBuilder();
        result.append(URLHelper.getServerURL());
        result.append(request.getContextPath());
        return result.toString();
    }

    public static void appendFirstParam(StringBuilder buffer, String key, String value) {
        buffer.append(QUESTION_MARK);
        buffer.append(key);
        buffer.append(EQUAL);
        buffer.append(value);
    }

    public static void appendParam(StringBuilder buffer, String key, String value) {
        buffer.append(AMPERSAND);
        buffer.append(key);
        buffer.append(EQUAL);
        buffer.append(value);
    }

    private static String getServerURL() {
        HttpServletRequest request = ContextProvider.getRequest();
        String port = URLHelper.createPortPattern(request);
        StringBuilder result = new StringBuilder();
        String serverName = request.getServerName();
        result.append(request.getScheme());
        result.append("://");
        result.append(serverName);
        result.append(port);
        return result.toString();
    }

    private static String createPortPattern(HttpServletRequest request) {
        String result = String.valueOf(request.getServerPort());
        if (result != null && !result.equals("")) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(":");
            buffer.append(result);
            result = buffer.toString();
        } else {
            result = "";
        }
        return result;
    }
}

