/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.karaf.features.host;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeatureState;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.eclipse.ecf.mgmt.SerializationUtil;
import org.eclipse.ecf.mgmt.framework.host.AbstractManager;
import org.eclipse.ecf.mgmt.karaf.features.FeatureEventMTO;
import org.eclipse.ecf.mgmt.karaf.features.FeatureInstallEventHandlerAsync;
import org.eclipse.ecf.mgmt.karaf.features.FeatureInstallManager;
import org.eclipse.ecf.mgmt.karaf.features.FeatureMTO;
import org.eclipse.ecf.mgmt.karaf.features.RepositoryEventMTO;
import org.eclipse.ecf.mgmt.karaf.features.RepositoryMTO;

public class FeatureInstallManagerHost
extends AbstractManager
implements FeatureInstallManager {
    private FeaturesService featuresService;
    protected List<FeatureInstallEventHandlerAsync> kfls = new ArrayList<FeatureInstallEventHandlerAsync>();
    protected FeaturesListener localFeaturesListener = new FeaturesListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void featureEvent(FeatureEvent event) {
            ArrayList<FeatureInstallEventHandlerAsync> notify = null;
            List<FeatureInstallEventHandlerAsync> list = FeatureInstallManagerHost.this.kfls;
            synchronized (list) {
                notify = new ArrayList<FeatureInstallEventHandlerAsync>(FeatureInstallManagerHost.this.kfls);
            }
            FeatureMTO fmto = FeatureInstallManagerHost.this.createFeatureMTO(event.getFeature());
            for (FeatureInstallEventHandlerAsync kfl : notify) {
                kfl.handleFeatureEventAsync(new FeatureEventMTO(FeatureInstallManagerHost.this.getFeatureEventType(event), fmto, event.isReplay()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repositoryEvent(RepositoryEvent event) {
            ArrayList<FeatureInstallEventHandlerAsync> notify = null;
            List<FeatureInstallEventHandlerAsync> list = FeatureInstallManagerHost.this.kfls;
            synchronized (list) {
                notify = new ArrayList<FeatureInstallEventHandlerAsync>(FeatureInstallManagerHost.this.kfls);
            }
            RepositoryMTO rmto = FeatureInstallManagerHost.this.createRepositoryMTO(event.getRepository());
            for (FeatureInstallEventHandlerAsync kfl : notify) {
                kfl.handleRepoEventAsync(new RepositoryEventMTO(FeatureInstallManagerHost.this.getRepositoryEventType(event), rmto, event.isReplay()));
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addFeaturesListener(FeatureInstallEventHandlerAsync async) {
        List<FeatureInstallEventHandlerAsync> list = this.kfls;
        synchronized (list) {
            return this.kfls.add(async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeFeaturesListener(FeatureInstallEventHandlerAsync async) {
        List<FeatureInstallEventHandlerAsync> list = this.kfls;
        synchronized (list) {
            return this.kfls.remove(async);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireFeatureEvent(FeatureEvent event) {
        ArrayList<FeatureInstallEventHandlerAsync> notify = null;
        List<FeatureInstallEventHandlerAsync> list = this.kfls;
        synchronized (list) {
            notify = new ArrayList<FeatureInstallEventHandlerAsync>(this.kfls);
        }
        FeatureMTO fmto = this.createFeatureMTO(event.getFeature());
        for (FeatureInstallEventHandlerAsync kfl : notify) {
            kfl.handleFeatureEventAsync(new FeatureEventMTO(this.getFeatureEventType(event), fmto, event.isReplay()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRepoEvent(RepositoryEvent event) {
        ArrayList<FeatureInstallEventHandlerAsync> notify = null;
        List<FeatureInstallEventHandlerAsync> list = this.kfls;
        synchronized (list) {
            notify = new ArrayList<FeatureInstallEventHandlerAsync>(this.kfls);
        }
        RepositoryMTO rmto = this.createRepositoryMTO(event.getRepository());
        for (FeatureInstallEventHandlerAsync kfl : notify) {
            kfl.handleRepoEventAsync(new RepositoryEventMTO(this.getRepositoryEventType(event), rmto, event.isReplay()));
        }
    }

    private int getFeatureEventType(FeatureEvent e) {
        return e.getType().equals((Object)FeatureEvent.EventType.FeatureInstalled) ? 1 : 2;
    }

    private int getRepositoryEventType(RepositoryEvent e) {
        return e.getType().equals((Object)RepositoryEvent.EventType.RepositoryAdded) ? 1 : 2;
    }

    private FeatureMTO createFeatureMTO(Feature f) {
        return new FeatureMTO(f.getId(), f.getName(), f.getNamespace(), f.getVersion(), f.getDescription(), f.getDetails(), f.hasVersion(), f.isHidden(), this.featuresService.isInstalled(f));
    }

    private RepositoryMTO createRepositoryMTO(Repository r) {
        try {
            return new RepositoryMTO(r.getName(), r.getURI(), r.getRepositories(), r.getResourceRepositories(), this.createFeatures(r.getFeatures()));
        }
        catch (Exception e) {
            this.logError("Exception creating RepositoryMTO for repository r=r", e);
            try {
                return new RepositoryMTO("unknown", new URI("none:none"), null, null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
    }

    protected void bindFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
        if (this.featuresService != null) {
            this.featuresService.registerListener(this.localFeaturesListener);
        }
    }

    protected void unbindFeaturesService(FeaturesService featuresService) {
        if (featuresService != null) {
            this.featuresService.unregisterListener(this.localFeaturesListener);
        }
        this.featuresService = null;
    }

    private Exception getSerializableException(Throwable t) {
        Throwable e = SerializationUtil.checkForSerializable((Throwable)t);
        if (e instanceof Exception) {
            return (Exception)e;
        }
        return new Exception(t);
    }

    public void validateRepository(URI uri) throws Exception {
        try {
            this.featuresService.validateRepository(uri);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void addRepository(URI uri) throws Exception {
        try {
            this.featuresService.addRepository(uri);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void addRepository(URI uri, boolean install) throws Exception {
        try {
            this.featuresService.addRepository(uri, install);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void removeRepository(URI uri) throws Exception {
        try {
            this.featuresService.removeRepository(uri);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void removeRepository(URI uri, boolean uninstall) throws Exception {
        try {
            this.featuresService.removeRepository(uri, uninstall);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void restoreRepository(URI uri) throws Exception {
        try {
            this.featuresService.restoreRepository(uri);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    protected FeatureMTO[] createFeatures(Feature[] features) {
        List result = this.selectAndMap(Arrays.asList(features), null, f -> this.createFeatureMTO((Feature)f));
        return result.toArray(new FeatureMTO[result.size()]);
    }

    protected RepositoryMTO[] createRepositoryMTOs(Repository[] repositories) {
        ArrayList<RepositoryMTO> result = new ArrayList<RepositoryMTO>();
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository r = repositoryArray[n2];
            try {
                result.add(this.createRepositoryMTO(r));
            }
            catch (Exception e) {
                this.logError("Exception creating RepositoryMTO for repository r=r", e);
            }
            ++n2;
        }
        return result.toArray(new RepositoryMTO[result.size()]);
    }

    protected RepositoryMTO createRepository(Repository repo) {
        return this.createRepositoryMTOs(new Repository[]{repo})[0];
    }

    public RepositoryMTO[] listRequiredRepositories() throws Exception {
        try {
            return this.createRepositoryMTOs(this.featuresService.listRequiredRepositories());
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public RepositoryMTO[] listRepositories() throws Exception {
        try {
            return this.createRepositoryMTOs(this.featuresService.listRepositories());
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public RepositoryMTO getRepository(String repoName) throws Exception {
        try {
            return this.createRepository(this.featuresService.getRepository(repoName));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public RepositoryMTO getRepository(URI uri) throws Exception {
        try {
            return this.createRepository(this.featuresService.getRepository(uri));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public String getRepositoryName(URI uri) throws Exception {
        try {
            return this.featuresService.getRepositoryName(uri);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void setResolutionOutputFile(String outputFile) {
        this.featuresService.setResolutionOutputFile(outputFile);
    }

    public void installFeature(String name) throws Exception {
        try {
            this.featuresService.installFeature(name);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    private EnumSet<FeaturesService.Option> createOptions(Set<Integer> options) {
        HashSet<FeaturesService.Option> result = new HashSet<FeaturesService.Option>();
        for (Integer i : options) {
            switch (i) {
                case 5: {
                    result.add(FeaturesService.Option.NoAutoManageBundles);
                    break;
                }
                case 3: {
                    result.add(FeaturesService.Option.NoAutoRefreshBundles);
                    break;
                }
                case 1: {
                    result.add(FeaturesService.Option.NoAutoRefreshManagedBundles);
                    break;
                }
                case 2: {
                    result.add(FeaturesService.Option.NoAutoRefreshUnmanagedBundles);
                    break;
                }
                case 4: {
                    result.add(FeaturesService.Option.NoAutoStartBundles);
                    break;
                }
                case 0: {
                    result.add(FeaturesService.Option.NoFailOnFeatureNotFound);
                }
            }
        }
        return EnumSet.copyOf(result);
    }

    public void installFeature(String name, Set<Integer> options) throws Exception {
        try {
            this.featuresService.installFeature(name, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void installFeature(String name, String version) throws Exception {
        try {
            this.featuresService.installFeature(name, version);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void installFeature(String name, String version, Set<Integer> options) throws Exception {
        try {
            this.featuresService.installFeature(name, version, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void installFeatures(Set<String> features, Set<Integer> options) throws Exception {
        try {
            this.featuresService.installFeatures(features, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void installFeatures(Set<String> features, String region, Set<Integer> options) throws Exception {
        try {
            this.featuresService.installFeatures(features, region, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void addRequirements(Map<String, Set<String>> requirements, Set<Integer> options) throws Exception {
        try {
            this.featuresService.addRequirements(requirements, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void uninstallFeature(String name, Set<Integer> options) throws Exception {
        try {
            this.featuresService.uninstallFeature(name, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void uninstallFeature(String name) throws Exception {
        try {
            this.featuresService.uninstallFeature(name);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void uninstallFeature(String name, String version, Set<Integer> options) throws Exception {
        try {
            this.featuresService.uninstallFeature(name, version, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void uninstallFeature(String name, String version) throws Exception {
        try {
            this.featuresService.uninstallFeature(name, version);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void uninstallFeatures(Set<String> features, Set<Integer> options) throws Exception {
        try {
            this.featuresService.uninstallFeatures(features, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void uninstallFeatures(Set<String> features, String region, Set<Integer> options) throws Exception {
        try {
            this.featuresService.uninstallFeatures(features, region, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void removeRequirements(Map<String, Set<String>> requirements, Set<Integer> options) throws Exception {
        try {
            this.featuresService.removeRequirements(requirements, this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    private FeatureState getFeatureState(Integer i) {
        switch (i) {
            case 17: {
                return FeatureState.Installed;
            }
            case 18: {
                return FeatureState.Resolved;
            }
            case 19: {
                return FeatureState.Started;
            }
            case 16: {
                return FeatureState.Uninstalled;
            }
        }
        return FeatureState.Installed;
    }

    private Map<String, Map<String, FeatureState>> getStateChanges(Map<String, Map<String, Integer>> stateChanges) {
        HashMap<String, Map<String, FeatureState>> result = new HashMap<String, Map<String, FeatureState>>();
        for (String key : stateChanges.keySet()) {
            Map<String, Integer> fs = stateChanges.get(key);
            HashMap<String, FeatureState> newfs = new HashMap<String, FeatureState>();
            for (String fskey : fs.keySet()) {
                newfs.put(fskey, this.getFeatureState(fs.get(fskey)));
            }
            result.put(key, newfs);
        }
        return result;
    }

    public void updateFeaturesState(Map<String, Map<String, Integer>> stateChanges, Set<Integer> options) throws Exception {
        try {
            this.featuresService.updateFeaturesState(this.getStateChanges(stateChanges), this.createOptions(options));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public FeatureMTO[] listFeatures() throws Exception {
        try {
            return this.createFeatures(this.featuresService.listFeatures());
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public FeatureMTO[] listRequiredFeatures() throws Exception {
        try {
            return this.createFeatures(this.featuresService.listRequiredFeatures());
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public FeatureMTO[] listInstalledFeatures() throws Exception {
        try {
            return this.createFeatures(this.featuresService.listInstalledFeatures());
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public Map<String, Set<String>> listRequirements() {
        return this.featuresService.listRequirements();
    }

    public boolean isRequired(FeatureMTO f) {
        try {
            return this.featuresService.isRequired(this.featuresService.getFeature(f.getId()));
        }
        catch (Exception e) {
            this.logError("Exception getting isRequired feature for featureMTO=" + f, e);
            return false;
        }
    }

    public boolean isInstalled(FeatureMTO f) {
        try {
            return this.featuresService.isInstalled(this.featuresService.getFeature(f.getId()));
        }
        catch (Exception e) {
            this.logError("Exception getting isInstalled feature for featureMTO=" + f, e);
            return false;
        }
    }

    public FeatureMTO getFeature(String name, String version) throws Exception {
        try {
            return this.createFeatures(new Feature[]{this.featuresService.getFeature(name, version)})[0];
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public FeatureMTO getFeature(String name) throws Exception {
        try {
            return this.createFeatures(new Feature[]{this.featuresService.getFeature(name)})[0];
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public FeatureMTO[] getFeatures(String name, String version) throws Exception {
        try {
            return this.createFeatures(this.featuresService.getFeatures(name, version));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public FeatureMTO[] getFeatures(String name) throws Exception {
        try {
            return this.createFeatures(this.featuresService.getFeatures(name));
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public void refreshRepository(URI uri) throws Exception {
        try {
            this.featuresService.refreshRepository(uri);
        }
        catch (Exception e) {
            throw this.getSerializableException(e);
        }
    }

    public URI getRepositoryUriFor(String name, String version) {
        return this.featuresService.getRepositoryUriFor(name, version);
    }

    public String[] getRepositoryNames() {
        return this.featuresService.getRepositoryNames();
    }

    public int getState(String featureId) {
        FeatureState fs = this.featuresService.getState(featureId);
        if (fs.equals((Object)FeatureState.Installed)) {
            return 17;
        }
        if (fs.equals((Object)FeatureState.Resolved)) {
            return 18;
        }
        if (fs.equals((Object)FeatureState.Started)) {
            return 19;
        }
        return 16;
    }
}

