/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Map;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractTopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;

public class BasicTopologyManagerImpl
extends AbstractTopologyManager
implements EndpointListener {
    private static final boolean allowLoopbackReference = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.discovery.allowLoopbackReference", "false"));
    private static final String defaultScope = System.getProperty("org.eclipse.ecf.osgi.services.discovery.endpointListenerScope");
    private static final boolean disableDiscovery = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.discovery.disableDiscovery", "false"));
    private String endpointListenerScope;
    private static final String ONLY_ECF_SCOPE = "(ecf.endpoint.id.ns=*)";
    private static final String NO_ECF_SCOPE = "(!(ecf.endpoint.id.ns=*))";

    BasicTopologyManagerImpl(BundleContext context) {
        super(context);
        if (defaultScope != null) {
            this.endpointListenerScope = defaultScope;
        }
        if (allowLoopbackReference) {
            this.endpointListenerScope = ONLY_ECF_SCOPE;
        } else {
            StringBuffer elScope = new StringBuffer("");
            elScope.append("(&(!(").append("endpoint.framework.uuid").append("=").append(this.getFrameworkUUID()).append("))");
            elScope.append(ONLY_ECF_SCOPE);
            elScope.append(")");
            this.endpointListenerScope = elScope.toString();
        }
    }

    String[] getScope() {
        return new String[]{this.endpointListenerScope, NO_ECF_SCOPE};
    }

    protected String getFrameworkUUID() {
        return super.getFrameworkUUID();
    }

    void exportRegisteredServices(String exportRegisteredSvcsClassname, String exportRegisteredSvcsFilter) {
        try {
            final ServiceReference[] existingServiceRefs = this.getContext().getAllServiceReferences(exportRegisteredSvcsClassname, exportRegisteredSvcsFilter);
            if (existingServiceRefs != null && existingServiceRefs.length > 0) {
                new Thread(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < existingServiceRefs.length) {
                            BasicTopologyManagerImpl.this.handleServiceRegistering(existingServiceRefs[i]);
                            ++i;
                        }
                    }
                }, "BasicTopologyManagerPreRegSrvExporter").start();
            }
        }
        catch (InvalidSyntaxException e) {
            this.logError("exportRegisteredServices", "Could not retrieve existing service references for exportRegisteredSvcsClassname=" + exportRegisteredSvcsClassname + " and exportRegisteredSvcsFilter=" + exportRegisteredSvcsFilter, e);
        }
    }

    public void endpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.endpointListenerScope)) {
            if (endpoint instanceof EndpointDescription) {
                this.handleECFEndpointAdded((EndpointDescription)endpoint);
            } else {
                this.handleNonECFEndpointAdded(this, endpoint);
            }
        } else if (matchedFilter.equals(NO_ECF_SCOPE)) {
            if (endpoint instanceof EndpointDescription) {
                this.handleECFEndpointAdded((EndpointDescription)endpoint);
            } else {
                this.advertiseEndpointDescription(endpoint);
            }
        }
    }

    public void endpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.endpointListenerScope)) {
            if (endpoint instanceof EndpointDescription) {
                this.handleECFEndpointRemoved((org.osgi.service.remoteserviceadmin.EndpointDescription)((EndpointDescription)endpoint));
            } else {
                this.handleNonECFEndpointRemoved(this, endpoint);
            }
        } else if (matchedFilter.equals(NO_ECF_SCOPE)) {
            if (endpoint instanceof EndpointDescription) {
                this.handleECFEndpointRemoved((org.osgi.service.remoteserviceadmin.EndpointDescription)((EndpointDescription)endpoint));
            } else {
                this.unadvertiseEndpointDescription(endpoint);
            }
        }
    }

    void event(ServiceEvent event, Map listeners) {
        this.handleEvent(event, listeners);
    }

    void handleRemoteAdminEvent(RemoteServiceAdminEvent event) {
        if (!(event instanceof RemoteServiceAdmin.RemoteServiceAdminEvent)) {
            return;
        }
        RemoteServiceAdmin.RemoteServiceAdminEvent rsaEvent = (RemoteServiceAdmin.RemoteServiceAdminEvent)event;
        int eventType = event.getType();
        EndpointDescription endpointDescription = rsaEvent.getEndpointDescription();
        if (disableDiscovery) {
            this.logWarning("handleRemoteAdminEvent", "discovery disabled.  RemoteServiceAdminEvent type=" + eventType + " description=" + endpointDescription);
            return;
        }
        switch (eventType) {
            case 2: {
                this.advertiseEndpointDescription(endpointDescription);
                break;
            }
            case 3: {
                this.unadvertiseEndpointDescription(endpointDescription);
                break;
            }
            case 6: {
                this.logError("handleExportError", "Export error with event=" + rsaEvent);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                this.logWarning("handleRemoteAdminEvent", "RemoteServiceAdminEvent=" + rsaEvent + " received with unrecognized type");
            }
        }
    }
}

