/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.internal.osgi.services.distribution.BasicTopologyManagerComponent;
import org.eclipse.ecf.internal.osgi.services.distribution.BasicTopologyManagerImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.service.log.LogService;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.distribution";
    public static final boolean autoCreateProxyContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.distribution.autoCreateProxyContainer", "true"));
    public static final boolean autoCreateHostContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.distribution.autoCreateHostContainer", "true"));
    public static final String defaultHostConfigType = System.getProperty("org.eclipse.ecf.osgi.services.distribution.defaultConfigType", "ecf.generic.server");
    private static final String PROP_USE_DS = "equinox.use.ds";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private BasicTopologyManagerImpl basicTopologyManagerImpl;
    private ServiceRegistration endpointListenerReg;
    private BasicTopologyManagerComponent basicTopologyManagerComp;
    private ServiceRegistration eventListenerHookRegistration;
    private ServiceRegistration eventAdminListenerRegistration;

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected LogService getLogService() {
        if (this.context == null) {
            return null;
        }
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        this.basicTopologyManagerImpl = new BasicTopologyManagerImpl(this.context);
        Properties props = new Properties();
        props.put("endpoint.listener.scope", this.basicTopologyManagerImpl.getScope());
        this.endpointListenerReg = this.getContext().registerService(EndpointListener.class.getName(), (Object)this.basicTopologyManagerImpl, (Dictionary)props);
        if (Boolean.valueOf(this.context.getProperty(PROP_USE_DS)).booleanValue()) {
            return;
        }
        String serviceName = EventListenerHook.class.getName();
        Filter serviceFilter = this.context.createFilter("(objectclass=" + serviceName + ")");
        ServiceReference[] refs = this.context.getBundle().getRegisteredServices();
        if (refs != null) {
            int i = 0;
            while (i < refs.length) {
                if (serviceFilter.match(refs[i])) {
                    return;
                }
                ++i;
            }
        }
        this.basicTopologyManagerComp = new BasicTopologyManagerComponent();
        this.basicTopologyManagerComp.bindEndpointListener(this.basicTopologyManagerImpl);
        this.eventAdminListenerRegistration = this.context.registerService(RemoteServiceAdminListener.class, (Object)this.basicTopologyManagerComp, null);
        this.eventListenerHookRegistration = this.context.registerService(EventListenerHook.class, (Object)this.basicTopologyManagerComp, null);
        this.basicTopologyManagerComp.activate();
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.eventListenerHookRegistration != null) {
            this.eventListenerHookRegistration.unregister();
            this.eventListenerHookRegistration = null;
        }
        if (this.basicTopologyManagerComp != null) {
            this.basicTopologyManagerComp.unbindEndpointListener(this.basicTopologyManagerImpl);
            this.basicTopologyManagerComp = null;
        }
        if (this.endpointListenerReg != null) {
            this.endpointListenerReg.unregister();
            this.endpointListenerReg = null;
        }
        if (this.eventAdminListenerRegistration != null) {
            this.eventAdminListenerRegistration.unregister();
            this.eventAdminListenerRegistration = null;
        }
        if (this.basicTopologyManagerImpl != null) {
            this.basicTopologyManagerImpl.close();
            this.basicTopologyManagerImpl = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        this.context = null;
        plugin = null;
    }
}

