/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.hello.host;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.ecf.examples.remoteservices.hello.impl.Hello;
import org.eclipse.ecf.internal.examples.remoteservices.hello.host.Activator;
import org.eclipse.ecf.internal.examples.remoteservices.hello.host.HelloCommandProvider;
import org.eclipse.ecf.osgi.services.distribution.IDistributionConstants;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HelloHostApplication
implements IApplication,
IDistributionConstants {
    private static final String DEFAULT_CONTAINER_TYPE = "ecf.r_osgi.peer";
    public static final String DEFAULT_CONTAINER_ID = "r-osgi://localhost:9278";
    private BundleContext bundleContext;
    private String containerType = "ecf.r_osgi.peer";
    private String containerId = "r-osgi://localhost:9278";
    private final Object appLock = new Object();
    private boolean done = false;
    private ServiceRegistration helloRegistration;
    private ServiceRegistration discoveryListenerRegistration;
    private ServiceRegistration distributionListenerRegistration;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Object start(IApplicationContext appContext) throws Exception {
        this.bundleContext = Activator.getContext();
        this.processArgs(appContext);
        this.registerHelloRemoteService();
        this.registerConsoleProvider();
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    void registerHelloRemoteService() {
        Properties props = new Properties();
        props.put("service.exported.interfaces", "*");
        props.put("service.exported.configs", this.containerType);
        props.put("ecf.exported.containerfactoryargs", this.containerId);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.examples.remoteservices.hello.IHello");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.helloRegistration = this.bundleContext.registerService(clazz.getName(), (Object)new Hello(), (Dictionary)props);
        System.out.println("Host: Hello Service Registered");
    }

    void unregisterHelloRemoteService() {
        if (this.helloRegistration != null) {
            this.helloRegistration.unregister();
            this.helloRegistration = null;
        }
        System.out.println("Host: Hello Remote Service Unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.unregisterHelloRemoteService();
        if (this.discoveryListenerRegistration != null) {
            this.discoveryListenerRegistration.unregister();
            this.discoveryListenerRegistration = null;
        }
        if (this.distributionListenerRegistration != null) {
            this.distributionListenerRegistration.unregister();
            this.distributionListenerRegistration = null;
        }
        this.bundleContext = null;
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.appLock.notifyAll();
        }
    }

    private void registerConsoleProvider() {
        HelloCommandProvider helloCommandProvider = new HelloCommandProvider(this);
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ((Dictionary)props).put("service.ranking", new Integer(2147483547));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.bundleContext.registerService(clazz.getName(), (Object)helloCommandProvider, props);
    }

    private void processArgs(IApplicationContext appContext) {
        String[] originalArgs = (String[])appContext.getArguments().get("application.args");
        if (originalArgs == null) {
            return;
        }
        int i = 0;
        while (i < originalArgs.length) {
            if (originalArgs[i].equals("-containerType")) {
                this.containerType = originalArgs[i + 1];
                ++i;
            } else if (originalArgs[i].equals("-containerId")) {
                this.containerId = originalArgs[i + 1];
                ++i;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

