/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share;

import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.events.IContainerConnectedEvent;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerTransaction;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContext;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectActivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectCreateResponseEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectDeactivatedEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectMessageEvent;
import org.eclipse.ecf.core.sharedobject.events.RemoteSharedObjectEvent;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.sharedobject.util.QueueException;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.example.collab.share.RemoteSharedObjectMsgEvent;
import org.eclipse.ecf.example.collab.share.SharedObjectMsg;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;

public class GenericSharedObject
implements ISharedObject {
    protected static final String ARGS_PROPERTY_NAME = "args";
    private static long replicateID = 0L;
    protected ISharedObjectConfig config;
    protected SharedObjectMsg currentMsg;
    protected ID currentMsgFromContainerID;
    protected ID currentMsgFromObjID;
    protected Hashtable msgMap;
    protected Object msgMapLock = new Object();
    ID localContainerID;

    protected static long getNextReplicateID() {
        return replicateID++;
    }

    public void activated(ID[] ids) {
        if (this.isHost()) {
            this.replicate(null);
        }
    }

    public void deactivated() {
    }

    public void destroyRemote(ID remoteID) throws IOException {
        this.getContext().sendDispose(remoteID);
    }

    public void destroySelf() {
        if (this.isHost()) {
            try {
                this.destroyRemote(null);
            }
            catch (IOException e) {
                this.log("Exception sending destroy message to remotes", e);
            }
        }
        this.destroySelfLocal();
    }

    public void destroySelfLocal() {
        this.getContext().getSharedObjectManager().removeSharedObject(this.getConfig().getSharedObjectID());
    }

    public void dispose(ID containerID) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execMsg(ID fromID, SharedObjectMsg msg) {
        try {
            MsgMap m = null;
            Object object = this.msgMapLock;
            synchronized (object) {
                m = this.msgMap == null ? null : this.msgMap.get(msg.getMethodName());
            }
            Object o = this;
            String methName = null;
            if (m != null) {
                if (m.obj != null) {
                    o = m.obj;
                }
                if (m.meth != null) {
                    methName = m.meth;
                }
            }
            if (methName != null) {
                msg = SharedObjectMsg.createMsg(msg.getClassName(), methName, msg.getArgs());
            }
            if (this.currentMsgFromObjID == null) {
                this.currentMsgFromObjID = this.getID();
            }
            this.currentMsgFromContainerID = fromID;
            this.currentMsg = msg;
            this.execMsgInvoke(msg, this.currentMsgFromObjID, o);
            this.currentMsg = null;
            this.currentMsgFromContainerID = null;
        }
        catch (Throwable e) {
            this.msgException(this, msg, e);
        }
    }

    protected void execMsgInvoke(SharedObjectMsg msg, ID fromID, Object o) throws Exception {
        if (msg == null || fromID == null || o == null) {
            return;
        }
        try {
            msg.invoke(o);
        }
        catch (NoSuchMethodException e) {
            msg.invokeFrom(fromID, o);
        }
    }

    protected void forwardMsgHome(SharedObjectMsg msg) throws IOException {
        this.forwardMsgTo(this.config.getHomeContainerID(), msg);
    }

    protected void forwardMsgTo(ID toID, SharedObjectMsg msg) throws IOException {
        this.getContext().sendMessage(toID, (Object)new RemoteSharedObjectMsgEvent(this.getID(), toID, msg));
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(ISharedObjectContainerTransaction.class) && this instanceof ISharedObjectContainerTransaction) {
            return this;
        }
        return null;
    }

    public ISharedObjectContext getContext() {
        return this.getConfig().getContext();
    }

    public ISharedObjectConfig getConfig() {
        return this.config;
    }

    protected ID getHomeContainerID() {
        return this.getConfig().getHomeContainerID();
    }

    public ID getID() {
        return this.getConfig().getSharedObjectID();
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID receiver) {
        return new ReplicaSharedObjectDescription(this.getClass(), this.getID(), this.getHomeContainerID(), this.getConfig().getProperties(), GenericSharedObject.getNextReplicateID());
    }

    protected void handleCreateResponse(ID fromID, Throwable t, Long identifier) {
    }

    public void handleEvent(Event event) {
        if (event instanceof ISharedObjectActivatedEvent) {
            ISharedObjectActivatedEvent ae = (ISharedObjectActivatedEvent)event;
            ID myID = this.getID();
            if (myID == null) {
                return;
            }
            if (myID.equals((Object)ae.getActivatedID())) {
                this.activated(this.getContext().getSharedObjectManager().getSharedObjectIDs());
            } else {
                this.otherActivated(ae.getActivatedID());
            }
        } else if (event instanceof ISharedObjectDeactivatedEvent) {
            ISharedObjectDeactivatedEvent ae = (ISharedObjectDeactivatedEvent)event;
            ID myID = this.getID();
            if (myID == null) {
                return;
            }
            if (myID.equals((Object)ae.getDeactivatedID())) {
                this.deactivated();
            } else {
                this.otherDeactivated(ae.getDeactivatedID());
            }
        } else if (event instanceof IContainerConnectedEvent) {
            this.memberAdded(((IContainerConnectedEvent)event).getTargetID());
        } else if (event instanceof IContainerDisconnectedEvent) {
            this.memberRemoved(((IContainerDisconnectedEvent)event).getTargetID());
        } else if (event instanceof ISharedObjectMessageEvent) {
            this.handleSharedObjectMessageEvent((ISharedObjectMessageEvent)event);
        }
    }

    protected void handleSharedObjectMessageEvent(ISharedObjectMessageEvent event) {
        if (event instanceof RemoteSharedObjectEvent) {
            if (event instanceof ISharedObjectCreateResponseEvent) {
                this.handleCreateResponseMessageEvent((ISharedObjectCreateResponseEvent)event);
            } else if (event instanceof RemoteSharedObjectMsgEvent) {
                this.handleSelfSendMessageEvent((RemoteSharedObjectMsgEvent)event);
            } else {
                RemoteSharedObjectMsgEvent me = (RemoteSharedObjectMsgEvent)((Object)event.getData());
                SharedObjectMsg msg = me.getMsg();
                this.execMsg(me.getRemoteContainerID(), msg);
            }
        }
    }

    protected void handleSelfSendMessageEvent(RemoteSharedObjectMsgEvent event) {
        this.execMsg(event.getRemoteContainerID(), event.getMsg());
    }

    protected void handleCreateResponseMessageEvent(ISharedObjectCreateResponseEvent event) {
        this.handleCreateResponse(event.getRemoteContainerID(), event.getException(), new Long(event.getSequence()));
    }

    public void handleEvents(Event[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleEvent(events[i]);
            ++i;
        }
    }

    public void handleRemoteData(ID spaceID, Serializable msg) {
        SharedObjectMsg aMsg = (SharedObjectMsg)msg;
        if (this.isReplicaMsgAllowed(spaceID, aMsg) != null) {
            this.execMsg(spaceID, aMsg);
        } else {
            this.ignoreReplicaMsg(spaceID, aMsg);
        }
    }

    protected void ignoreReplicaMsg(ID fromID, SharedObjectMsg msg) {
    }

    protected void ignoreSharedObjectMsg(ID fromID, SharedObjectMsg aMsg) {
    }

    public void init(ISharedObjectConfig initData) throws SharedObjectInitException {
        this.config = initData;
        this.localContainerID = this.getContext().getLocalContainerID();
    }

    public boolean isHost() {
        ID homeContainerID = this.getHomeContainerID();
        if (homeContainerID == null) {
            return false;
        }
        return homeContainerID.equals((Object)this.localContainerID);
    }

    protected Object isMsgAllowed(ID fromID, SharedObjectMsg aMsg) {
        return this;
    }

    protected Object isReplicaMsgAllowed(ID fromID, SharedObjectMsg aMsg) {
        return this;
    }

    public boolean isServer() {
        return this.getContext().isGroupManager();
    }

    public void memberAdded(ID member) {
        if (this.isHost()) {
            this.replicate(member);
        }
    }

    public void memberRemoved(ID member) {
    }

    public void msgException(Object target, SharedObjectMsg aMsg, Throwable e) {
        if (e != null) {
            e.printStackTrace(System.err);
        }
    }

    public void otherActivated(ID member) {
    }

    public void otherDeactivated(ID member) {
    }

    public void registerProxy(Object object, String msg) {
        this.registerProxy(object, msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerProxy(Object target, String msg, String method) {
        Assert.isNotNull((Object)msg);
        Assert.isNotNull((Object)target);
        Object object = this.msgMapLock;
        synchronized (object) {
            if (this.msgMap == null) {
                this.msgMap = new Hashtable();
            } else if (this.msgMap.containsKey(msg)) {
                throw new IllegalArgumentException("registerProxy:  proxy already registered for " + method + " by " + target);
            }
            this.msgMap.put(msg, new MsgMap(target, method));
        }
    }

    protected void replicate(ID remote) {
        try {
            ID[] group = this.getContext().getGroupMemberIDs();
            if (group == null || group.length < 1) {
                return;
            }
            ReplicaSharedObjectDescription createInfo = this.getReplicaDescription(remote);
            if (createInfo == null) {
                return;
            }
            this.getContext().sendCreate(remote, createInfo);
        }
        catch (IOException e) {
            this.log("Exception in replicate", e);
        }
    }

    protected void sendSelf(SharedObjectMsg msg) {
        IQueueEnqueue queue = this.getContext().getQueue();
        try {
            queue.enqueue((Event)new RemoteSharedObjectMsgEvent(this.getID(), this.getContext().getLocalContainerID(), msg));
        }
        catch (QueueException e) {
            this.log("QueueException enqueing message to self", e);
        }
    }

    public void sharedObjectMsg(ID fromID, SharedObjectMsg msg) {
        if (this.isMsgAllowed(fromID, msg) != null) {
            this.currentMsgFromObjID = fromID;
            this.execMsg(this.localContainerID, msg);
            this.currentMsgFromObjID = null;
        } else {
            this.ignoreSharedObjectMsg(fromID, msg);
        }
    }

    protected void trace(String msg) {
    }

    protected void log(String msg, Throwable t) {
        ClientPlugin.log(msg, t);
    }

    public ID createObject(ID target, ReplicaSharedObjectDescription desc) throws Exception {
        if (target == null) {
            if (desc.getID() == null) {
                desc.setID(IDFactory.getDefault().createStringID(this.getUniqueString()));
            }
            try {
                return this.getContext().getSharedObjectManager().createSharedObject((SharedObjectDescription)desc);
            }
            catch (Exception e) {
                this.log("Exception creating replicated object", e);
                throw e;
            }
        }
        throw new Exception("Cannot send object creation request direct to target");
    }

    public String getUniqueString() {
        return String.valueOf(new SecureRandom().nextLong());
    }

    protected static final class MsgMap {
        String meth;
        Object obj;

        MsgMap(Object o, String m) {
            this.obj = o;
            this.meth = m;
        }

        public Object getObject() {
            return this.obj;
        }
    }
}

