/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc006;

import java.io.IOException;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.EmbeddedValue;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XHtmlContentAdapter;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XHtmlContentAdapterFactory;
import org.eclipse.rmf.tests.reqif10.serialization.util.SimpleModelBuilder;

public class RichTextModelBuilder
extends SimpleModelBuilder {
    private static final ReqIF10Factory factory = ReqIF10Factory.eINSTANCE;
    private static GregorianCalendar DATE = new GregorianCalendar(2014, 8, 1);
    private DatatypeDefinitionString t_kind;
    private DatatypeDefinitionXHTML t_xhtml;
    private DatatypeDefinitionEnumeration t_recommended;
    private DatatypeDefinitionString t_description;
    private AttributeDefinitionString ad_kind;
    private AttributeDefinitionXHTML ad_xhtml;
    private AttributeDefinitionEnumeration ad_recommended;
    private AttributeDefinitionString ad_description;
    private SpecObjectType specObjecttype;
    private SpecificationType specType;

    public RichTextModelBuilder() throws Exception {
        super("rich-test", "XHTML Test");
        this.getReqIF().getTheHeader().setCreationTime(DATE);
    }

    @Override
    public void createDatatypes() throws Exception {
        this.createDatatypeKind();
        this.createDatatypeXHTML();
        this.createDatatypeRecommended();
        this.createDatatypeDescription();
    }

    private void createDatatypeKind() throws Exception {
        this.t_kind = factory.createDatatypeDefinitionString();
        this.t_kind.setLongName("T_Kind");
        this.t_kind.setIdentifier("T_Kind");
        this.t_kind.setLastChange(DATE);
        this.t_kind.setMaxLength(new BigInteger("1000"));
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_kind);
    }

    private void createDatatypeXHTML() throws Exception {
        this.t_xhtml = factory.createDatatypeDefinitionXHTML();
        this.t_xhtml.setLongName("T_Xhtml");
        this.t_xhtml.setIdentifier("T_Xhtml");
        this.t_xhtml.setLastChange(DATE);
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_xhtml);
    }

    private void createDatatypeRecommended() throws Exception {
        this.t_recommended = factory.createDatatypeDefinitionEnumeration();
        this.t_recommended.setLongName("T_Recommended");
        this.t_recommended.setIdentifier("T_Recommended");
        this.t_recommended.setLastChange(DATE);
        this.addEnum(this.t_recommended, 1L, "Recommended");
        this.addEnum(this.t_recommended, 2L, "---");
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_recommended);
    }

    private void createDatatypeDescription() throws Exception {
        this.t_description = factory.createDatatypeDefinitionString();
        this.t_description.setLongName("T_Description");
        this.t_description.setIdentifier("T_Description");
        this.t_description.setLastChange(DATE);
        this.t_description.setMaxLength(new BigInteger("1000"));
        this.getReqIF().getCoreContent().getDatatypes().add((Object)this.t_description);
    }

    @Override
    public void createSpecObjectTypes() throws Exception {
        this.specObjecttype = factory.createSpecObjectType();
        this.specObjecttype.setIdentifier("RequirementType");
        this.specObjecttype.setLastChange(DATE);
        this.specObjecttype.setLongName("RequirementType");
        this.createKindDefinition();
        this.createXhtmlDefinition();
        this.createRecommendedDefinition();
        this.createDescriptionDefinition();
        this.getReqIF().getCoreContent().getSpecTypes().add((Object)this.specObjecttype);
    }

    private void createKindDefinition() {
        this.ad_kind = factory.createAttributeDefinitionString();
        this.ad_kind.setLongName("Kind");
        this.ad_kind.setIdentifier("Kind");
        this.ad_kind.setLastChange(DATE);
        this.ad_kind.setType(this.t_kind);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_kind);
    }

    private void createXhtmlDefinition() {
        this.ad_xhtml = factory.createAttributeDefinitionXHTML();
        this.ad_xhtml.setLongName("ReqIF.Text");
        this.ad_xhtml.setIdentifier("ReqIF.Text");
        this.ad_xhtml.setLastChange(DATE);
        this.ad_xhtml.setType(this.t_xhtml);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_xhtml);
    }

    private void createRecommendedDefinition() {
        this.ad_recommended = factory.createAttributeDefinitionEnumeration();
        this.ad_recommended.setLongName("Recommended");
        this.ad_recommended.setIdentifier("Recommended");
        this.ad_recommended.setLastChange(DATE);
        this.ad_recommended.setType(this.t_recommended);
        this.ad_recommended.setMultiValued(false);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_recommended);
    }

    private void createDescriptionDefinition() {
        this.ad_description = factory.createAttributeDefinitionString();
        this.ad_description.setLongName("Description");
        this.ad_description.setIdentifier("Description");
        this.ad_description.setLastChange(DATE);
        this.ad_description.setType(this.t_description);
        this.specObjecttype.getSpecAttributes().add((Object)this.ad_description);
    }

    @Override
    public void createSpecObjects() throws Exception {
        this.createSpecObject("so-01", "Bold Text", RichTextModelBuilder.getXhtmlContent("<div><b>Bold</b></div>"), true, "(standard element for bold in XHTML). Represented by using the <b> element.");
        this.createSpecObject("so-02", "Bold Text", RichTextModelBuilder.getXhtmlContent("<div><strong>Bold</strong></div>"), false, "Represented by using the <strong> element.");
        this.createSpecObject("so-03", "Italic Text", RichTextModelBuilder.getXhtmlContent("<div><i>Italic</i></div>"), true, "Represented by using the <i> element.");
        this.createSpecObject("so-04", "Italic Text", RichTextModelBuilder.getXhtmlContent("<div><em>Italic</em></div>"), false, "Represented by using the <em> element.");
        this.createSpecObject("so-05", "Italic Text", RichTextModelBuilder.getXhtmlContent("<div><cite>Italic</cite></div>"), false, "Represented by using the <cite> element.");
        this.createSpecObject("so-06", "Underlined Text", RichTextModelBuilder.getXhtmlContent("<div><span style='text-decoration:underline;'>Underlined</span></div>"), true, "Represented by using the style attribute set to text-decoration:underline.");
        this.createSpecObject("so-07", "Underlined Text", RichTextModelBuilder.getXhtmlContent("<div><ins>Underlined</ins></div>"), false, "Represented by using the <ins> element.");
        this.createSpecObject("so-08", "Strike Through Text", RichTextModelBuilder.getXhtmlContent("<div><span style='text-decoration:line-through;'>Strike Through</span></div>"), true, "(recommended by ReqIF standard). Represented by using the style attribute set to text-decoration:line-through.");
        this.createSpecObject("so-09", "Strike Through Text", RichTextModelBuilder.getXhtmlContent("<div><del>Strike Through</del></div>"), false, "Represented by using the <del> element.");
        this.createSpecObject("so-10", "Superscript Text", RichTextModelBuilder.getXhtmlContent("<div>Normal<sup>Superscript</sup></div>"), true, "(standard XHTML). Represented by using the <sup> element.");
        this.createSpecObject("so-11", "Subscript Text", RichTextModelBuilder.getXhtmlContent("<div>Normal<sub>Subscript</sub></div>"), true, "(standard XHTML). Represented by using the <sub> element.");
        this.createSpecObject("so-12", "Indentation", RichTextModelBuilder.getXhtmlContent("<div>The second line<blockquote><div>is indented,<blockquote><div>the third line is indented even further.</div></blockquote></div></blockquote></div>"), true, "Represented by using <blockquote> elements. Simple, straight-forward solution that is compatible with ReqIF1.1. It explicitly uses XHTML elements and therefore can be easily processed by XML parsers.");
        this.createSpecObject("so-13", "Indentation", RichTextModelBuilder.getXhtmlContent("<div><div>The second line</div><div style='margin-left:10px;'>is indented 10 pixels,</div><div style='margin-left:20px;'>the third line is indented 20 pixels.</div></div>"), false, "Represented by using the style attribute set to margin-left:<indentation>.");
        this.createSpecObject("so-14", "Unordered List", RichTextModelBuilder.getXhtmlContent("<div><ul><li>First Bullet Point</li><li>Second Bullet Point</li><li>Third Bullet Point</li></ul></div>"), true, "(standard XHTML). Represented by using the <ul> and <li> elements.");
        this.createSpecObject("so-15", "Ordered List", RichTextModelBuilder.getXhtmlContent("<div><ol><li>Number One</li><li>Number Two</li><li>Number Three</li></ol></div>"), true, "(standard XHTML). Represented by using the <ol> and <li> elements.");
        this.createSpecObject("so-16", "Colored Text", RichTextModelBuilder.getXhtmlContent("<div><span style='color:red;'>Red</span></div>"), true, "(recommended by ReqIF standard). Represented by using the style attribute set to color:<color>");
    }

    private void createSpecObject(String id, String kind, XhtmlContent xhtml, boolean recommended, String description) throws Exception {
        SpecObject obj = factory.createSpecObject();
        obj.setIdentifier(id);
        obj.setLongName("SpecObject: " + id);
        obj.setLastChange(DATE);
        obj.setType(this.specObjecttype);
        this.getReqIF().getCoreContent().getSpecObjects().add((Object)obj);
        AttributeValueString kindAV = factory.createAttributeValueString();
        kindAV.setDefinition(this.ad_kind);
        kindAV.setTheValue(kind);
        obj.getValues().add((Object)kindAV);
        AttributeValueXHTML xhtmlAV = factory.createAttributeValueXHTML();
        xhtmlAV.setDefinition(this.ad_xhtml);
        xhtmlAV.setTheValue(xhtml);
        obj.getValues().add((Object)xhtmlAV);
        AttributeValueEnumeration recommendedAV = factory.createAttributeValueEnumeration();
        recommendedAV.setDefinition(this.ad_recommended);
        if (recommended) {
            recommendedAV.getValues().add((Object)((EnumValue)this.t_recommended.getSpecifiedValues().get(0)));
        } else {
            recommendedAV.getValues().add((Object)((EnumValue)this.t_recommended.getSpecifiedValues().get(1)));
        }
        obj.getValues().add((Object)recommendedAV);
        AttributeValueString descriptionAV = factory.createAttributeValueString();
        descriptionAV.setDefinition(this.ad_description);
        descriptionAV.setTheValue(description);
        obj.getValues().add((Object)descriptionAV);
    }

    @Override
    public void createSpecificationTypes() throws Exception {
        this.specType = factory.createSpecificationType();
        this.specType.setIdentifier("specType");
        this.specType.setLongName("specType");
        this.specType.setLastChange(DATE);
        this.getReqIF().getCoreContent().getSpecTypes().add((Object)this.specType);
    }

    @Override
    public void createSpecifications() throws Exception {
        Specification spec = factory.createSpecification();
        spec.setIdentifier("specification");
        spec.setLongName("specification");
        spec.setLastChange(DATE);
        spec.setType(this.specType);
        this.getReqIF().getCoreContent().getSpecifications().add((Object)spec);
        for (SpecObject object : this.getReqIF().getCoreContent().getSpecObjects()) {
            SpecHierarchy sh = factory.createSpecHierarchy();
            sh.setObject(object);
            sh.setIdentifier("sh-" + object.getIdentifier());
            sh.setLongName("sh-" + object.getIdentifier());
            sh.setLastChange(DATE);
            spec.getChildren().add((Object)sh);
        }
    }

    private void addEnum(DatatypeDefinitionEnumeration enumeration, long key, String value) {
        EnumValue enumValue = factory.createEnumValue();
        enumValue.setIdentifier("id-" + key);
        enumValue.setLongName(value);
        enumValue.setLastChange(DATE);
        EmbeddedValue embeddedValue = factory.createEmbeddedValue();
        embeddedValue.setKey(BigInteger.valueOf(key));
        embeddedValue.setOtherContent("otherContent-" + key);
        enumValue.setProperties(embeddedValue);
        enumeration.getSpecifiedValues().add((Object)enumValue);
    }

    public static XhtmlContent getXhtmlContent(String html) throws IOException {
        ReqIF10XHtmlContentAdapterFactory factory = new ReqIF10XHtmlContentAdapterFactory();
        XhtmlContent xhtmlContent = ReqIF10Factory.eINSTANCE.createXhtmlContent();
        ReqIF10XHtmlContentAdapter adapter = (ReqIF10XHtmlContentAdapter)factory.adapt((Notifier)xhtmlContent, ReqIF10XHtmlContentAdapter.class);
        adapter.setXhtmlString(html);
        return xhtmlContent;
    }
}

