/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.pror.provider.VirtualSpecTypeItemProvider;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.provider.IdentifiableTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SpecTypeTest
extends IdentifiableTest {
    private ReqIF reqif;

    @Before
    public void setupReqif() throws URISyntaxException {
        this.reqif = this.getTestReqif("simple.reqif");
    }

    protected SpecType getFixture() {
        return (SpecType)this.fixture;
    }

    @Test
    public void testAttributeDefinitionChanges() {
        AttributeDefinitionString ad = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        this.getFixture().getSpecAttributes().add((Object)ad);
        ItemProviderAdapter ip = this.getItemProvider(this.getFixture());
        ip.addListener(this.listener);
        this.setViaCommand(ad, (EStructuralFeature)ReqIF10Package.Literals.IDENTIFIABLE__LONG_NAME, "New Name");
        Assert.assertEquals((long)1L, (long)this.notifications.size());
    }

    @Test
    public void testParentIsVirtual() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        this.getItemProvider(reqif.getCoreContent()).getChildren((Object)reqif.getCoreContent());
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_TYPES, this.getFixture());
        ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)this.getFixture());
        Assert.assertTrue((boolean)(ip.getParent((Object)this.getFixture()) instanceof VirtualSpecTypeItemProvider));
    }

    @Test
    public void testSetLastChangeAfterCreation() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        SpecType id = this.getFixture();
        this.setViaCommand(reqif.getCoreContent(), (EStructuralFeature)ReqIF10Package.eINSTANCE.getReqIFContent_SpecTypes(), id);
        junit.framework.Assert.assertNotNull((Object)id.getLastChange());
    }

    protected EStructuralFeature getParentFeature() {
        return ReqIF10Package.eINSTANCE.getReqIFContent_SpecTypes();
    }

    protected EObject getParent() {
        return this.reqif.getCoreContent();
    }
}

