/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.testframework;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.rmf.ext.prostep.util.ProstepAdapterFactory;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.pror.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.rmf.reqif10.pror.configuration.util.ConfigurationAdapterFactory;
import org.eclipse.rmf.reqif10.pror.provider.ReqIF10ItemProviderAdapterFactory;
import org.eclipse.rmf.reqif10.pror.testdata.TestData;
import org.eclipse.rmf.reqif10.pror.testframework.Filter;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceImpl;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingResourceSetImpl;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractItemProviderTest {
    public ComposedAdapterFactory adapterFactory;
    public AdapterFactoryEditingDomain editingDomain;
    public BasicCommandStack commandStack;
    public INotifyChangedListener listener;
    public List<Notification> notifications = new ArrayList<Notification>();
    private Filter filter;

    @Before
    public void setupAbstractItemProviderTest() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ConfigurationAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReqIF10ItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ConfigurationItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ProstepAdapterFactory());
        this.commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)this.commandStack, (ResourceSet)new XMLPersistenceMappingResourceSetImpl());
        this.editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
        this.listener = new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                if (AbstractItemProviderTest.this.filter != null && !AbstractItemProviderTest.this.filter.accept(notification)) {
                    return;
                }
                AbstractItemProviderTest.this.notifications.add(notification);
            }
        };
    }

    @After
    public void teardownAbstractItemProviderTest() {
        this.adapterFactory = null;
        this.editingDomain = null;
        this.commandStack = null;
        this.listener = null;
        this.filter = null;
        this.notifications = new ArrayList<Notification>();
    }

    public void setListenerFilter(Filter filter) {
        this.filter = filter;
    }

    public ReqIF getTestReqif(String filename) throws URISyntaxException {
        URI resourceURI = TestData.getURI(filename);
        Resource resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        ReqIF reqif = (ReqIF)resource.getContents().get(0);
        return reqif;
    }

    public ItemProviderAdapter getItemProvider(Object obj) {
        return (ItemProviderAdapter)this.adapterFactory.adapt(obj, IItemLabelProvider.class);
    }

    protected void setViaCommand(Object object, EStructuralFeature feature, Object value) {
        Command cmd;
        ItemProviderAdapter ip = this.getItemProvider(object);
        if (feature.isMany()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            cmd = ip.createCommand(object, (EditingDomain)this.editingDomain, AddCommand.class, new CommandParameter(object, (Object)feature, list));
        } else {
            cmd = ip.createCommand(object, (EditingDomain)this.editingDomain, SetCommand.class, new CommandParameter(object, (Object)feature, value));
        }
        this.commandStack.execute(cmd);
    }

    protected void removeViaCommand(Object object, EStructuralFeature feature, Object value) {
        Command cmd;
        ItemProviderAdapter ipad = this.getItemProvider(object);
        if (feature.isMany()) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            cmd = ipad.createCommand(object, (EditingDomain)this.editingDomain, RemoveCommand.class, new CommandParameter(object, (Object)feature, list));
        } else {
            cmd = ipad.createCommand(object, (EditingDomain)this.editingDomain, SetCommand.class, new CommandParameter(object, (Object)feature, null));
        }
        this.commandStack.execute(cmd);
    }

    public void dumpEObjectToConsole(EObject eobj) throws IOException {
        Resource resource = eobj.eResource();
        if (resource == null) {
            File tempFile = File.createTempFile("reqif", ".reqif");
            tempFile.deleteOnExit();
            URI fileURI = URI.createFileURI((String)tempFile.getAbsolutePath());
            resource = this.editingDomain.getResourceSet().createResource(fileURI);
        }
        ((ReqIF10ResourceImpl)resource).setIsLoading(true);
        resource.getContents().add((Object)eobj);
        resource.save((OutputStream)System.out, null);
    }
}

