/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.common.util.ProrXhtmlSimplifiedHelper;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.common.util.ReqIF10XhtmlUtil;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.UnifiedColumn;
import org.eclipse.rmf.reqif10.pror.editor.IReqifEditor;
import org.eclipse.rmf.reqif10.pror.editor.ISpecificationEditor;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.IProrCellRenderer;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProrEditorUtil {
    private static String createHtmlHeader(Specification spec, AdapterFactory adapterFactory) {
        StringBuilder sb = new StringBuilder();
        String title = ConfigurationUtil.getSpecElementLabel((SpecElementWithAttributes)spec, (AdapterFactory)adapterFactory);
        sb.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
        sb.append("<meta name=\"GENERATOR\" content=\"ProR (www.pror.org)\">\n");
        sb.append("<title>" + title + "</title>\n");
        sb.append("<style type=\"text/css\">\n");
        sb.append("body {font-family: Arial, sans-serif;}\n");
        sb.append("h1 {text-align: center;}\n");
        sb.append("table, th, td { border-bottom: 1px solid #cccccc; }\n");
        sb.append("td { padding: 2pt; }\n");
        sb.append("table { border-collapse: collapse; }");
        sb.append("</style>\n");
        sb.append("</head>\n\n");
        sb.append("<body>\n");
        sb.append("<h1>" + title + "</h1>\n");
        return sb.toString();
    }

    private static String getDefaultValue(AttributeValue av) {
        String textValue;
        Object value;
        Object object = value = av == null ? null : ReqIF10Util.getTheValue((AttributeValue)av);
        if (value == null) {
            textValue = "";
        } else if (value instanceof List) {
            textValue = "";
            Iterator i = ((List)value).iterator();
            while (i.hasNext()) {
                EnumValue enumValue = (EnumValue)i.next();
                textValue = String.valueOf(textValue) + enumValue.getLongName();
                if (!i.hasNext()) continue;
                textValue = String.valueOf(textValue) + ", ";
            }
        } else if (value instanceof XhtmlContent) {
            textValue = ProrXhtmlSimplifiedHelper.xhtmlToSimplifiedString((XhtmlContent)((XhtmlContent)value));
            try {
                String xhtmlString = ReqIF10XhtmlUtil.getXhtmlString((XhtmlContent)((XhtmlContent)value));
                xhtmlString = xhtmlString.replace("<xhtml:", "<");
                textValue = xhtmlString = xhtmlString.replace("</xhtml:", "</");
            }
            catch (IOException iOException) {}
        } else if (value instanceof GregorianCalendar) {
            GregorianCalendar cal = (GregorianCalendar)value;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MMM-dd hh:mm:ss z");
            textValue = formatter.format(cal.getTime());
        } else {
            textValue = value.toString();
        }
        return textValue;
    }

    private static void printRecursive(StringBuilder html, ProrSpecViewConfiguration config, int indent, EList<SpecHierarchy> children, AdapterFactory adapterFactory) {
        for (SpecHierarchy child : children) {
            if (child.getObject() != null) {
                SpecObject specObject = child.getObject();
                boolean first = true;
                html.append("<tr>");
                for (Column col : config.getColumns()) {
                    DatatypeDefinition dd;
                    ProrPresentationConfiguration configuration;
                    ItemProviderAdapter itemProvider;
                    AttributeValue av;
                    html.append("<td valign='top'>");
                    if (first) {
                        html.append("<div style='margin-left: " + indent * 20 + "px;'>");
                    }
                    if (col instanceof UnifiedColumn) {
                        av = ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specObject, (String)"ReqIF.Text");
                        if (av == null || ReqIF10Util.getTheValue((AttributeValue)av) == null) {
                            av = ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specObject, (String)"ReqIF.ChapterName");
                        }
                    } else {
                        av = ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)specObject, (String)col.getLabel());
                    }
                    if ((itemProvider = ProrUtil.getItemProvider((AdapterFactory)adapterFactory, (Object)(configuration = ConfigurationUtil.getPresentationConfiguration((DatatypeDefinition)(dd = ReqIF10Util.getDatatypeDefinition((AttributeValue)av)))))) instanceof PresentationEditorInterface) {
                        PresentationEditorInterface presentationEditor = (PresentationEditorInterface)itemProvider;
                        IProrCellRenderer renderer = presentationEditor.getCellRenderer(av);
                        if (renderer != null) {
                            String content = renderer.doDrawHtmlContent(av);
                            if (content != null) {
                                html.append(content);
                            } else {
                                html.append(ProrEditorUtil.getDefaultValue(av));
                            }
                        }
                    } else {
                        html.append(ProrEditorUtil.getDefaultValue(av));
                    }
                    if (first) {
                        first = false;
                        html.append("</div>");
                    }
                    html.append("</td>");
                }
                html.append("</tr>\n");
            }
            ProrEditorUtil.printRecursive(html, config, indent + 1, (EList<SpecHierarchy>)child.getChildren(), adapterFactory);
        }
    }

    public static String createHtmlContent(Specification spec, EditingDomain domain, AdapterFactory adapterFactory) {
        ProrSpecViewConfiguration config = ConfigurationUtil.createSpecViewConfiguration((Specification)spec, (EditingDomain)domain);
        StringBuilder html = new StringBuilder();
        html.append(ProrEditorUtil.createHtmlHeader(spec, adapterFactory));
        html.append("<table><tr>");
        EList cols = config.getColumns();
        for (Column col : cols) {
            html.append("<td><b>" + col.getLabel() + "</b></td>");
        }
        html.append("</tr>\n");
        ProrEditorUtil.printRecursive(html, config, 0, (EList<SpecHierarchy>)spec.getChildren(), adapterFactory);
        html.append("</table>");
        return html.toString();
    }

    public static Command getAffectedObjectCommand(final Object element, Command cmd) {
        return new CommandWrapper(cmd){

            public Collection<?> getAffectedObjects() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(element);
                return list;
            }
        };
    }

    public static IEditorPart getEditor(EObject eObject) {
        IEditorReference[] eRefs;
        ReqIF reqif = null;
        Specification spec = null;
        while (eObject != null) {
            if (eObject instanceof Specification) {
                spec = (Specification)eObject;
            }
            if (eObject instanceof ReqIF) {
                reqif = (ReqIF)eObject;
                break;
            }
            eObject = eObject.eContainer();
        }
        if (reqif == null) {
            return null;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = eRefs = activePage.getEditorReferences();
        int n = eRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IReqifEditor reqifEditor;
            ISpecificationEditor specEditor;
            IEditorReference eRef = iEditorReferenceArray[n2];
            IEditorPart editor = eRef.getEditor(false);
            if (editor instanceof ISpecificationEditor && (specEditor = (ISpecificationEditor)editor).getSpecification().equals(spec)) {
                return specEditor;
            }
            if (editor instanceof IReqifEditor && (reqifEditor = (IReqifEditor)editor).getReqif().equals(reqif)) {
                if (spec == null) {
                    return reqifEditor;
                }
                return reqifEditor.openSpecEditor(spec);
            }
            ++n2;
        }
        return null;
    }
}

