/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.UUID;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.ReqIFHeader;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.common.util.ReqIFToolExtensionUtil;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationFactory;
import org.eclipse.rmf.reqif10.pror.configuration.LabelConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrGeneralConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.ProrToolExtension;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.provider.Reqif10EditPlugin;
import org.eclipse.rmf.reqif10.serialization.ReqIF10ResourceFactoryImpl;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingResourceSetImpl;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reqif10ModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(Reqif10EditorPlugin.INSTANCE.getString("_UI_Reqif10EditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = Reqif10EditorPlugin.INSTANCE.getString("_UI_Reqif10EditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected ReqIF10Package reqif10Package = ReqIF10Package.eINSTANCE;
    protected ReqIF10Factory reqif10Factory = this.reqif10Package.getReqIF10Factory();
    protected Reqif10ModelWizardNewFileCreationPage newFileCreationPage;
    protected Reqif10ModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Reqif10EditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(Reqif10EditorPlugin.INSTANCE.getImage("full/wizban/NewReqif10.png")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.reqif10Package.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        ReqIF root = this.reqif10Factory.createReqIF();
        ReqIFHeader header = this.reqif10Factory.createReqIFHeader();
        root.setTheHeader(header);
        GregorianCalendar reqIFLastChange = ReqIF10Util.getReqIFLastChange();
        header.setCreationTime(reqIFLastChange);
        header.setSourceToolId("ProR (http://pror.org)");
        header.setIdentifier("rmf-" + UUID.randomUUID());
        header.setReqIFVersion("1.0.1");
        header.setReqIFToolId("ProR (http://pror.org)");
        header.setComment("Created by: " + System.getProperty("user.name"));
        ReqIFContent content = this.reqif10Factory.createReqIFContent();
        root.setCoreContent(content);
        DatatypeDefinitionString ddString = this.reqif10Factory.createDatatypeDefinitionString();
        ddString.setLongName("T_String32k");
        ddString.setMaxLength(new BigInteger("32000"));
        ddString.setLastChange(reqIFLastChange);
        content.getDatatypes().add((Object)ddString);
        SpecObjectType specObjectType = this.reqif10Factory.createSpecObjectType();
        specObjectType.setLongName("Requirement Type");
        specObjectType.setLastChange(reqIFLastChange);
        content.getSpecTypes().add((Object)specObjectType);
        AttributeDefinitionString ad1 = this.reqif10Factory.createAttributeDefinitionString();
        ad1.setType(ddString);
        ad1.setLongName("Description");
        ad1.setLastChange(reqIFLastChange);
        specObjectType.getSpecAttributes().add((Object)ad1);
        SpecificationType specificationType = this.reqif10Factory.createSpecificationType();
        specificationType.setLongName("Specification Type");
        specificationType.setLastChange(reqIFLastChange);
        content.getSpecTypes().add((Object)specificationType);
        AttributeDefinitionString ad2 = this.reqif10Factory.createAttributeDefinitionString();
        ad2.setType(ddString);
        ad2.setLongName("Description");
        ad2.setLastChange(reqIFLastChange);
        specificationType.getSpecAttributes().add((Object)ad2);
        Specification spec = this.reqif10Factory.createSpecification();
        spec.setLongName("Specification Document");
        spec.setType(specificationType);
        spec.setLastChange(reqIFLastChange);
        AttributeValueString value1 = this.reqif10Factory.createAttributeValueString();
        value1.setTheValue("Requirements Document");
        value1.setDefinition(ad2);
        spec.getValues().add((Object)value1);
        content.getSpecifications().add((Object)spec);
        ProrToolExtension extension = ConfigurationFactory.eINSTANCE.createProrToolExtension();
        ReqIFToolExtensionUtil.addToolExtension((ReqIF)root, (EObject)extension);
        ProrSpecViewConfiguration prorSpecViewConfiguration = ConfigurationFactory.eINSTANCE.createProrSpecViewConfiguration();
        extension.getSpecViewConfigurations().add((Object)prorSpecViewConfiguration);
        prorSpecViewConfiguration.setSpecification(spec);
        Column col = ConfigurationFactory.eINSTANCE.createColumn();
        col.setLabel("Description");
        col.setWidth(400);
        prorSpecViewConfiguration.getColumns().add((Object)col);
        Column leftHeaderColumn = ConfigurationFactory.eINSTANCE.createColumn();
        leftHeaderColumn.setWidth(30);
        leftHeaderColumn.setLabel("Lead Header Column");
        prorSpecViewConfiguration.setLeftHeaderColumn(leftHeaderColumn);
        ProrGeneralConfiguration generalConfig = ConfigurationFactory.eINSTANCE.createProrGeneralConfiguration();
        LabelConfiguration labelConfig = ConfigurationFactory.eINSTANCE.createLabelConfiguration();
        labelConfig.getDefaultLabel().add((Object)"Description");
        generalConfig.setLabelConfiguration(labelConfig);
        extension.setGeneralConfiguration(generalConfig);
        SpecObject specObject = this.reqif10Factory.createSpecObject();
        specObject.setType(specObjectType);
        specObject.setLastChange(reqIFLastChange);
        content.getSpecObjects().add((Object)specObject);
        AttributeValueString value2 = this.reqif10Factory.createAttributeValueString();
        value2.setTheValue("Start editing here.");
        value2.setDefinition(ad1);
        specObject.getValues().add((Object)value2);
        SpecHierarchy specHierarchy = this.reqif10Factory.createSpecHierarchy();
        specHierarchy.setLastChange(reqIFLastChange);
        spec.getChildren().add((Object)specHierarchy);
        specHierarchy.setObject(specObject);
        return root;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            XMLPersistenceMappingResourceSetImpl resourceSet = new XMLPersistenceMappingResourceSetImpl();
                            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("reqif", new ReqIF10ResourceFactoryImpl());
                            resourceSet.getPackageRegistry().put((Object)"http://www.omg.org/spec/ReqIF/20110401/reqif.xsd", (Object)ReqIF10Package.eINSTANCE);
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = Reqif10ModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", "UTF-8");
                            resource.save(null);
                        }
                        catch (Exception exception) {
                            Reqif10EditorPlugin.INSTANCE.log(exception);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Reqif10EditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Reqif10EditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new Reqif10ModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(Reqif10EditorPlugin.INSTANCE.getString("_UI_Reqif10ModelWizard_label"));
        this.newFileCreationPage.setDescription(Reqif10EditorPlugin.INSTANCE.getString("_UI_Reqif10ModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(Reqif10EditorPlugin.INSTANCE.getString("_UI_Reqif10EditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = Reqif10EditorPlugin.INSTANCE.getString("_UI_Reqif10EditorFilenameDefaultBase");
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Reqif10ModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public Reqif10ModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Reqif10ModelWizardInitialObjectCreationPage.this.setPageComplete(Reqif10ModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(Reqif10EditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            for (String objectName : Reqif10ModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(Reqif10EditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : Reqif10ModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String typeName) {
            try {
                return Reqif10EditPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                Reqif10EditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(Reqif10EditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class Reqif10ModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public Reqif10ModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(Reqif10EditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

