/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.load;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.rmf.serialization.XMLPersistenceMappingResourceFactoryImpl;
import org.eclipse.rmf.tests.serialization.model.nodes.Node;
import org.eclipse.rmf.tests.serialization.model.nodes.NodesPackage;
import org.eclipse.rmf.tests.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FoereignNamespaceLoadTests
extends AbstractTestCase {
    static final String INPUT_PATH = "org.eclipse.rmf.tests.serialization.load/";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/serialization/model/nodes.ecore", (Object)NodesPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
    }

    @Test
    public void testEReference_Contained0001_Many_RegisteredPackage() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0001Many_KnownNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEPackageModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0001Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0001_Many_UnknownPackage() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0001Many_UnknownNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateUnknownModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0001Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0001_Many_RedefinedEmptyUnknownNamespace() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0001Many_RedefinedEmptyUnknownNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateUnknownModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0001Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0001_Many_RegisteredPackage_EmptyRootNamespace() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0001Many_EmptyRootNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEPackageModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0001Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0001_Many_RegisteredPackage_RedefinedEmptyNamespace() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0001Many_RedefinedEmptyNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEPackageModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0001Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0100_Many_RegisteredPackage() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0100Many_KnownNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEPackageModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0100Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0100_Many_UnknownPackage() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0100Many_UnknownNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateUnknownModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0100Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0100_Many_RegisteredPackage_EmptyRootNamespace() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0100Many_EmptyRootNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEPackageModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0100Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0100_Many_RegisteredPackage_RedefinedEmptyNamespace() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0100Many_RedefinedEmptyNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateEPackageModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0100Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    @Test
    public void testEReference_Contained0100_Many_RegisteredPackage_RedefinedEmptyUnknownNamespace() {
        String inputFileName = "org.eclipse.rmf.tests.serialization.load/EReference_WithTypeEObject_Contained0100Many_RedefinedEmptyUnknownNamespace.xml";
        try {
            EObject modelRoot = this.loadInputFile(inputFileName, (ResourceFactoryImpl)new XMLPersistenceMappingResourceFactoryImpl(), null);
            this.validateUnknownModelMany(modelRoot, (EStructuralFeature)NodesPackage.eINSTANCE.getNode_EReference_WithTypeEObject_Contained0100Many());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    protected void validateEPackageModelMany(EObject modelRoot, EStructuralFeature topFeature) {
        assert (topFeature.isMany());
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        EList packages = (EList)node.eGet(topFeature);
        Assert.assertSame((Object)2, (Object)packages.size());
        Object packageObject1 = packages.get(0);
        Assert.assertTrue((boolean)(packageObject1 instanceof EPackage));
        EPackage package1 = (EPackage)packageObject1;
        Assert.assertSame((Object)2, (Object)package1.getEClassifiers().size());
        Object packageObject2 = packages.get(0);
        Assert.assertTrue((boolean)(packageObject2 instanceof EPackage));
        EPackage package2 = (EPackage)packageObject2;
        Assert.assertSame((Object)2, (Object)package2.getEClassifiers().size());
    }

    protected void validateUnknownModelMany(EObject modelRoot, EStructuralFeature topFeature) {
        assert (topFeature.isMany());
        Assert.assertNotNull((Object)modelRoot);
        Assert.assertSame((Object)NodesPackage.eINSTANCE.getNode(), (Object)modelRoot.eClass());
        Node node = (Node)modelRoot;
        EList packages = (EList)node.eGet(topFeature);
        Assert.assertSame((Object)2, (Object)packages.size());
        Object packageObject1 = packages.get(0);
        Assert.assertTrue((boolean)(packageObject1 instanceof AnyType));
        AnyType package1 = (AnyType)packageObject1;
        EClass ePackageClass1 = package1.eClass();
        Assert.assertEquals((Object)"EPackage", (Object)ePackageClass1.getName());
        Assert.assertSame((Object)3, (Object)ePackageClass1.getFeatureCount());
        Assert.assertSame((Object)2, (Object)package1.getAny().size());
        Assert.assertEquals((Object)"EPackage1", (Object)package1.getAnyAttribute().getValue(0));
        Assert.assertEquals((Object)"eClassifiers", (Object)((FeatureMap.Entry)package1.getAny().get(0)).getEStructuralFeature().getName());
        Assert.assertEquals((Object)"EClass11", (Object)((AnyType)((FeatureMap.Entry)package1.getAny().get(0)).getValue()).getAnyAttribute().getValue(0));
        Assert.assertEquals((Object)"EClass12", (Object)((AnyType)((FeatureMap.Entry)package1.getAny().get(1)).getValue()).getAnyAttribute().getValue(0));
        Object packageObject2 = packages.get(1);
        Assert.assertTrue((boolean)(packageObject2 instanceof AnyType));
        AnyType package2 = (AnyType)packageObject2;
        EClass ePackageClass2 = package2.eClass();
        Assert.assertEquals((Object)"EPackage", (Object)ePackageClass2.getName());
        Assert.assertSame((Object)3, (Object)ePackageClass2.getFeatureCount());
        Assert.assertSame((Object)2, (Object)package2.getAny().size());
        Assert.assertEquals((Object)"EPackage2", (Object)package2.getAnyAttribute().getValue(0));
        Assert.assertEquals((Object)"eClassifiers", (Object)((FeatureMap.Entry)package2.getAny().get(0)).getEStructuralFeature().getName());
        Assert.assertEquals((Object)"EClass21", (Object)((AnyType)((FeatureMap.Entry)package2.getAny().get(0)).getValue()).getAnyAttribute().getValue(0));
        Assert.assertEquals((Object)"EClass22", (Object)((AnyType)((FeatureMap.Entry)package2.getAny().get(1)).getValue()).getAnyAttribute().getValue(0));
    }
}

