/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.util;

import java.util.GregorianCalendar;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIFHeader;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlFactory;
import org.eclipse.rmf.reqif10.xhtml.XhtmlPType;
import org.eclipse.rmf.tests.reqif10.serialization.util.ReqIFContentModelBuilder;

public class SimpleModelBuilder
extends ReqIFContentModelBuilder {
    private final String comment;
    private final GregorianCalendar creationTime;
    private final String identifier;
    private final String repositoryId;
    private final String reqIfToolId;
    private final String reqIfVersion;
    private final String sourceToolId;
    private final String title;

    public SimpleModelBuilder(String identifier, String title) throws Exception {
        this(null, identifier, title);
    }

    public SimpleModelBuilder(String creationTimeString, String identifier, String title) throws Exception {
        this(creationTimeString, identifier, "RMF - Requirements Modeling Framework (http://www.eclipse.org/rmf)", "RMF - Requirements Modeling Framework (http://www.eclipse.org/rmf)", title);
    }

    public SimpleModelBuilder(String creationTimeString, String identifier, String reqIfToolId, String sourceToolId, String title) throws Exception {
        this(null, creationTimeString, identifier, null, reqIfToolId, sourceToolId, title);
    }

    public SimpleModelBuilder(String comment, String creationTimeString, String identifier, String repositoryId, String reqIfToolId, String sourceToolId, String title) throws Exception {
        this(comment, creationTimeString, identifier, repositoryId, reqIfToolId, "1.0", sourceToolId, title);
    }

    public SimpleModelBuilder(String comment, String creationTimeString, String identifier, String repositoryId, String reqIfToolId, String reqIfVersion, String sourceToolId, String title) throws Exception {
        this.comment = comment;
        this.creationTime = this.toDate(creationTimeString);
        this.identifier = identifier;
        this.repositoryId = repositoryId;
        this.reqIfToolId = reqIfToolId;
        this.reqIfVersion = reqIfVersion;
        this.sourceToolId = sourceToolId;
        this.title = title;
    }

    @Override
    public void createReqIFHeader() throws Exception {
        ReqIFHeader reqIfHeader = ReqIF10Factory.eINSTANCE.createReqIFHeader();
        this.getReqIF().setTheHeader(reqIfHeader);
        if (this.comment != null) {
            reqIfHeader.setComment(this.comment);
        }
        if (this.creationTime != null) {
            reqIfHeader.setCreationTime(this.creationTime);
        } else {
            reqIfHeader.setCreationTime(this.getCurrentDate());
        }
        if (this.identifier != null) {
            reqIfHeader.setIdentifier(this.identifier);
        }
        if (this.repositoryId != null) {
            reqIfHeader.setRepositoryId(this.repositoryId);
        }
        if (this.reqIfToolId != null) {
            reqIfHeader.setReqIFToolId(this.reqIfToolId);
        }
        if (this.reqIfVersion != null) {
            reqIfHeader.setReqIFVersion(this.reqIfVersion);
        }
        if (this.sourceToolId != null) {
            reqIfHeader.setSourceToolId(this.sourceToolId);
        }
        if (this.title != null) {
            reqIfHeader.setTitle(this.title);
        }
    }

    @Override
    public void createDatatypes() throws Exception {
    }

    @Override
    public void createSpecObjectTypes() throws Exception {
    }

    @Override
    public void createSpecificationTypes() throws Exception {
    }

    @Override
    public void createRelationGroups() throws Exception {
    }

    @Override
    public void createRelationGroupTypes() throws Exception {
    }

    @Override
    public void createSpecifications() throws Exception {
    }

    @Override
    public void createSpecObjects() throws Exception {
    }

    @Override
    public void createSpecRelations() throws Exception {
    }

    @Override
    public void createSpecRelationTypes() throws Exception {
    }

    @Override
    public void createToolExtensions() throws Exception {
    }

    public static XhtmlContent createXhtmlValue(String value) {
        XhtmlContent xhtmlContent = ReqIF10Factory.eINSTANCE.createXhtmlContent();
        XhtmlPType p = XhtmlFactory.eINSTANCE.createXhtmlPType();
        p.getXhtmlInlineMix().add((Object)FeatureMapUtil.createTextEntry((String)value));
        xhtmlContent.setXhtml((EObject)p);
        return xhtmlContent;
    }
}

