/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.serialization.env.emf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.DocumentRoot;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.MyreqifPackage;
import org.eclipse.rmf.tests.serialization.env.emf.myreqif.util.MyreqifResourceFactoryImpl;
import org.eclipse.rmf.tests.serialization.util.AbstractTestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFRoundtripTests
extends AbstractTestCase {
    public static final String DATA_BASEDIR = "org.eclipse.rmf.tests.serialization.env/data/";
    public static final String WORKING_BASEDIR = "org.eclipse.rmf.tests.serialization.env.emf/";
    private static HashMap<String, Object> backupRegistry = new HashMap();

    @BeforeClass
    public static void setupOnce() {
        backupRegistry = new HashMap();
        backupRegistry.putAll((Map<String, Object>)EPackage.Registry.INSTANCE);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        EPackage.Registry.INSTANCE.clear();
    }

    @AfterClass
    public static void tearDownOnce() {
        EPackage.Registry.INSTANCE.clear();
        EPackage.Registry.INSTANCE.putAll(backupRegistry);
    }

    @Test
    public void testRoundtrip() throws IOException {
        String inputFileName = "org.eclipse.rmf.tests.serialization.env/data/bare_toolExtensions_AnyTypeAndEcoreType.xml";
        String workingFileName = "org.eclipse.rmf.tests.serialization.env.emf/bare_toolExtensions_AnyTypeAndEcoreType.xml";
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2003/XMLType", (Object)XMLTypePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.w3.org/XML/1998/namespace", (Object)XMLNamespacePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/rmf/tests/serialization/env/myreqif.xsd", (Object)MyreqifPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        try {
            HashMap<String, Object> options = new HashMap<String, Object>();
            this.enableNewMethods(options);
            EObject root = this.loadInputFile(inputFileName, new MyreqifResourceFactoryImpl(), options);
            Assert.assertTrue((boolean)(root instanceof DocumentRoot));
            this.saveWorkingFile(workingFileName, root, new MyreqifResourceFactoryImpl(), options);
            Assert.assertTrue((boolean)true);
            String savedContents = this.loadWorkingFileAsString(workingFileName);
            Assert.assertTrue((boolean)savedContents.contains("<REQ-IF"));
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }

    protected void enableNewMethods(Map<String, Object> options) {
        HashMap<String, Boolean> parserFeatures = new HashMap<String, Boolean>();
        HashMap parserProperties = new HashMap();
        parserFeatures.put("http://xml.org/sax/features/namespaces", true);
        parserFeatures.put("http://xml.org/sax/features/namespace-prefixes", false);
        options.put("PARSER_FEATURES", parserFeatures);
        options.put("PARSER_PROPERTIES", parserProperties);
        options.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
    }
}

