/*******************************************************************************
 * Copyright (c) 2011, 2013 Formal Mind GmbH and University of Dusseldorf.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Michael Jastram - initial API and implementation
 ******************************************************************************/

package org.eclipse.rmf.reqif10.pror.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;
import org.eclipse.rmf.reqif10.pror.configuration.ConfigurationFactory;

/**
 * This is the item provider adapter for a {@link org.eclipse.rmf.reqif10.ReqIFToolExtension} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ReqIFToolExtensionItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReqIFToolExtensionItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

		}
		return itemPropertyDescriptors;
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS);
		}
		return childrenFeatures;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EStructuralFeature getChildFeature(Object object, Object child) {
		// Check the type of the specified child object and return the proper feature to use for
		// adding (see {@link AddCommand}) it as a child.

		return super.getChildFeature(object, child);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean shouldComposeCreationImage() {
		return true;
	}

	/**
	 * Missing image to prevent {@link NullPointerException} when accidentally building a command.
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/Missing.png"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		return getString("_UI_ReqIFToolExtension_type");
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(ReqIFToolExtension.class)) {
			case ReqIF10Package.REQ_IF_TOOL_EXTENSION__EXTENSIONS:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), true, false));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeValueXHTML()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeDefinitionXHTML()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createReqIFContent()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createReqIF()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createReqIFHeader()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createReqIFToolExtension()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createSpecObject()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createSpecObjectType()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createSpecification()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createSpecificationType()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createSpecHierarchy()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createSpecRelation()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createSpecRelationType()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createRelationGroup()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createRelationGroupType()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createDatatypeDefinitionXHTML()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAlternativeID()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeDefinitionBoolean()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createDatatypeDefinitionBoolean()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeValueBoolean()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeDefinitionDate()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createDatatypeDefinitionDate()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeValueDate()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createDatatypeDefinitionEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createEnumValue()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createEmbeddedValue()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeValueEnumeration()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeDefinitionInteger()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createDatatypeDefinitionInteger()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeValueInteger()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeDefinitionReal()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createDatatypeDefinitionReal()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeValueReal()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeDefinitionString()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createDatatypeDefinitionString()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createAttributeValueString()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ReqIF10Factory.eINSTANCE.createXhtmlContent()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ConfigurationFactory.eINSTANCE.createProrToolExtension()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ConfigurationFactory.eINSTANCE.createProrSpecViewConfiguration()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ConfigurationFactory.eINSTANCE.createColumn()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ConfigurationFactory.eINSTANCE.createProrPresentationConfigurations()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ConfigurationFactory.eINSTANCE.createProrGeneralConfiguration()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 ConfigurationFactory.eINSTANCE.createLabelConfiguration()));

		newChildDescriptors.add
			(createChildParameter
				(ReqIF10Package.Literals.REQ_IF_TOOL_EXTENSION__EXTENSIONS,
				 XMLTypeFactory.eINSTANCE.createAnyType()));
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return Reqif10EditPlugin.INSTANCE;
	}

}
